/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.jxbrowser.JxBrowserFocusManager;
import com.mathworks.html.jxbrowser.JxBrowserKeyEvent;
import com.mathworks.html.jxbrowser.JxBrowserMouseAdapter;
import com.mathworks.html.jxbrowser.JxBrowserZoomHandler;
import com.mathworks.html.jxbrowser.KeyEventHandler;
import com.teamdev.jxbrowser.Browser;
import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class JxBrowserSwingComponent
extends JPanel {
    private final Browser fBrowser;
    private boolean fDisposed = false;
    private KeyEventHandler fKeyEventHandler;
    private JxBrowserFocusManager fFocusManager;

    JxBrowserSwingComponent(Browser browser) {
        super(new BorderLayout());
        this.fBrowser = browser;
    }

    void dispose() {
        this.fDisposed = true;
        if (this.fFocusManager != null) {
            this.fFocusManager.remove();
        }
    }

    Browser getBrowser() {
        return this.fBrowser;
    }

    void initialize() {
        this.fFocusManager = new JxBrowserFocusManager(this);
        this.fFocusManager.install();
        JxBrowserMouseAdapter.install(this);
        this.addKeyListener(new JxBrowserZoomHandler(this.fBrowser));
    }

    JxBrowserFocusManager getFocusManager() {
        return this.fFocusManager;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent instanceof JxBrowserKeyEvent) {
            return true;
        }
        if (this.fKeyEventHandler != null) {
            boolean bl2 = this.fKeyEventHandler.interceptKeyEvent(this, keyEvent);
            KeyStroke keyStroke2 = KeyStroke.getKeyStrokeForEvent(keyEvent);
            boolean bl3 = super.processKeyBinding(keyStroke2, keyEvent, n, bl);
            return bl3 || !bl2;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        if (!this.fDisposed) {
            this.fBrowser.getComponent().addKeyListener(keyListener);
        }
    }

    @Override
    public synchronized void removeKeyListener(KeyListener keyListener) {
        super.removeKeyListener(keyListener);
        if (!this.fDisposed) {
            this.fBrowser.getComponent().removeKeyListener(keyListener);
        }
    }

    void setKeyEventHandler(KeyEventHandler keyEventHandler) {
        this.fKeyEventHandler = keyEventHandler;
    }
}

