/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.text.JTextComponent;

public class SelectAllOnFocusListener {
    private final JTextComponent fText;
    private FocusListener fFocusListener;
    private MouseListener fMouseListener;
    private SelectAllBehavior fSelectAllBehavior;
    private boolean fShouldSelectAll = true;

    public SelectAllOnFocusListener(JTextComponent jTextComponent) {
        this(jTextComponent, SelectAllBehavior.ALWAYS);
    }

    public SelectAllOnFocusListener(JTextComponent jTextComponent, SelectAllBehavior selectAllBehavior) {
        if (jTextComponent == null) {
            throw new IllegalArgumentException("'text' cannot be null");
        }
        if (selectAllBehavior == null) {
            throw new IllegalArgumentException("SelectAllBehavior cannot be null.");
        }
        this.fText = jTextComponent;
        this.fSelectAllBehavior = selectAllBehavior;
        this.createAndInstallListeners();
    }

    private void createAndInstallListeners() {
        this.fFocusListener = this.createFocusListener();
        this.fMouseListener = this.createMouseListener();
        this.fText.addFocusListener(this.fFocusListener);
        this.fText.addMouseListener(this.fMouseListener);
    }

    private void uninstallAndNullifyListeners() {
        this.fText.removeFocusListener(this.fFocusListener);
        this.fText.removeMouseListener(this.fMouseListener);
        this.fFocusListener = null;
        this.fMouseListener = null;
    }

    public void setEnabled(boolean bl) {
        if (bl && this.fFocusListener == null && this.fMouseListener == null) {
            this.createAndInstallListeners();
        } else if (!bl && this.fFocusListener != null && this.fMouseListener != null) {
            this.uninstallAndNullifyListeners();
        }
    }

    public void selectAllIfFocusGainedWouldResultInSelectAll() {
        if (this.fText.getSelectionStart() == this.fText.getSelectionEnd()) {
            this.doFocusGained();
        }
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SelectAllOnFocusListener.this.fShouldSelectAll = SelectAllOnFocusListener.this.fSelectAllBehavior != SelectAllBehavior.KEYBOARD;
            }
        };
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SelectAllOnFocusListener.this.doFocusGained();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SelectAllOnFocusListener.this.doFocusLost(focusEvent.isTemporary());
            }
        };
    }

    private void doFocusGained() {
        if (this.fShouldSelectAll && this.fText.getWidth() > 0 && this.fText.getHeight() > 0) {
            this.fText.selectAll();
        }
    }

    private void doFocusLost(boolean bl) {
        if (bl) {
            this.fShouldSelectAll = false;
        } else {
            this.fShouldSelectAll = true;
            int n = this.fText.getCaret().getDot();
            this.fText.getCaret().setDot(0);
            this.fText.getCaret().setDot(n);
        }
    }

    public static enum SelectAllBehavior {
        ALWAYS,
        KEYBOARD;

    }
}

