/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.MetaBindingUtils;
import com.mathworks.mwswing.binding.NavigationalBindingUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class KeyStrokeUtils {
    static final String SEQUENCE_TAG = "Sequence";
    static final String STROKE_TAG = "Stroke";
    static final String CODE_ATTRIBUTE = "code";
    static final String ALT_ATTRIBUTE = "alt";
    static final String ALT_GRAPH_ATTRIBUTE = "altgraph";
    static final String CTRL_ATTRIBUTE = "ctrl";
    static final String SYSCTRL_ATTRIBUTE = "sysctrl";
    static final String META_ATTRIBUTE = "meta";
    static final String SHIFT_ATTRIBUTE = "shift";
    static final String ON_VALUE = "on";
    static final Map<Object, String> sVK_ValueToNameMap = new HashMap<Object, String>();
    static final Map<String, Object> sVK_NameToValueMap = new HashMap<String, Object>();
    public static final int MENU_SHORTCUT_KEY_MASK = GraphicsEnvironment.isHeadless() ? 2 : Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public static String translateKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            throw new IllegalArgumentException("'stroke' cannot be null");
        }
        return KeyStrokeUtils.translateKeyStrokes(new KeyStrokeList(keyStroke));
    }

    public static String translateKeyStrokes(KeyStrokeList keyStrokeList) {
        if (keyStrokeList == null) {
            throw new IllegalArgumentException("'strokes' cannot be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        KeyStroke[] keyStrokeArray = keyStrokeList.toKeyStrokeArray();
        for (int i = 0; i != keyStrokeArray.length; ++i) {
            KeyStroke keyStroke = keyStrokeArray[i];
            String string = UIManager.getString("MenuItem.acceleratorDelimiter");
            if (string == null) {
                string = "";
            }
            String string2 = KeyEvent.getModifiersExText(keyStroke.getModifiers());
            if (PlatformInfo.isMacintosh()) {
                string2 = StringUtils.remove((String)string2, (String)"+");
            }
            stringBuilder.append(string2);
            stringBuilder.append(string2.length() > 0 ? string : "");
            if (keyStroke.getKeyCode() != 0) {
                stringBuilder.append(KeyStrokeUtils.getKeyText(keyStroke.getKeyCode()));
            } else {
                stringBuilder.append(keyStroke.getKeyChar());
            }
            if (i == keyStrokeArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String translateKeyStrokesToAscii(KeyStrokeList keyStrokeList) {
        ArrayList<String> arrayList = new ArrayList<String>(keyStrokeList.getKeyStrokes().size());
        for (KeyStroke keyStroke : keyStrokeList.getKeyStrokes()) {
            String string = keyStroke.toString();
            string = keyStroke.getModifiers() != 0 ? string.replaceAll(" pressed ", "+") : string.replaceAll("pressed ", "");
            arrayList.add(string);
        }
        Object object = StringUtils.join(arrayList, (String)", ");
        if (PlatformInfo.isMacintosh()) {
            object = ((String)object).replaceAll(META_ATTRIBUTE, "cmd");
        }
        object = ((String)object).replaceAll("_", " ");
        object = ((String)object).toUpperCase();
        return object;
    }

    public static String getKeyText(int n) {
        int n2 = ",./;=[\\]".indexOf(n);
        if (n2 >= 0) {
            return String.valueOf((char)n);
        }
        return KeyEvent.getKeyText(n);
    }

    public static KeyStroke createKeyStroke(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        int n2 = 0;
        if (bl) {
            n2 |= 8;
        }
        if (bl2) {
            n2 |= 0x20;
        }
        if (bl3) {
            n2 |= MENU_SHORTCUT_KEY_MASK;
        }
        if (bl4) {
            n2 |= 2;
        }
        if (bl5) {
            n2 |= 4;
        }
        if (bl6) {
            n2 |= 1;
        }
        return KeyStroke.getKeyStroke(n, n2);
    }

    public static String appendShortcut(String string, ExtendedAction extendedAction) {
        Validate.notNull((Object)extendedAction);
        if (string == null || string.length() == 0) {
            return string;
        }
        KeyStroke keyStroke = extendedAction.getAccelerator();
        if (keyStroke != null) {
            return KeyStrokeUtils.formatTipWithKeybinding(string, KeyStrokeUtils.translateKeyStroke(keyStroke));
        }
        KeyStroke[] keyStrokeArray = extendedAction.getAcceleratorSequence();
        return keyStrokeArray != null ? KeyStrokeUtils.formatTipWithKeybinding(string, KeyStrokeUtils.translateKeyStrokes(new KeyStrokeList(keyStrokeArray))) : string;
    }

    private static String formatTipWithKeybinding(String string, String string2) {
        return string + " (" + string2 + ")";
    }

    public static void addAllBindingVariations(KeyStrokeList keyStrokeList, Collection<KeyStrokeList> collection) {
        for (KeyStrokeList keyStrokeList2 : KeyStrokeUtils.getAllBindingVariations(keyStrokeList)) {
            if (collection.contains(keyStrokeList2)) continue;
            collection.add(keyStrokeList2);
        }
    }

    static boolean removeAllBindingVariations(KeyStrokeList keyStrokeList, Collection<KeyStrokeList> collection) {
        return collection.removeAll(KeyStrokeUtils.getAllBindingVariations(keyStrokeList));
    }

    private static Collection<KeyStrokeList> getAllBindingVariations(KeyStrokeList keyStrokeList) {
        List<KeyStrokeList> list = NavigationalBindingUtils.hasNavigationalStrokes(keyStrokeList) ? NavigationalBindingUtils.getAllVersions(keyStrokeList) : Arrays.asList(keyStrokeList);
        ArrayList<KeyStrokeList> arrayList = new ArrayList<KeyStrokeList>();
        for (KeyStrokeList keyStrokeList2 : list) {
            if (MetaBindingUtils.hasAltOrMeta(keyStrokeList2)) {
                arrayList.addAll(MetaBindingUtils.getAllVersions(keyStrokeList2));
                continue;
            }
            arrayList.add(keyStrokeList2);
        }
        return arrayList;
    }

    private KeyStrokeUtils() {
    }

    static {
        try {
            Field[] fieldArray;
            Class<KeyEvent> clazz = KeyEvent.class;
            for (Field field : fieldArray = clazz.getFields()) {
                Object object;
                String string = field.getName();
                if (!string.startsWith("VK_") || !((object = field.get(null)) instanceof Integer)) continue;
                sVK_ValueToNameMap.put(object, string);
                sVK_NameToValueMap.put(string, object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.logException((Exception)illegalAccessException);
        }
    }
}

