/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.distcomp.admincenter.AboutWindow;
import com.mathworks.toolbox.distcomp.admincenter.ChangeBaseportAction;
import com.mathworks.toolbox.distcomp.admincenter.NewSessionAction;
import com.mathworks.toolbox.distcomp.admincenter.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.PersistenceManager;
import com.mathworks.toolbox.distcomp.admincenter.SessionImporter;
import com.mathworks.toolbox.distcomp.admincenter.TestDataAccessor;
import com.mathworks.toolbox.distcomp.admincenter.guiutilities.ACHelpBrowser;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.DefaultSystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateTimer;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ModulePane;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.ui.BrowserLauncher;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

class ToolkitMenuBar
extends MJMenuBar {
    private final PersistenceManager fPersistenceManager;
    private final UpdateTimer fUpdateTimer;
    private final ClientMonitor fMonitor;
    private final TestDataAccessor fTestDataAccessor;
    private static final String INSTALL_URL = "http://www.mathworks.com/distconfig";
    private static final String PRODUCT_SUPPORT_URL = "http://www.mathworks.com/support/product/product.html?product=DM";

    ToolkitMenuBar(ClientMonitor clientMonitor, TestDataAccessor testDataAccessor, ModulePane<?>[] modulePaneArray, PersistenceManager persistenceManager, UpdateTimer updateTimer) {
        this.fMonitor = clientMonitor;
        this.fTestDataAccessor = testDataAccessor;
        this.fPersistenceManager = persistenceManager;
        this.fUpdateTimer = updateTimer;
        this.add(this.createFileMenu());
        for (ModulePane<?> modulePane : modulePaneArray) {
            MJMenu mJMenu = new MJMenu(modulePane.getActionName());
            List<JComponent> list = modulePane.getMenubarComponents();
            for (JComponent jComponent : list) {
                mJMenu.add((Component)jComponent);
            }
            this.add((JMenu)mJMenu);
        }
        this.add(this.createHelpMenu());
    }

    private JMenu createHelpMenu() {
        MJMenu mJMenu = new MJMenu(ResourceStatics.sRes.getString("menu.help.name"));
        MJAbstractAction mJAbstractAction = new MJAbstractAction(ResourceStatics.sRes.getString("menu.help.admincenter")){

            public void actionPerformed(ActionEvent actionEvent) {
                ACHelpBrowser.browseToShortcut((Component)((Object)ToolkitMenuBar.this), "ADMINCENTER");
            }
        };
        mJMenu.add((Action)mJAbstractAction);
        mJMenu.addSeparator();
        String[] stringArray = new String[]{"menu.help.external.installation", INSTALL_URL, "menu.help.external.support", PRODUCT_SUPPORT_URL};
        for (int i = 0; i < stringArray.length; i += 2) {
            try {
                final URL uRL = new URL(stringArray[i + 1]);
                MJAbstractAction mJAbstractAction2 = new MJAbstractAction(ResourceStatics.sRes.getString(stringArray[i])){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BrowserLauncher.launchURL((Frame)ToolkitMenuBar.this.getTopLevelAncestor(), uRL);
                    }
                };
                mJMenu.add((Action)mJAbstractAction2);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Bad URL in code", malformedURLException);
            }
        }
        mJMenu.addSeparator();
        AbstractAction abstractAction = new AbstractAction(ResourceStatics.sRes.getString("menu.help.about")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new AboutWindow(MJFrame.getFrame((Component)((Object)ToolkitMenuBar.this))).setVisible(true);
            }
        };
        mJMenu.add((Action)abstractAction);
        return mJMenu;
    }

    private JMenu createFileMenu() {
        MJMenu mJMenu = new MJMenu(ResourceStatics.sRes.getString("menu.file.name"));
        NewSessionAction newSessionAction = new NewSessionAction(this.fMonitor, this.fTestDataAccessor);
        ChangeBaseportAction changeBaseportAction = new ChangeBaseportAction(this.fMonitor);
        MJAbstractAction mJAbstractAction = new MJAbstractAction(ResourceStatics.sRes.getString("menu.file.import")){

            public void actionPerformed(ActionEvent actionEvent) {
                MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
                mJFileChooserPerPlatform.setDialogTitle(ResourceStatics.sRes.getString("menu.file.import.title"));
                mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)new FileExtensionFilter(ResourceStatics.sRes.getString("mdcs.filter.descr"), "mdcs", false));
                mJFileChooserPerPlatform.setAcceptAllFileFilterUsed(false);
                mJFileChooserPerPlatform.showOpenDialog((Component)4.getFrame((ActionEvent)actionEvent));
                if (0 == mJFileChooserPerPlatform.getState()) {
                    ToolkitMenuBar.this.fUpdateTimer.setFreqSeconds(0);
                    File file = mJFileChooserPerPlatform.getSelectedFile();
                    SystemErrorHandler systemErrorHandler = ToolkitMenuBar.this.createImportErrorHandler(file);
                    SessionImporter sessionImporter = ToolkitMenuBar.this.fPersistenceManager.getFileImporter(file, systemErrorHandler);
                    ToolkitMenuBar.this.fMonitor.importData(sessionImporter);
                    try {
                        ToolkitMenuBar.this.fTestDataAccessor.setTestData(sessionImporter.getTestData());
                    }
                    catch (Exception exception) {
                        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Problem saving the test data.", exception);
                    }
                }
            }
        };
        MJAbstractAction mJAbstractAction2 = new MJAbstractAction(ResourceStatics.sRes.getString("menu.file.export")){

            public void actionPerformed(ActionEvent actionEvent) {
                MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
                mJFileChooserPerPlatform.setDialogTitle(ResourceStatics.sRes.getString("menu.file.export.title"));
                mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)new FileExtensionFilter(ResourceStatics.sRes.getString("mdcs.filter.descr"), "mdcs", false));
                mJFileChooserPerPlatform.setAcceptAllFileFilterUsed(false);
                mJFileChooserPerPlatform.showSaveDialog((Component)5.getFrame((ActionEvent)actionEvent));
                if (0 == mJFileChooserPerPlatform.getState()) {
                    Object object;
                    File file;
                    File file2 = mJFileChooserPerPlatform.getSelectedFile();
                    if (file2 == null || file2.getName().toLowerCase().endsWith(".mdcs")) {
                        file = file2;
                    } else {
                        object = file2.getName();
                        int n = ((String)object).lastIndexOf(46);
                        if (n != -1) {
                            object = ((String)object).substring(0, n);
                        }
                        file = new File(file2.getParent(), (String)object + ".mdcs");
                    }
                    object = ToolkitMenuBar.this.createExportErrorHandler(file);
                    ToolkitMenuBar.this.fPersistenceManager.exportSession(ToolkitMenuBar.this.fMonitor.getBaseport(), ToolkitMenuBar.this.fMonitor.getServiceInfo(), ToolkitMenuBar.this.fTestDataAccessor.getTestData(), file, (SystemErrorHandler)object);
                }
            }
        };
        boolean bl = !Matlab.isMatlabAvailable();
        String string = bl ? ResourceStatics.sRes.getString("menu.file.exit") : ResourceStatics.sRes.getString("menu.file.close");
        AbstractAction abstractAction = new AbstractAction(String.format(string, ResourceStatics.sRes.getString("application.name"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.getWindowAncestor((Component)((Object)ToolkitMenuBar.this)).dispose();
            }
        };
        mJMenu.add((Action)((Object)newSessionAction));
        mJMenu.addSeparator();
        mJMenu.add((Action)((Object)changeBaseportAction));
        mJMenu.addSeparator();
        mJMenu.add((Action)mJAbstractAction);
        mJMenu.add((Action)mJAbstractAction2);
        mJMenu.addSeparator();
        mJMenu.add((Action)abstractAction);
        return mJMenu;
    }

    private SystemErrorHandler createExportErrorHandler(final File file) {
        assert (file != null) : "Cannot be used with a null file.";
        return new DefaultSystemErrorHandler(){

            @Override
            public void handleError(Exception exception) {
                super.handleError(exception);
                String string = ResourceStatics.sRes.getString("dialog.error.export.title");
                String string2 = String.format(ResourceStatics.sRes.getString("dialog.error.export.message"), file.getPath());
                MJOptionPane.showMessageDialog((Component)((Object)ToolkitMenuBar.this), (Object)string2, (String)string, (int)0);
            }
        };
    }

    private SystemErrorHandler createImportErrorHandler(final File file) {
        assert (file != null) : "Cannot be used with null files.";
        return new DefaultSystemErrorHandler(){

            @Override
            public void handleError(Exception exception) {
                String string;
                String string2;
                super.handleError(exception);
                if (exception instanceof PersistenceManager.VersionException) {
                    string2 = ResourceStatics.sRes.getString("dialog.error.import_version.title");
                    PersistenceManager.VersionException versionException = (PersistenceManager.VersionException)exception;
                    String string3 = versionException.getVersion();
                    String string4 = string3 != null ? "dialog.error.import_version_known.message" : "dialog.error.import_version_unknown.message";
                    String string5 = ResourceStatics.sRes.getString(string4);
                    string = string3 != null ? String.format(string5, file.getPath(), string3) : String.format(string5, file.getPath());
                } else {
                    string2 = ResourceStatics.sRes.getString("dialog.error.import.title");
                    string = String.format(ResourceStatics.sRes.getString("dialog.error.import.message"), file.getPath());
                }
                MJOptionPane.showMessageDialog((Component)((Object)ToolkitMenuBar.this), (Object)string, (String)string2, (int)0);
            }
        };
    }
}

