/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.infra;

import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.control.servicerequest.RequestResponse;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JobRunner<R extends RequestResponse> {
    private HashMap<Future<R>, R> fDefaultResponses;
    private ExecutorService fExecutor;
    private Vector<Future<R>> fFutures;
    private Vector<R> fResults;

    public JobRunner(ExecutorService executorService) {
        this.fExecutor = executorService;
        this.fDefaultResponses = new HashMap();
        this.fFutures = new Vector();
        this.fResults = new Vector();
    }

    public synchronized void addNewTask(Callable<R> callable, R r) {
        Future<R> future;
        try {
            future = this.fExecutor.submit(callable);
        }
        catch (Throwable throwable) {
            ((RequestResponse)r).setThrowable(throwable);
            this.fResults.add(r);
            return;
        }
        this.fDefaultResponses.put(future, r);
        this.fFutures.add(future);
    }

    public synchronized Collection<R> getResults() {
        return this.fResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion(long l) throws MDCSTimeoutException {
        long l2 = System.currentTimeMillis();
        while (this.fFutures.size() > 0) {
            long l3;
            JobRunner jobRunner = this;
            synchronized (jobRunner) {
                Iterator<Future<R>> iterator = this.fFutures.iterator();
                while (iterator.hasNext()) {
                    Future<R> future = iterator.next();
                    R r = this.getResultFromFuture(future);
                    if (r == null) continue;
                    this.fResults.add(r);
                    iterator.remove();
                    l2 = System.currentTimeMillis();
                }
            }
            try {
                Thread.sleep(TimeOutConstants.JOB_RUNNER_WAIT_FOR_COMPLETION_THREAD_SLEEP_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((l3 = System.currentTimeMillis() - l2) <= l * 1000L) continue;
            throw new MDCSTimeoutException(l);
        }
    }

    public void cancelAllTasks(Throwable throwable) {
        Collections.reverse(this.fFutures);
        for (Future<R> future : this.fFutures) {
            future.cancel(true);
        }
        Iterator<Future<R>> iterator = this.fFutures.iterator();
        while (iterator.hasNext()) {
            Future<R> future;
            future = iterator.next();
            Object object = this.getResultFromFuture(future);
            if (object == null) {
                object = (RequestResponse)this.fDefaultResponses.get(future);
            }
            ((RequestResponse)object).setThrowable(throwable);
            this.fResults.add(object);
            iterator.remove();
        }
    }

    private R getResultFromFuture(Future<R> future) {
        try {
            RequestResponse requestResponse = (RequestResponse)future.get(0L, TimeUnit.SECONDS);
            return (R)requestResponse;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
        catch (Throwable throwable) {
            RequestResponse requestResponse = (RequestResponse)this.fDefaultResponses.get(future);
            requestResponse.setThrowable(throwable);
            return (R)requestResponse;
        }
    }

    public static class MDCSTimeoutException
    extends DistcompDiagnosticException {
        private static final String RES_KEY = "MDCS_TIMEOUT_EXCEPTION";

        MDCSTimeoutException(long l) {
            super(null, RES_KEY, l);
        }
    }
}

