/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.model.HostColumn;
import com.mathworks.toolbox.distcomp.admincenter.services.model.Hostname;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceTableModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StatusModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StringList;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import java.util.HashSet;
import java.util.Set;

public class HostTableModel
extends ServiceTableModel<MDCSServiceInfo, HostColumn> {
    @Override
    protected Class<HostColumn> initColumnEnum() {
        return HostColumn.class;
    }

    @Override
    protected Object getValue(MDCSServiceInfo mDCSServiceInfo, HostColumn hostColumn) {
        assert (mDCSServiceInfo != null) : "info must not be null.";
        assert (hostColumn != null) : "column must not be null.";
        switch (hostColumn) {
            case HOSTNAME: {
                return new Hostname(mDCSServiceInfo);
            }
            case HOST_REACHABLE: {
                return StatusModel.getHostReachableStatusModel(mDCSServiceInfo);
            }
            case CORES: {
                return mDCSServiceInfo.getNumCores();
            }
            case JOB_MANAGERS: {
                return new StringList(mDCSServiceInfo.getJobManagerNames());
            }
            case MDCE_STATUS: {
                return StatusModel.getMDCSServiceStatusModel(mDCSServiceInfo);
            }
            case START_TIME: {
                return mDCSServiceInfo.getStartTime();
            }
            case WORKERS: {
                return mDCSServiceInfo.getWorkerNames().size();
            }
        }
        return null;
    }

    public Set<Host> getHosts() {
        HashSet<Host> hashSet = new HashSet<Host>();
        for (MDCSServiceInfo mDCSServiceInfo : this.getInfoList()) {
            hashSet.add(mDCSServiceInfo.getHost());
        }
        return hashSet;
    }
}

