/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.model;

import com.mathworks.toolbox.distcomp.admincenter.services.model.HostDetailModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.JobManagerDetailModel;
import com.mathworks.toolbox.distcomp.admincenter.services.model.WorkerDetailModel;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NoValidMDCSHostnameException;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NodeServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ServiceDetailModel<SI extends ServiceInfo> {
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(ServiceDetailModel.class);
    private final Property<SI>[] fProperties;

    protected ServiceDetailModel(Class<? extends Property<SI>> clazz) {
        assert (clazz != null) : "propClass must not be null";
        assert (clazz.isEnum()) : "propClass must be an enum";
        this.fProperties = clazz.getEnumConstants();
    }

    public static <I extends ServiceInfo> ServiceDetailModel<I> getModel(I i) {
        assert (i != null) : "info must not be null.";
        if (i instanceof MDCSServiceInfo) {
            return new HostDetailModel();
        }
        if (i instanceof JobManagerServiceInfo) {
            return new JobManagerDetailModel();
        }
        if (i instanceof WorkerServiceInfo) {
            return new WorkerDetailModel();
        }
        throw new UnsupportedOperationException("ServiceInfo class \"" + i.getClass().getName() + "\" not supported.");
    }

    public String getPropertyName(Property property) {
        assert (property != null) : "property may not be null.";
        String string = "service.detail." + property.getClass().getSimpleName() + "." + property.name();
        return sRes.getString(string, new Object[0]);
    }

    public abstract Object getValue(SI var1, Property<SI> var2);

    public List<Property<SI>> getProperties() {
        return new ArrayList<Property<SI>>(Arrays.asList(this.fProperties));
    }

    protected Object getLookupURLsInConfiguration(NodeServiceInfo<?> nodeServiceInfo) {
        List<String> list = nodeServiceInfo.getLookupURLsInConfiguration();
        if (list != null && list.size() == 0) {
            return new UsingMulticast();
        }
        return list;
    }

    protected Object getBestHostname(ServiceInfo serviceInfo) {
        try {
            return serviceInfo.getMDCSHostName();
        }
        catch (NoValidMDCSHostnameException noValidMDCSHostnameException) {
            return serviceInfo.getHostName();
        }
    }

    public static interface Property<I extends ServiceInfo> {
        public String name();
    }

    public class UsingMulticast {
        public String toString() {
            return "*Using multicast*";
        }
    }
}

