/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequest;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequestCreator;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ModuleAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ServiceAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.JobManagerTableModel;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ModulePane;
import com.mathworks.toolbox.distcomp.admincenter.services.view.RestartJMAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceInfoTable;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceInfoTableTargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceStatusTargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StartJMAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StartWorkersAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StopDestroyJMAction;
import com.mathworks.toolbox.distcomp.admincenter.services.view.TableModelRowsTargetSource;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.control.servicerequest.JobManagerServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

public class JobManagerModulePane
extends ModulePane<JobManagerTableModel> {
    private static final String HELP = "AC_JOBMANAGER_MODULE";
    private static final String COMP_NAME_START = "startJobManager";
    private static final String COMP_NAME_STOP = "stopJobManager";
    private static final String COMP_NAME_DESTROY = "destroy";
    private static final String COMP_NAME_RESUME = "resumeJobManager";
    private static final String COMP_NAME_RESTART = "restart";
    private static final String COMP_NAME_START_WORKERS = "startWorkers";

    public JobManagerModulePane(ClientMonitor clientMonitor) {
        super(clientMonitor.getJobManagerTableModel(), ResourceStatics.sRes.getString("module.jobmanagers.name"), ResourceStatics.sRes.getString("module.jobmanagers.actionname"), HELP, clientMonitor);
        this.init();
    }

    @Override
    protected void initActions() {
        List<ModuleAction> list = this.getActionList(ModulePane.ActionPlacement.SHORTCUT);
        List<ModuleAction> list2 = this.getActionList(ModulePane.ActionPlacement.POPUP);
        List<ModuleAction> list3 = this.getActionList(ModulePane.ActionPlacement.MENUBAR);
        ServiceStatusTargetSource serviceStatusTargetSource = new ServiceStatusTargetSource(this.getMonitor(), this.getTable(), ServiceStatus.RUNNING);
        ServiceStatusTargetSource serviceStatusTargetSource2 = new ServiceStatusTargetSource(this.getMonitor(), this.getTable(), ServiceStatus.STOPPED);
        ServiceInfoTableTargetSource serviceInfoTableTargetSource = new ServiceInfoTableTargetSource(this.getMonitor(), this.getTable());
        ServiceStatusTargetSource serviceStatusTargetSource3 = new ServiceStatusTargetSource(this.getMonitor(), this.getTable(), ServiceStatus.RUNNING, ServiceInfoTableTargetSource.CountQuality.AT_LEAST_ONE);
        ServiceStatusTargetSource serviceStatusTargetSource4 = new ServiceStatusTargetSource(this.getMonitor(), this.getTable(), ServiceStatus.RUNNING, ServiceInfoTableTargetSource.CountQuality.EXACTLY_ONE);
        TableModelRowsTargetSource<MDCSServiceInfo> tableModelRowsTargetSource = new TableModelRowsTargetSource<MDCSServiceInfo>(this.getMonitor().getHostTableModel());
        ServiceAction serviceAction = new StartJMAction(ResourceStatics.sRes.getString("module.jm.action.start"), tableModelRowsTargetSource, COMP_NAME_START, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list.add(serviceAction);
        list3.add(serviceAction);
        serviceAction = new StopDestroyJMAction(serviceStatusTargetSource, COMP_NAME_STOP, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler(), false);
        list.add(serviceAction);
        list2.add(serviceAction);
        list3.add(serviceAction);
        ActionRequestCreator actionRequestCreator = new ActionRequestCreator(){

            @Override
            public ActionRequest createActionServiceRequest(ActionEvent actionEvent, ClientMonitor clientMonitor, TargetSource targetSource, SystemErrorHandler systemErrorHandler) {
                ServiceInfo[] serviceInfoArray = targetSource.getTargets().toArray(new ServiceInfo[targetSource.getTargets().size()]);
                ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
                for (ServiceInfo serviceInfo : serviceInfoArray) {
                    JobManagerServiceRequest jobManagerServiceRequest = JobManagerServiceRequest.createResumeRequest(serviceInfo.getServiceName(), serviceInfo.getHost(), clientMonitor.getBaseport());
                    arrayList.add(jobManagerServiceRequest);
                }
                return new ActionRequest(clientMonitor, false, arrayList, systemErrorHandler);
            }
        };
        serviceAction = new ServiceAction(ResourceStatics.sRes.getString("module.jm.action.resume"), serviceStatusTargetSource2, COMP_NAME_RESUME, actionRequestCreator, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list.add(serviceAction);
        list2.add(serviceAction);
        list3.add(serviceAction);
        serviceAction = new StopDestroyJMAction(serviceInfoTableTargetSource, COMP_NAME_DESTROY, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler(), true);
        list2.add(serviceAction);
        list3.add(serviceAction);
        serviceAction = new RestartJMAction(serviceStatusTargetSource4, COMP_NAME_RESTART, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list2.add(serviceAction);
        list3.add(serviceAction);
        serviceAction = new StartWorkersAction(ResourceStatics.sRes.getString("module.jm.action.startworkers"), serviceStatusTargetSource4, COMP_NAME_START_WORKERS, this.getResponseHandler(), this.getMonitor(), this.getProgressListener(), this.getErrorHandler());
        list2.add(serviceAction);
        list3.add(serviceAction);
    }

    @Override
    protected ServiceInfoTable<JobManagerTableModel> createTable() {
        return new ServiceInfoTable<JobManagerTableModel>((JobManagerTableModel)this.getTableModel());
    }
}

