/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequest;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequestCreator;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ResponseHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ServiceAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.SubmissionProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.view.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.services.view.StartWorkersDialog;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NoValidMDCSHostnameException;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.WorkerServiceRequest;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class StartWorkersAction
extends ServiceAction {
    public StartWorkersAction(String string, TargetSource targetSource, String string2, ResponseHandler responseHandler, ClientMonitor clientMonitor, SubmissionProgressListener submissionProgressListener, SystemErrorHandler systemErrorHandler) {
        super(string, targetSource, string2, new StartWorkersRequestCreator(), responseHandler, clientMonitor, submissionProgressListener, systemErrorHandler);
    }

    private static class StartWorkersRequestCreator
    implements ActionRequestCreator {
        private StartWorkersRequestCreator() {
        }

        @Override
        public ActionRequest createActionServiceRequest(ActionEvent actionEvent, ClientMonitor clientMonitor, TargetSource targetSource, SystemErrorHandler systemErrorHandler) {
            StartWorkersDialog startWorkersDialog = new StartWorkersDialog(MJAbstractAction.getFrame((ActionEvent)actionEvent), clientMonitor, targetSource);
            startWorkersDialog.pack();
            startWorkersDialog.setLocationRelativeTo(startWorkersDialog.getOwner());
            startWorkersDialog.show();
            ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
            if (!startWorkersDialog.isCancelled()) {
                StartWorkersDialog.StartWorkersInfo startWorkersInfo = (StartWorkersDialog.StartWorkersInfo)startWorkersDialog.getValue();
                String string = startWorkersInfo.getJobManager().getServiceName();
                String string2 = startWorkersInfo.getJobManager().getHostName();
                try {
                    string2 = startWorkersInfo.getJobManager().getMDCSHostName();
                }
                catch (NoValidMDCSHostnameException noValidMDCSHostnameException) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Could not retrieve jm mdcs hostname.", noValidMDCSHostnameException);
                }
                for (MDCSServiceInfo mDCSServiceInfo : startWorkersInfo.getHosts()) {
                    for (int i = 0; i < startWorkersInfo.getWorkersPerNode(); ++i) {
                        arrayList.add(WorkerServiceRequest.createStartRequest(null, mDCSServiceInfo.getHost(), string, string2));
                    }
                }
            }
            return new ActionRequest(clientMonitor, startWorkersDialog.isCancelled(), arrayList, systemErrorHandler);
        }
    }
}

