/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.ParsingException;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class CustomCommand
implements Serializable {
    private static HashMap<String, Vector<String>> sMethods = null;
    private String fHostname = null;
    private String fMethodName;
    private Integer fPort = null;
    private String fResult;
    private TestCategory fTestCategory = null;

    public CustomCommand(String string) {
        this(string, null);
    }

    public CustomCommand(String string, String string2) throws ParsingException {
        CustomCommand.initMethods();
        if (!sMethods.containsKey(string)) {
            throw new ParsingException("unknown method name " + string);
        }
        this.fMethodName = string;
        this.fResult = string2;
    }

    public String getResult() {
        return this.fResult;
    }

    public void set(String string, String string2) throws ParsingException {
        if (!sMethods.get(this.fMethodName).contains(string)) {
            throw new ParsingException("method does not support key " + string);
        }
        if (string.toUpperCase().equals("HOSTNAME")) {
            this.fHostname = string2;
        } else if (string.toUpperCase().equals("PORT")) {
            this.fPort = Integer.parseInt(string2);
        } else if (string.toUpperCase().equals("TESTCATEGORY")) {
            this.fTestCategory = this.stringToTestCategory(string2);
        }
    }

    public void setHostname(String string) {
        this.fHostname = string;
    }

    public void setPort(Integer n) {
        this.fPort = n;
    }

    public void setTestCategory(TestCategory testCategory) {
        this.fTestCategory = testCategory;
    }

    public boolean containsArguments(CustomCommand customCommand) {
        if (!this.fMethodName.equals(customCommand.fMethodName)) {
            return false;
        }
        if (this.fHostname != null && !this.fHostname.equals(customCommand.fHostname)) {
            return false;
        }
        if (this.fPort != null && !this.fPort.equals(customCommand.fPort)) {
            return false;
        }
        return this.fTestCategory == null || this.fTestCategory.equals((Object)customCommand.fTestCategory);
    }

    public String toString() {
        return this.fMethodName + "(" + this.fHostname + ", " + this.fPort + ", " + (Object)((Object)this.fTestCategory) + ") -> " + this.fResult;
    }

    private TestCategory stringToTestCategory(String string) throws ParsingException {
        for (TestCategory testCategory : TestCategory.values()) {
            if (!string.equals(testCategory.toString())) continue;
            return testCategory;
        }
        throw new ParsingException("unknown category " + string);
    }

    private static synchronized void initMethods() {
        if (sMethods != null) {
            return;
        }
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector2.add("HOSTNAME");
        vector3.add("PORT");
        vector4.add("HOSTNAME");
        vector4.add("PORT");
        vector5.add("TESTCATEGORY");
        sMethods = new HashMap();
        sMethods.put("getHostName", vector2);
        sMethods.put("getCanonicalHostName", vector2);
        sMethods.put("getHostAddress", vector2);
        sMethods.put("isReachable", vector2);
        sMethods.put("getLocalHostName", vector);
        sMethods.put("getAddressList", vector2);
        sMethods.put("isLoopbackAddress", vector2);
        sMethods.put("createSocket", vector4);
        sMethods.put("createServerSocket", vector3);
        sMethods.put("readLine", vector);
        sMethods.put("lockDownForTesting", vector);
        sMethods.put("releaseLockDownForTesting", vector);
        sMethods.put("addTestToCleanupManager", vector);
        sMethods.put("cleanupTests", vector5);
        sMethods.put("getStatusResults", vector4);
        sMethods.put("getServerHostname", vector);
    }
}

