/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.view;

import com.jidesoft.grid.SortableTable;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultDataFilter;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultsContainer;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class LogReport
extends StyleGuidePanel {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2);

    public LogReport(TestResultsContainer testResultsContainer) {
        this(testResultsContainer, null);
    }

    public LogReport(TestResultsContainer testResultsContainer, TestResultDataFilter testResultDataFilter) {
        if (testResultsContainer == null) {
            throw new IllegalArgumentException("testResultsContainer cannot be null");
        }
        this.initialize(testResultsContainer.getTestResults(testResultDataFilter));
    }

    public LogReport(TestResultData[] testResultDataArray) {
        this.initialize(testResultDataArray);
    }

    private void initialize(TestResultData[] testResultDataArray) {
        TestResultsDataTableModel testResultsDataTableModel = new TestResultsDataTableModel(testResultDataArray);
        SortableTable sortableTable = new SortableTable((TableModel)testResultsDataTableModel);
        sortableTable.setAutoResizeMode(0);
        sortableTable.getTableHeader().setReorderingAllowed(false);
        sortableTable.setMultiColumnSortable(false);
        sortableTable.setOptimized(true);
        sortableTable.setAutoResort(false);
        sortableTable.setShowSortOrderNumber(false);
        LogReport.resizeColumnToFit((JTable)sortableTable);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)sortableTable);
        mJScrollPane.getViewport().setBackground(Color.WHITE);
        this.addLine((JComponent)mJScrollPane, 8);
        this.setName("logReport");
    }

    private static void resizeColumnToFit(JTable jTable) {
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            LogReport.packColumn(jTable, i, 2);
        }
    }

    public static void packColumn(JTable jTable, int n, int n2) {
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)jTable.getColumnModel();
        TableColumn tableColumn = defaultTableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        int n3 = 0;
        if (tableCellRenderer != null) {
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
            n3 = component.getPreferredSize().width;
        }
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            tableCellRenderer = jTable.getCellRenderer(i, n);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n);
            n3 = Math.max(n3, component.getPreferredSize().width);
        }
        tableColumn.setMinWidth(n3 += 2 * n2);
    }

    private static Object getFieldValue(TestResultData testResultData, int n, LogColumn logColumn) {
        if (testResultData == null) {
            return null;
        }
        switch (logColumn) {
            case EXECUTOR: {
                return testResultData.getExecutorNode();
            }
            case ID: {
                return n + 1;
            }
            case MESSAGE: {
                return testResultData.getMessage();
            }
            case RESULT: {
                return testResultData.getReturnStatus();
            }
            case START: {
                return DATE_FORMAT.format(testResultData.getStartTime());
            }
            case STOP: {
                return DATE_FORMAT.format(testResultData.getStopTime());
            }
            case SUBJECT: {
                return testResultData.getReceivingNode();
            }
            case TEST: {
                return testResultData.getTestCategory();
            }
            case DESCRIPTION: {
                return testResultData.getTestDescription();
            }
        }
        return null;
    }

    private static class TestResultsDataTableModel
    extends AbstractTableModel {
        private TestResultData[] iTestResultsDataArray;

        @Override
        public String getColumnName(int n) {
            return LogColumn.values()[n].getName();
        }

        private TestResultsDataTableModel(TestResultData[] testResultDataArray) {
            this.iTestResultsDataArray = testResultDataArray;
        }

        @Override
        public int getRowCount() {
            return this.iTestResultsDataArray.length;
        }

        @Override
        public int getColumnCount() {
            return LogColumn.values().length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return LogReport.getFieldValue(this.iTestResultsDataArray[n], n, LogColumn.values()[n2]);
        }
    }

    private static enum LogColumn {
        ID,
        START,
        STOP,
        EXECUTOR,
        SUBJECT,
        TEST,
        DESCRIPTION,
        RESULT,
        MESSAGE;


        public String getName() {
            return ResourceStatics.sRes.getString("results.log.column." + (Object)((Object)this));
        }
    }
}

