/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer;

import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ConsumerCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.MatlabCredentialConsumerFactory;

public abstract class CredentialConsumerFactory {
    private static CredentialConsumerFactory sDefaultFactory = null;
    public static final CredentialConsumerFactory TRIVIAL_FACTORY = new TrivialConsumerFactory();

    public abstract CredentialConsumer create(CredentialConsumerConfig var1) throws ConsumerCreationException;

    public abstract boolean getGraphical();

    public abstract void setGraphical(boolean var1);

    public abstract boolean isInteractive();

    public abstract void setInteractive(boolean var1);

    public abstract CredentialConsumerFactory copy();

    public static CredentialConsumerFactory getDefault() {
        if (sDefaultFactory == null) {
            sDefaultFactory = MatlabCredentialConsumerFactory.getDefault();
        }
        return sDefaultFactory.copy();
    }

    public static void setDefault(CredentialConsumerFactory credentialConsumerFactory) {
        sDefaultFactory = credentialConsumerFactory;
    }

    private static class TrivialConsumerFactory
    extends CredentialConsumerFactory {
        private TrivialConsumerFactory() {
        }

        @Override
        public CredentialConsumer create(CredentialConsumerConfig credentialConsumerConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getGraphical() {
            return false;
        }

        @Override
        public void setGraphical(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInteractive() {
            return false;
        }

        @Override
        public void setInteractive(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CredentialConsumerFactory copy() {
            return this;
        }
    }
}

