/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer;

import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ChangePasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ConsumerCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CurrentTokenReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NewPasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModel;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModelFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.InputField;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.view.AuthorizationView;

public abstract class CredentialConsumerImpl
implements CredentialConsumer {
    private final CredentialConsumerConfig fConfig;
    private final AuthorizationModelFactory fModelFactory;

    public CredentialConsumerImpl(CredentialConsumerConfig credentialConsumerConfig) throws ConsumerCreationException {
        this(credentialConsumerConfig, new AuthorizationModelFactory(credentialConsumerConfig));
    }

    public CredentialConsumerImpl(CredentialConsumerConfig credentialConsumerConfig, AuthorizationModelFactory authorizationModelFactory) throws ConsumerCreationException {
        this.fConfig = credentialConsumerConfig;
        this.fModelFactory = authorizationModelFactory;
        this.fModelFactory.setRememberValueForField(InputField.REMEMBER, true);
        this.fModelFactory.setRememberValueForField(InputField.USERNAME, true);
    }

    protected abstract AuthorizationView createView(AuthorizationModelFactory var1, AuthorizationModelFactory.ModelSpec var2);

    @Override
    public CurrentTokenReturn promptForCurrentPassword(UserIdentity userIdentity, Throwable throwable) throws NoCredentialsEnteredException {
        this.fModelFactory.setInvokingUsername(userIdentity.getSimpleUsername());
        this.fModelFactory.setTargetUsername(userIdentity.getSimpleUsername());
        AuthorizationModel authorizationModel = this.prompt(userIdentity, AuthorizationModelFactory.ModelSpec.AUTHENTICATE, throwable);
        PlainCredentials plainCredentials = this.getCurrentCreds(authorizationModel, userIdentity);
        return new CurrentTokenReturn(plainCredentials.createAuthenticationToken(this.fConfig.getHasher()), this.getRememberChoice(authorizationModel));
    }

    @Override
    public NewPasswordReturn promptForNewPassword(UserIdentity userIdentity) throws NoCredentialsEnteredException {
        this.fModelFactory.setInvokingUsername(userIdentity.getSimpleUsername());
        this.fModelFactory.setTargetUsername(userIdentity.getSimpleUsername());
        AuthorizationModel authorizationModel = this.prompt(userIdentity, AuthorizationModelFactory.ModelSpec.ADD_NEW_USER);
        PlainCredentials plainCredentials = this.getNewCreds(authorizationModel, userIdentity);
        return new NewPasswordReturn(plainCredentials, plainCredentials.createAuthenticationToken(this.fConfig.getHasher()), this.getRememberChoice(authorizationModel));
    }

    @Override
    public ChangePasswordReturn promptForChangePassword(UserIdentity userIdentity, UserIdentity userIdentity2) throws NoCredentialsEnteredException {
        this.fModelFactory.setInvokingUsername(userIdentity2.getSimpleUsername());
        this.fModelFactory.setTargetUsername(userIdentity.getSimpleUsername());
        AuthorizationModel authorizationModel = this.prompt(userIdentity, AuthorizationModelFactory.ModelSpec.CHANGE_PASSWORD);
        PlainCredentials plainCredentials = this.getCurrentCreds(authorizationModel, userIdentity2);
        PlainCredentials plainCredentials2 = this.getNewCreds(authorizationModel, userIdentity);
        return new ChangePasswordReturn(plainCredentials.createAuthenticationToken(this.fConfig.getHasher()), plainCredentials2, plainCredentials2.createAuthenticationToken(this.fConfig.getHasher()), this.getRememberChoice(authorizationModel));
    }

    @Override
    public CurrentTokenReturn promptForTemporaryUserSwitch(UserIdentity userIdentity) throws NoCredentialsEnteredException {
        AuthorizationModel authorizationModel;
        String string;
        String string2 = this.fConfig.getAdminUserIdentity().getSimpleUsername();
        this.fModelFactory.setInvokingUsername(userIdentity.getSimpleUsername());
        this.fModelFactory.setTargetUsername(userIdentity.getSimpleUsername());
        if (this.fModelFactory.getDefault(InputField.USERNAME) == null) {
            this.fModelFactory.setDefault(InputField.USERNAME, string2);
        }
        if ((string = (String)(authorizationModel = this.prompt(userIdentity, AuthorizationModelFactory.ModelSpec.SWITCH_USER)).getInputValue(InputField.USERNAME)) == null) {
            string = string2;
        }
        UserIdentity userIdentity2 = new UserIdentity(string);
        PlainCredentials plainCredentials = this.getCurrentCreds(authorizationModel, userIdentity2);
        return new CurrentTokenReturn(plainCredentials.createAuthenticationToken(this.fConfig.getHasher()), null);
    }

    @Override
    public UserIdentity promptForIdentity(UserIdentity userIdentity) throws NoCredentialsEnteredException {
        this.fModelFactory.setInvokingUsername(userIdentity.getSimpleUsername());
        this.fModelFactory.setTargetUsername(userIdentity.getSimpleUsername());
        this.fModelFactory.setDefault(InputField.USERNAME, userIdentity.getSimpleUsername());
        AuthorizationModel authorizationModel = this.prompt(userIdentity, AuthorizationModelFactory.ModelSpec.SET_CURRENT_USER);
        return new UserIdentity((String)authorizationModel.getInputValue(InputField.USERNAME));
    }

    private AuthorizationModel prompt(UserIdentity userIdentity, AuthorizationModelFactory.ModelSpec modelSpec) throws NoCredentialsEnteredException {
        return this.prompt(userIdentity, modelSpec, null);
    }

    private AuthorizationModel prompt(UserIdentity userIdentity, AuthorizationModelFactory.ModelSpec modelSpec, Throwable throwable) throws NoCredentialsEnteredException {
        AuthorizationView authorizationView = this.createView(this.fModelFactory, modelSpec);
        authorizationView.showDialog(throwable);
        if (authorizationView.isApproved()) {
            return authorizationView.getModel();
        }
        throw new NoCredentialsEnteredException(userIdentity);
    }

    private PlainCredentials getCurrentCreds(AuthorizationModel authorizationModel, UserIdentity userIdentity) {
        char[] cArray = (char[])authorizationModel.getInputValue(InputField.CURRENT_PASSWORD);
        Erasable erasable = cArray == null ? new Erasable() : new Erasable(cArray);
        return new PlainCredentials(userIdentity, erasable);
    }

    private PlainCredentials getNewCreds(AuthorizationModel authorizationModel, UserIdentity userIdentity) {
        char[] cArray = (char[])authorizationModel.getInputValue(InputField.NEW_PASSWORD);
        Erasable erasable = cArray == null ? new Erasable() : new Erasable(cArray);
        return new PlainCredentials(userIdentity, erasable);
    }

    private RememberChoice getRememberChoice(AuthorizationModel authorizationModel) {
        return (RememberChoice)authorizationModel.getInputValue(InputField.REMEMBER);
    }
}

