/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mvm.helpers.MatlabPrintStreamManager;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ConsumerCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.TextualCredentialConsumer;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import java.io.OutputStream;

public final class MatlabCommandWindowPrompt
implements TextualCredentialConsumer.Prompt {
    private static final String READ_PASSWORD_METHOD = "parallel.internal.readPassword";
    private final MatlabMCR fMatlab = MatlabRefStore.getMatlabRef();
    private final OutputStream fMatlabOutStream;
    private final OutputStream fMatlabErrStream;

    public MatlabCommandWindowPrompt() throws ConsumerCreationException {
        if (this.fMatlab == null) {
            throw new ConsumerCreationException("Could not get the MatlabRef.");
        }
        this.fMatlabOutStream = MatlabPrintStreamManager.createMatlabOutputStream();
        this.fMatlabErrStream = MatlabPrintStreamManager.createMatlabErrorStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fMatlabOutStream;
    }

    @Override
    public OutputStream getErrorStream() {
        return this.fMatlabErrStream;
    }

    @Override
    public char[] prompt(String string, boolean bl) throws NoCredentialsEnteredException {
        Object object;
        String string2;
        Object[] objectArray = new Object[]{string};
        int n = 1;
        if (bl) {
            string2 = READ_PASSWORD_METHOD;
            objectArray = new Object[]{string};
        } else {
            string2 = "input";
            objectArray = new Object[]{string, "s"};
        }
        try {
            object = MatlabMCR.mtFevalConsoleOutput((String)string2, (Object[])objectArray, (int)n);
        }
        catch (Exception exception) {
            throw new NoCredentialsEnteredException(null, (Throwable)exception);
        }
        if (object instanceof Exception) {
            throw new NoCredentialsEnteredException(null, (Throwable)((Exception)object));
        }
        return this.canonicalise((String)object).toCharArray();
    }

    private String canonicalise(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '\b') {
                if (stringBuilder.length() <= 0) continue;
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

