/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer.view;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModel;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModelFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.Choice;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.ChoiceInput;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.Input;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.PasswordInput;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.StringInput;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.view.AuthorizationView;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GraphicalView
implements AuthorizationView {
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(GraphicalView.class);
    private static final String COMP_NAME_OKAY = "okayButton";
    private static final String COMP_NAME_CANCEL = "cancelButton";
    private static final String COMP_NAME_BLURB = "blurbLabel";
    private static final String COMP_NAME_RADIO = "radioButton_";
    private static final String COMP_NAME_PASSWORD = "passwordField_";
    private static final String COMP_NAME_TEXTFIELD = "usernameField_";
    private final JFrame fParent;
    private final AuthorizationModelFactory fFactory;
    private final AuthorizationModelFactory.ModelSpec fSpec;
    private AuthorizationModel fModel;
    private MJDialog fDialog;
    private boolean fApproved = false;
    private static final char[] EMPTY_PASSWORD = new char[0];
    private static final int UI_WIDTH = 375;
    private static final int UI_HEIGHT_ADJUSTMENT = 75;

    public GraphicalView(JFrame jFrame, AuthorizationModelFactory authorizationModelFactory, AuthorizationModelFactory.ModelSpec modelSpec) {
        assert (authorizationModelFactory != null) : "factory must not be null.";
        assert (modelSpec != null) : "spec must not be null.";
        this.fParent = jFrame;
        this.fFactory = authorizationModelFactory;
        this.fSpec = modelSpec;
    }

    @Override
    public AuthorizationModel getModel() {
        return this.fModel;
    }

    @Override
    public boolean isApproved() {
        return this.fApproved;
    }

    @Override
    public void showDialog(Throwable throwable) {
        if (this.fDialog != null && this.fDialog.isDisplayable()) {
            this.fDialog.setVisible(true);
            return;
        }
        this.fModel = this.fFactory.createModel(this.fSpec);
        this.fApproved = false;
        String string = sRes.getString("Dialog.Title." + this.fSpec.toString(), new Object[0]);
        this.fDialog = new MJDialog((Frame)this.fParent, string, true);
        this.fDialog.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GraphicalView.this.fDialog.setSize(new Dimension(375, GraphicalView.this.fDialog.getHeight()));
            }
        });
        this.fDialog.setName(this.fSpec.toString());
        this.fDialog.setDefaultCloseOperation(0);
        this.fDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GraphicalView.this.conditionalClose();
            }
        });
        final MJButton mJButton = new MJButton((Action)new MJAbstractAction(sRes.getString("Dialog.Okay", new Object[0])){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphicalView.this.fApproved = true;
                GraphicalView.this.conditionalClose();
            }
        });
        mJButton.setName(COMP_NAME_OKAY);
        this.fDialog.getRootPane().setDefaultButton((JButton)mJButton);
        MJButton mJButton2 = new MJButton((Action)new MJAbstractAction(sRes.getString("Dialog.Cancel", new Object[0])){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphicalView.this.conditionalClose();
            }
        });
        mJButton2.setName(COMP_NAME_CANCEL);
        Object object2 = null;
        int n = this.fModel.getInputs().size();
        JComponent[][] jComponentArray = new JComponent[n][2];
        if (this.fModel.getInputs().values().isEmpty()) {
            object2 = mJButton2;
        } else {
            int n2 = 0;
            for (Input<?> object3 : this.fModel.getInputs().values()) {
                jComponentArray[n2][0] = GraphicalView.createLabelComponent(object3);
                jComponentArray[n2][1] = GraphicalView.createInputComponent(object3);
                if (object2 == null) {
                    object2 = jComponentArray[n2][1];
                }
                ++n2;
                object3.addChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        mJButton.setEnabled(GraphicalView.this.validateInputs());
                    }
                });
            }
        }
        mJButton.setEnabled(this.validateInputs());
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (throwable != null) {
            stringBuilder.append(throwable.getMessage()).append("<br/><br/>");
        }
        stringBuilder.append(sRes.getString(this.fModel.getBlurbMessenger()).replace("\n", "<br/>")).append("</html>");
        MJLabel mJLabel = new MJLabel(stringBuilder.toString());
        mJLabel.setName(COMP_NAME_BLURB);
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.addLine((JComponent)mJLabel);
        if (n > 0) {
            styleGuidePanel.addLine(jComponentArray, 0, 1);
        }
        styleGuidePanel.addLine(new JPanel(), 8);
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{null, mJButton, mJButton2}}, 0, 0);
        this.fDialog.setContentPane((Container)((Object)styleGuidePanel));
        this.fDialog.setMinimumSize(new Dimension(375, (int)this.fDialog.getPreferredSize().getHeight() + 75));
        this.fDialog.setMaximumSize(new Dimension(375, Integer.MAX_VALUE));
        this.fDialog.setPreferredSize(new Dimension(375, (int)this.fDialog.getPreferredSize().getHeight() + 75));
        this.fDialog.pack();
        this.fDialog.setResizable(true);
        this.fDialog.setLocationRelativeTo((Component)this.fParent);
        if (object2 != null) {
            ((JComponent)object2).requestFocusInWindow();
        }
        this.fDialog.setVisible(true);
    }

    private boolean validateInputs() {
        try {
            this.getModel().validateAllInputs();
            return true;
        }
        catch (AuthorizationModel.ValidationException validationException) {
            return false;
        }
    }

    private void conditionalClose() {
        assert (this.fDialog != null && this.fDialog.isShowing()) : "Dialog has not been shown yet.";
        if (this.fApproved) {
            this.fModel.commit();
            this.fDialog.dispose();
            return;
        }
        this.fDialog.dispose();
    }

    private static JComponent createInputComponent(Input<?> input) {
        if (input instanceof StringInput) {
            final StringInput stringInput = (StringInput)input;
            String string = stringInput.getValue() != null ? (String)stringInput.getValue() : "";
            MJTextField mJTextField = new MJTextField();
            mJTextField.setName(COMP_NAME_TEXTFIELD + input.getLabelMessenger().getResourceKey());
            mJTextField.setText(string);
            mJTextField.getDocument().addDocumentListener(new DocumentListener((JTextField)mJTextField){
                final /* synthetic */ JTextField val$field;
                {
                    this.val$field = jTextField;
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    stringInput.setValue(this.val$field.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    stringInput.setValue(this.val$field.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    stringInput.setValue(this.val$field.getText());
                }
            });
            return mJTextField;
        }
        if (input instanceof PasswordInput) {
            final PasswordInput passwordInput = (PasswordInput)input;
            char[] cArray = passwordInput.getValue() != null ? (char[])passwordInput.getValue() : EMPTY_PASSWORD;
            final JPasswordField jPasswordField = new JPasswordField();
            jPasswordField.setName(COMP_NAME_PASSWORD + input.getLabelMessenger().getResourceKey());
            jPasswordField.setText(new String(cArray));
            jPasswordField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    passwordInput.setValue(jPasswordField.getPassword());
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    passwordInput.setValue(jPasswordField.getPassword());
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    passwordInput.setValue(jPasswordField.getPassword());
                }
            });
            return jPasswordField;
        }
        if (input instanceof ChoiceInput) {
            ButtonGroup buttonGroup = new ButtonGroup();
            final ChoiceInput<Choice> choiceInput = GraphicalView.castToChoiceInput(input);
            StyleGuideRelatedPanel styleGuideRelatedPanel = new StyleGuideRelatedPanel();
            for (Choice choice : choiceInput.getAvailableChoices()) {
                MJRadioButton mJRadioButton = new MJRadioButton(sRes.getString("Remember.Graphical.Label." + choice.toString(), new Object[0]));
                mJRadioButton.setName(COMP_NAME_RADIO + choice.toString());
                if (choice.equals(choiceInput.getValue())) {
                    mJRadioButton.setSelected(true);
                }
                final Choice choice2 = choice;
                mJRadioButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        choiceInput.setValue(choice2);
                    }
                });
                buttonGroup.add((AbstractButton)mJRadioButton);
                styleGuideRelatedPanel.addLine((JComponent)mJRadioButton);
            }
            styleGuideRelatedPanel.addLine(new JPanel(), 8);
            return styleGuideRelatedPanel;
        }
        assert (false) : "Input was of an unexpected type.";
        return null;
    }

    private static JComponent createLabelComponent(Input<?> input) {
        MJLabel mJLabel = new MJLabel(sRes.getString(input.getLabelMessenger()) + ":");
        if (input instanceof ChoiceInput) {
            StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
            styleGuideEmptyPanel.addLine((JComponent)mJLabel);
            styleGuideEmptyPanel.addLine(new JPanel(), 8);
            return styleGuideEmptyPanel;
        }
        return mJLabel;
    }

    private static ChoiceInput<Choice> castToChoiceInput(Input<?> input) {
        return (ChoiceInput)input;
    }
}

