/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.store;

import com.mathworks.toolbox.distcomp.auth.credentials.Credentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import java.util.ArrayList;
import java.util.Collection;

public final class FilteredCredentialStore<T extends Credentials>
implements CredentialStore<T> {
    private final CredentialStore<T> fWrappedCredentialStore;
    private UserIdentity fFilteringIdentity;

    public FilteredCredentialStore(CredentialStore<T> credentialStore, UserIdentity userIdentity) {
        this.fWrappedCredentialStore = credentialStore;
        this.fFilteringIdentity = userIdentity;
    }

    @Override
    public T getCredentials(UserIdentity userIdentity) throws NoCredentialsException {
        if (this.matchesFilter(userIdentity)) {
            return this.fWrappedCredentialStore.getCredentials(userIdentity);
        }
        throw new NoCredentialsException(userIdentity);
    }

    @Override
    public Collection<T> getAllCredentials() {
        Collection<T> collection = this.fWrappedCredentialStore.getAllCredentials();
        if (this.fFilteringIdentity == null) {
            return collection;
        }
        ArrayList<Credentials> arrayList = new ArrayList<Credentials>(1);
        for (Credentials credentials : collection) {
            if (!this.matchesFilter(credentials.getUserIdentity())) continue;
            arrayList.add(credentials);
            break;
        }
        return arrayList;
    }

    @Override
    public void putAllCredentials(Collection<T> collection) {
        this.fWrappedCredentialStore.putAllCredentials(collection);
    }

    @Override
    public void putCredentials(T t) {
        this.fWrappedCredentialStore.putCredentials(t);
    }

    @Override
    public void putCredentials(T t, RememberChoice rememberChoice) {
        this.fWrappedCredentialStore.putCredentials(t, rememberChoice);
    }

    @Override
    public T removeUser(UserIdentity userIdentity) {
        if (this.matchesFilter(userIdentity)) {
            return this.fWrappedCredentialStore.removeUser(userIdentity);
        }
        return null;
    }

    @Override
    public void removeAllCredentials() {
        if (this.fFilteringIdentity == null) {
            this.fWrappedCredentialStore.removeAllCredentials();
        } else {
            this.fWrappedCredentialStore.removeUser(this.fFilteringIdentity);
        }
    }

    @Override
    public boolean containsUser(UserIdentity userIdentity) {
        if (this.matchesFilter(userIdentity)) {
            return this.fWrappedCredentialStore.containsUser(userIdentity);
        }
        return false;
    }

    private boolean matchesFilter(UserIdentity userIdentity) {
        return this.fFilteringIdentity == null || this.fFilteringIdentity.equals(userIdentity);
    }

    @Override
    public CredentialStore.Memento<T> createMemento() {
        return new FilteredCredentialStoreMemento(this.fWrappedCredentialStore.createMemento(), this.fFilteringIdentity);
    }

    @Override
    public void restoreFromMemento(CredentialStore.Memento<T> memento) {
        if (!(memento instanceof FilteredCredentialStoreMemento)) {
            throw new IllegalArgumentException("memento must be instance of FilteredCredentialStoreMemento");
        }
        FilteredCredentialStoreMemento filteredCredentialStoreMemento = (FilteredCredentialStoreMemento)memento;
        filteredCredentialStoreMemento.restore(this);
    }

    private static class FilteredCredentialStoreMemento<T extends Credentials>
    implements CredentialStore.Memento<T> {
        private final CredentialStore.Memento<T> fCredentialStoreMemento;
        private final UserIdentity fFilteringIdentityMemento;

        private FilteredCredentialStoreMemento(CredentialStore.Memento<T> memento, UserIdentity userIdentity) {
            this.fCredentialStoreMemento = memento;
            this.fFilteringIdentityMemento = userIdentity;
        }

        private void restore(FilteredCredentialStore<T> filteredCredentialStore) {
            ((FilteredCredentialStore)filteredCredentialStore).fWrappedCredentialStore.restoreFromMemento(this.fCredentialStoreMemento);
            ((FilteredCredentialStore)filteredCredentialStore).fFilteringIdentity = this.fFilteringIdentityMemento;
        }
    }
}

