/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.modules.PackageInfo;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import javax.crypto.Cipher;

final class CryptoModuleKeyPairImplHelper {
    private static CryptoModuleKeyPairImplHelper INSTANCE = new CryptoModuleKeyPairImplHelper();
    private static final String CIPHER_ALGORITHM = "RSA";
    private static final String DIGEST_ALGORITHM = "SHA-1";
    private static final String KEYPAIR_ALGORITHM = "RSA";
    private static final int KEYPAIR_SIZE = 1024;
    private static final String RANDOM_ALGORITHM = "SHA1PRNG";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private Cipher fCipher = CryptoModuleKeyPairImplHelper.createCipher();
    private MessageDigest fDigest = CryptoModuleKeyPairImplHelper.createDigest();
    private SecureRandom fRandom = CryptoModuleKeyPairImplHelper.createRandom();
    private Signature fSignature = CryptoModuleKeyPairImplHelper.createSignature();

    private CryptoModuleKeyPairImplHelper() {
    }

    static KeyPair generateKeyPair() throws CryptoException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException("Failed to initialise keypair algorithm", noSuchAlgorithmException);
        }
    }

    static synchronized byte[] decrypt(byte[] byArray, Key key) throws CryptoException {
        try {
            CryptoModuleKeyPairImplHelper.getCipher().init(2, key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException("Failed to initialise decryption", invalidKeyException);
        }
        try {
            return CryptoModuleKeyPairImplHelper.getCipher().doFinal(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException("Decryption failed", generalSecurityException);
        }
    }

    static synchronized byte[] encrypt(byte[] byArray, Key key) throws CryptoException {
        try {
            CryptoModuleKeyPairImplHelper.getCipher().init(1, key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException("Failed to initialise encryption", invalidKeyException);
        }
        try {
            return CryptoModuleKeyPairImplHelper.getCipher().doFinal(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException("Encryption failed", generalSecurityException);
        }
    }

    static synchronized byte[] createSalt(int n) {
        byte[] byArray = new byte[n];
        CryptoModuleKeyPairImplHelper.getRandom().nextBytes(byArray);
        return byArray;
    }

    static synchronized byte[] hash(byte[] byArray) {
        return CryptoModuleKeyPairImplHelper.getDigest().digest(byArray);
    }

    static synchronized byte[] sign(byte[] byArray, PrivateKey privateKey) throws CryptoException {
        try {
            CryptoModuleKeyPairImplHelper.getSignature().initSign(privateKey);
            CryptoModuleKeyPairImplHelper.getSignature().update(byArray);
            return CryptoModuleKeyPairImplHelper.getSignature().sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException("Failed to sign data", generalSecurityException);
        }
    }

    static synchronized boolean verify(byte[] byArray, byte[] byArray2, PublicKey publicKey) throws CryptoException {
        try {
            CryptoModuleKeyPairImplHelper.getSignature().initVerify(publicKey);
            CryptoModuleKeyPairImplHelper.getSignature().update(byArray);
            return CryptoModuleKeyPairImplHelper.getSignature().verify(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException("Failed to verify signature data", generalSecurityException);
        }
    }

    private static Cipher createCipher() throws CryptoHelperException {
        try {
            return Cipher.getInstance("RSA");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoHelperException("Failed to initialise cipher algorithm", generalSecurityException);
        }
    }

    private static MessageDigest createDigest() throws CryptoHelperException {
        try {
            return MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoHelperException("Failed to initialise digest/hash algorithm", noSuchAlgorithmException);
        }
    }

    private static SecureRandom createRandom() throws CryptoHelperException {
        try {
            return SecureRandom.getInstance(RANDOM_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoHelperException("Failed to initialise random algorithm", noSuchAlgorithmException);
        }
    }

    private static Signature createSignature() throws CryptoHelperException {
        try {
            return Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoHelperException("Failed to initialise signing algorithm", noSuchAlgorithmException);
        }
    }

    private static Cipher getCipher() {
        return CryptoModuleKeyPairImplHelper.INSTANCE.fCipher;
    }

    private static MessageDigest getDigest() {
        return CryptoModuleKeyPairImplHelper.INSTANCE.fDigest;
    }

    private static SecureRandom getRandom() {
        return CryptoModuleKeyPairImplHelper.INSTANCE.fRandom;
    }

    private static Signature getSignature() {
        return CryptoModuleKeyPairImplHelper.INSTANCE.fSignature;
    }

    static void initialize() {
        PackageInfo.LOGGER.info("Initializing CryptoModuleKeyPairImplHelper.fSecureRandom");
        CryptoModuleKeyPairImplHelper.getRandom().nextBytes(new byte[1]);
        PackageInfo.LOGGER.info("Initialized CryptoModuleKeyPairImplHelper.fSecureRandom");
    }

    public static final class CryptoHelperException
    extends RuntimeException {
        private CryptoHelperException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

