/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcessInfo;
import com.mathworks.toolbox.distcomp.control.DisplayableResultsImpl;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.util.RemoteSystemProperty;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import java.io.File;

public abstract class ControlStartStopProcess
extends MDCSCommand {
    private static final long serialVersionUID = 1L;
    private RemoteSystemProperty fServiceName;
    private RemoteSystemProperty fClean;
    private String fConfigFile;
    private ConfigRunner fConfigRunner;
    private boolean fIsStarting;

    private String getConfigFile() {
        String string = "com.mathworks.toolbox.distcomp.configbase";
        String string2 = System.getProperty(string);
        if (string2 == null) {
            throw new RuntimeException("System property not defined: " + string);
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string2 + this.fConfigFile;
    }

    protected abstract String getDefaultServiceName();

    protected ControlStartStopProcess() {
    }

    public ControlStartStopProcess(ConfigRunner configRunner, boolean bl, String string, String string2) {
        this.fConfigRunner = configRunner;
        this.fIsStarting = bl;
        this.fServiceName = new RemoteSystemProperty("com.mathworks.toolbox.distcomp.servicename", string2);
        this.fClean = new RemoteSystemProperty("com.mathworks.toolbox.distcomp.clean_checkpoint_info");
        this.fConfigFile = string;
    }

    public void setClean(boolean bl) {
        this.fClean.setValue(Boolean.toString(bl));
    }

    public boolean isStarting() {
        return this.fIsStarting;
    }

    public String getServiceName() {
        return this.fServiceName.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MDCSCommandResults run() throws Exception {
        WarningAndNoteInfo warningAndNoteInfo = new WarningAndNoteInfo();
        this.preRunSetup(warningAndNoteInfo);
        String string = this.getConfigFile();
        boolean bl = false;
        try {
            bl = this.fConfigRunner.run(warningAndNoteInfo, new String[]{string});
        }
        finally {
            this.postRunTeardown();
        }
        String string2 = null;
        String string3 = null;
        string3 = bl ? this.getInfo().getSuccessDescription() : this.getInfo().getNotNeededDescription();
        return new DisplayableResultsImpl(string2, warningAndNoteInfo, string3);
    }

    protected void preRunSetup(WarningAndNoteInfo warningAndNoteInfo) {
        this.fServiceName.setDefaultValue(this.getDefaultServiceName());
        this.fServiceName.exportValueIfNeeded();
        this.fClean.exportValueIfNeeded();
        this.getInfo().setServiceName(this.fServiceName.getValue());
    }

    protected void postRunTeardown() {
        this.fServiceName.restoreValueIfNeeded();
        this.fClean.restoreValueIfNeeded();
    }

    public abstract ControlStartStopProcessInfo getInfo();

    @Override
    public String getPreRunDescription() {
        return this.getInfo().getPreRunDescription();
    }

    @Override
    public int maxTimeForRemoteTries() {
        return 60000;
    }

    @Override
    public int timeBetweenTriesInMilliSeconds() {
        return 5000;
    }
}

