/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public final class StreamSegment
implements Serializable {
    private final String fStreamName;
    private final long fSegmentNumber;
    private final byte[] fStreamContents;
    private final boolean fIsLastSegment;

    StreamSegment(String string, long l, byte[] byArray, boolean bl) {
        this.fStreamName = string;
        this.fSegmentNumber = l;
        this.fStreamContents = byArray;
        this.fIsLastSegment = bl;
    }

    public String getStreamName() {
        return this.fStreamName;
    }

    long getSegmentNumber() {
        return this.fSegmentNumber;
    }

    byte[] getStreamContents() {
        return this.fStreamContents;
    }

    boolean isLastSegment() {
        return this.fIsLastSegment;
    }

    public String toString() {
        return "StreamSegment{StreamName='" + this.fStreamName + '\'' + ", SegmentNumber=" + this.fSegmentNumber + ", StreamContents.length=" + this.fStreamContents.length + ", fIsLastSegment=" + this.fIsLastSegment + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StreamSegment streamSegment = (StreamSegment)object;
        if (this.fIsLastSegment != streamSegment.fIsLastSegment) {
            return false;
        }
        if (this.fSegmentNumber != streamSegment.fSegmentNumber) {
            return false;
        }
        if (!Arrays.equals(this.fStreamContents, streamSegment.fStreamContents)) {
            return false;
        }
        return !(this.fStreamName != null ? !this.fStreamName.equals(streamSegment.fStreamName) : streamSegment.fStreamName != null);
    }

    public int hashCode() {
        int n = this.fStreamName != null ? this.fStreamName.hashCode() : 0;
        n = 31 * n + (int)(this.fSegmentNumber ^ this.fSegmentNumber >>> 32);
        n = 31 * n + (this.fStreamContents != null ? Arrays.hashCode(this.fStreamContents) : 0);
        n = 31 * n + (this.fIsLastSegment ? 1 : 0);
        return n;
    }

    static final class StreamSegmentComparator
    implements Comparator<StreamSegment> {
        StreamSegmentComparator() {
        }

        @Override
        public int compare(StreamSegment streamSegment, StreamSegment streamSegment2) {
            if (streamSegment == streamSegment2) {
                return 0;
            }
            if (!streamSegment.getStreamName().equals(streamSegment2.getStreamName())) {
                throw new IllegalArgumentException("StreamSegments can not be compared if they have different names, like " + streamSegment + " and " + streamSegment2);
            }
            if (streamSegment.getSegmentNumber() < streamSegment2.getSegmentNumber()) {
                return -1;
            }
            if (streamSegment.getSegmentNumber() > streamSegment2.getSegmentNumber()) {
                return 1;
            }
            return 0;
        }
    }
}

