/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.servicerequest;

import com.mathworks.toolbox.distcomp.control.PackageInfo;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class MdceShellCommand
implements ShellCommand {
    public static final int EXIT_STATUS_SUCCESSFUL = 0;
    private static final String CLEAN_FLAG = "-clean";
    private static final String NOPROMPT_FLAG = "-noprompt";
    private static final String MDCEDEFFILE_FLAG = "-mdcedef";
    private static final String VERSION_FLAG = "-version";
    private static final String INFO_FLAG = "-info";
    private static final String START_CMD = "start";
    private static final String STOP_CMD = "stop";
    private static final String INSTALL_CMD = "install";
    private static final String UNINSTALL_CMD = "uninstall";
    private final List<String> fCommand = new LinkedList<String>();
    private static List<String> sQEArguments;

    private MdceShellCommand(String string, List<String> list, PathUtils.Platform platform) {
        this.fCommand.add(MdceShellCommand.createPathToRemoteMdceExecutable(string, platform));
        this.fCommand.add(NOPROMPT_FLAG);
        this.fCommand.addAll(list);
        if (sQEArguments != null) {
            this.fCommand.addAll(sQEArguments);
        }
    }

    public static MdceShellCommand createMdceShellCommand(String string, List<String> list, PathUtils.Platform platform) {
        return new MdceShellCommand(string, list, platform);
    }

    public static MdceShellCommand createInstallMdceShellCommand(String string, String string2, PathUtils.Platform platform) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(INSTALL_CMD);
        arrayList.add(MDCEDEFFILE_FLAG);
        arrayList.add(string2);
        return new MdceShellCommand(string, arrayList, platform);
    }

    public static MdceShellCommand createUninstallMdceShellCommand(String string, String string2, PathUtils.Platform platform) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(UNINSTALL_CMD);
        arrayList.add(CLEAN_FLAG);
        arrayList.add(MDCEDEFFILE_FLAG);
        arrayList.add(string2);
        return new MdceShellCommand(string, arrayList, platform);
    }

    public static MdceShellCommand createStartMdceShellCommand(String string, String string2, PathUtils.Platform platform) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(START_CMD);
        arrayList.add(MDCEDEFFILE_FLAG);
        arrayList.add(string2);
        return new MdceShellCommand(string, arrayList, platform);
    }

    public static MdceShellCommand createStopMdceShellCommand(String string, String string2, PathUtils.Platform platform) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(STOP_CMD);
        arrayList.add(MDCEDEFFILE_FLAG);
        arrayList.add(string2);
        return new MdceShellCommand(string, arrayList, platform);
    }

    public static MdceShellCommand createDestroyMdceShellCommand(String string, String string2, PathUtils.Platform platform) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(STOP_CMD);
        arrayList.add(CLEAN_FLAG);
        arrayList.add(MDCEDEFFILE_FLAG);
        arrayList.add(string2);
        return new MdceShellCommand(string, arrayList, platform);
    }

    public static MdceShellCommand createVersionMdceShellCommand(String string, PathUtils.Platform platform) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(VERSION_FLAG);
        return new MdceShellCommand(string, arrayList, platform);
    }

    public static MdceShellCommand createInfoMdceShellCommand(String string, PathUtils.Platform platform) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(INFO_FLAG);
        return new MdceShellCommand(string, arrayList, platform);
    }

    @Override
    public List<String> getCommand() {
        return Collections.unmodifiableList(this.fCommand);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.fCommand;
    }

    private static String createPathToRemoteMdceExecutable(String string, PathUtils.Platform platform) {
        PathUtils.PlatformType platformType;
        PathUtils.Separator separator = platform.getSeparator();
        if (separator == null) {
            separator = PathUtils.Platform.getLocal().getSeparator();
        }
        if ((platformType = platform.getPlatformType()) == null) {
            platformType = PathUtils.Platform.getLocal().getPlatformType();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(separator.convertSeparators(string));
            if (!string.endsWith(separator.toString())) {
                stringBuilder.append((Object)separator);
            }
            stringBuilder.append("toolbox").append((Object)separator);
            stringBuilder.append("distcomp").append((Object)separator);
            stringBuilder.append("bin").append((Object)separator);
        }
        if (platformType.isWindows()) {
            stringBuilder.append("mdce.bat");
        } else {
            stringBuilder.append("mdce");
        }
        return stringBuilder.toString();
    }

    public static void setQEArguments(List<String> list) {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "QE added arguments to the MDCE Shell Command. Arguments = " + list);
        sQEArguments = list;
    }

    public static void resetQEArguments() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Reset the arguments to the MDCE Shell Command as null.");
        sQEArguments = null;
    }
}

