/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.auth.AuthorisationContext;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.SignatureModule;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.distcompobjects.Identifiable;
import com.mathworks.toolbox.distcomp.distcompobjects.ListenerInfo;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerAddress;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerRegistration;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.pml.ParallelJobAccessLocal;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.service.DistcompServiceInfo;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.service.ServiceAccessor;
import com.mathworks.toolbox.distcomp.storage.Cache;
import com.mathworks.toolbox.distcomp.storage.LRUCache;
import com.mathworks.toolbox.distcomp.test.CommTestInfo;
import com.mathworks.toolbox.distcomp.uddadaptor.MatlabEventAdaptor;
import com.mathworks.toolbox.distcomp.util.Accessor;
import com.mathworks.toolbox.distcomp.util.AccessorException;
import com.mathworks.toolbox.distcomp.util.MCRShutdownHandler;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.workunit.DistcompListenableAccess;
import com.mathworks.toolbox.distcomp.workunit.JobAccessLocal;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessLocal;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import net.jini.id.Uuid;

public class CachedJobManagerProxy
implements JobManagerLocal {
    private static final int CACHE_SIZE = 10;
    private static final Cache<JobManagerAddress, JobManagerLocal> CACHE = new LRUCache<JobManagerAddress, JobManagerLocal>(10);
    private static boolean sShutdownHookAdded = false;
    private JobManagerLocal fJobManager;

    private CachedJobManagerProxy(JobManagerLocal jobManagerLocal) {
        this.fJobManager = jobManagerLocal;
    }

    public static List<JobManagerLocal> create(String string, String string2, ServiceAccessor.AccessorFactory accessorFactory) throws DistcompException, AccessorException {
        Object object;
        JobManagerLocal jobManagerLocal = null;
        if (string != null && string2 != null && !string.isEmpty() && !string2.isEmpty()) {
            object = new JobManagerAddress(string, string2);
            jobManagerLocal = CachedJobManagerProxy.getAndTestJobManagerFromCache((JobManagerAddress)object);
        }
        object = new ArrayList<JobManagerLocal>();
        if (jobManagerLocal == null) {
            Accessor accessor = accessorFactory.getAccessor();
            object.addAll(CachedJobManagerProxy.getJobManagersFromAccessor(string, string2, accessor));
        } else {
            object.add(new CachedJobManagerProxy(jobManagerLocal));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<JobManagerLocal> getJobManagersFromAccessor(String string, String string2, Accessor accessor) throws DistcompException, AccessorException {
        Object[] objectArray;
        ArrayList<JobManagerLocal> arrayList = new ArrayList<JobManagerLocal>();
        for (Object object : objectArray = accessor.getJobManagers(string2)) {
            CachedJobManagerProxy cachedJobManagerProxy;
            JobManagerLocal jobManagerLocal = (JobManagerLocal)object;
            JobManagerAddress jobManagerAddress = CachedJobManagerProxy.createCacheKey(string, jobManagerLocal);
            CACHE.lock();
            try {
                JobManagerLocal jobManagerLocal2 = CachedJobManagerProxy.getAndTestJobManagerFromCache(jobManagerAddress);
                if (jobManagerLocal2 == null) {
                    CACHE.put(jobManagerAddress, jobManagerLocal);
                    cachedJobManagerProxy = new CachedJobManagerProxy(jobManagerLocal);
                } else {
                    cachedJobManagerProxy = new CachedJobManagerProxy(jobManagerLocal2);
                }
            }
            finally {
                CACHE.unlock();
            }
            arrayList.add(cachedJobManagerProxy);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JobManagerLocal getAndTestJobManagerFromCache(JobManagerAddress jobManagerAddress) {
        JobManagerLocal jobManagerLocal;
        CACHE.lock();
        try {
            jobManagerLocal = CACHE.get(jobManagerAddress);
            if (jobManagerLocal != null && !jobManagerLocal.testCommunication()) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Communication test failed for: " + jobManagerAddress + ", removing from JobManagerProxy cache.");
                CACHE.remove(jobManagerAddress);
                jobManagerLocal = null;
            }
        }
        finally {
            CACHE.unlock();
        }
        return jobManagerLocal;
    }

    private static JobManagerAddress createCacheKey(String string, JobManagerLocal jobManagerLocal) {
        String string2 = string == null || string.isEmpty() ? jobManagerLocal.getLookupURL() : string;
        String string3 = jobManagerLocal.getName();
        return new JobManagerAddress(string2, string3);
    }

    @Override
    public void dispose() {
        this.fJobManager = null;
    }

    @Override
    public void addShutdownHookForCurrentMCR() {
        if (!sShutdownHookAdded) {
            JobManagerProxyDisposer jobManagerProxyDisposer = new JobManagerProxyDisposer(CACHE);
            MCRShutdownHandler.addShutdownHookForCurrentMCR(new Thread(jobManagerProxyDisposer));
            sShutdownHookAdded = true;
        }
    }

    @Override
    public String getSessionID() {
        return this.fJobManager.getSessionID();
    }

    @Override
    public void attachToListenableObject(DistcompListenableAccess distcompListenableAccess, Uuid[] uuidArray) throws RemoteException, MJSException {
        this.fJobManager.attachToListenableObject(distcompListenableAccess, uuidArray);
    }

    @Override
    public ListenerInfo[] createListenerInfoArrayForAllEvents() throws IOException {
        return this.fJobManager.createListenerInfoArrayForAllEvents();
    }

    @Override
    public void detachFromListenableObject(DistcompListenableAccess distcompListenableAccess, Uuid[] uuidArray) throws RemoteException, MJSException {
        this.fJobManager.detachFromListenableObject(distcompListenableAccess, uuidArray);
    }

    @Override
    public void addEventAdaptor(MatlabEventAdaptor matlabEventAdaptor) throws MJSException {
        this.fJobManager.addEventAdaptor(matlabEventAdaptor);
    }

    @Override
    public void removeEventAdaptor(MatlabEventAdaptor matlabEventAdaptor) {
        this.fJobManager.removeEventAdaptor(matlabEventAdaptor);
    }

    @Override
    public ServerSocketConnectInfo getBrokerServerSocketConnectInfo() {
        return this.fJobManager.getBrokerServerSocketConnectInfo();
    }

    @Override
    public ServerSocketAcceptInfo getWorkerAcceptInfoTemplate() {
        return this.fJobManager.getWorkerAcceptInfoTemplate();
    }

    @Override
    public RemoteAuthorisationModule getRemoteAuth() {
        return this.fJobManager.getRemoteAuth();
    }

    @Override
    public void pauseQueue() throws RemoteException, MJSException {
        this.fJobManager.pauseQueue();
    }

    @Override
    public void resumeQueue() throws RemoteException, MJSException {
        this.fJobManager.resumeQueue();
    }

    @Override
    public JobIDAndMLType[] getJobs() throws RemoteException {
        return this.fJobManager.getJobs();
    }

    @Override
    public JobIDAndMLType[][] getJobs(int[] nArray) throws RemoteException {
        return this.fJobManager.getJobs(nArray);
    }

    @Override
    public Uuid createJob(AuthorisationContext authorisationContext, JobInfo jobInfo) throws RemoteException, MJSException {
        return this.fJobManager.createJob(authorisationContext, jobInfo);
    }

    @Override
    public Uuid createParallelJob(AuthorisationContext authorisationContext, JobInfo jobInfo) throws RemoteException, MJSException {
        return this.fJobManager.createParallelJob(authorisationContext, jobInfo);
    }

    @Override
    public Uuid createMatlabPoolJob(AuthorisationContext authorisationContext, JobInfo jobInfo, byte[] byArray, byte[] byArray2) throws RemoteException, MJSException {
        return this.fJobManager.createMatlabPoolJob(authorisationContext, jobInfo, byArray, byArray2);
    }

    @Override
    public int getNumIdleWorkers() throws RemoteException {
        return this.fJobManager.getNumIdleWorkers();
    }

    @Override
    public int getNumBusyWorkers() throws RemoteException {
        return this.fJobManager.getNumBusyWorkers();
    }

    @Override
    public Worker[] getIdleWorkers() throws RemoteException {
        return this.fJobManager.getIdleWorkers();
    }

    @Override
    public Worker[] getBusyWorkers() throws RemoteException {
        return this.fJobManager.getBusyWorkers();
    }

    @Override
    public JobAccessLocal getJobAccess() throws RemoteException, MJSException {
        return this.fJobManager.getJobAccess();
    }

    @Override
    public ParallelJobAccessLocal getParallelJobAccess() throws RemoteException, MJSException {
        return this.fJobManager.getParallelJobAccess();
    }

    @Override
    public TaskAccessLocal getTaskAccess() throws RemoteException, MJSException {
        return this.fJobManager.getTaskAccess();
    }

    @Override
    public WorkerRegistration getWorkerRegistration() throws RemoteException {
        return this.fJobManager.getWorkerRegistration();
    }

    @Override
    public boolean allowClientPasswordCache() throws RemoteException {
        return this.fJobManager.allowClientPasswordCache();
    }

    @Override
    public boolean requireWebLicensing() throws RemoteException {
        return this.fJobManager.requireWebLicensing();
    }

    @Override
    public void promote(Uuid uuid) throws RemoteException {
        this.fJobManager.promote(uuid);
    }

    @Override
    public void demote(Uuid uuid) throws RemoteException {
        this.fJobManager.demote(uuid);
    }

    @Override
    public String getLookupURL() {
        return this.fJobManager.getLookupURL();
    }

    @Override
    public void removeWorker(Uuid uuid) throws RemoteException {
        this.fJobManager.removeWorker(uuid);
    }

    @Override
    public void changeCredentialsOfExistingUser(AuthorisationContext authorisationContext, UserIdentity userIdentity) throws RemoteException, MJSException {
        this.fJobManager.changeCredentialsOfExistingUser(authorisationContext, userIdentity);
    }

    @Override
    public void checkCredentialsUserOnly(AuthorisationContext authorisationContext, UserIdentity userIdentity) throws RemoteException, MJSException {
        this.fJobManager.checkCredentialsUserOnly(authorisationContext, userIdentity);
    }

    @Override
    public boolean userExists(UserIdentity userIdentity) throws RemoteException, MJSException {
        return this.fJobManager.userExists(userIdentity);
    }

    @Override
    public void getClusterLogs(AuthorisationContext authorisationContext, OutputStream outputStream) throws IOException, MJSException {
        this.fJobManager.getClusterLogs(authorisationContext, outputStream);
    }

    @Override
    public void setClusterLogLevel(AuthorisationContext authorisationContext, int n) throws MJSException, RemoteException {
        this.fJobManager.setClusterLogLevel(authorisationContext, n);
    }

    @Override
    public int getClusterLogLevel() throws MJSException, RemoteException {
        return this.fJobManager.getClusterLogLevel();
    }

    @Override
    public void addNewUser(AuthorisationContext authorisationContext, UserIdentity userIdentity) throws RemoteException, MJSException {
        this.fJobManager.addNewUser(authorisationContext, userIdentity);
    }

    @Override
    public void addAdminUser(AuthorisationContext authorisationContext, SignatureModule.Signer signer) throws RemoteException, MJSException {
        this.fJobManager.addAdminUser(authorisationContext, signer);
    }

    @Override
    public void testCommunicationWithWorker(WorkerProxy workerProxy) throws RemoteException {
        this.fJobManager.testCommunicationWithWorker(workerProxy);
    }

    @Override
    public void testTwoWayDataStoreCommunication() throws RemoteException, MJSException {
        this.fJobManager.testTwoWayDataStoreCommunication();
    }

    @Override
    public void testCommunicationWithClient(CommTestInfo commTestInfo) throws RemoteException {
        this.fJobManager.testCommunicationWithClient(commTestInfo);
    }

    @Override
    public String getSSLCertificateAlias() {
        return this.fJobManager.getSSLCertificateAlias();
    }

    @Override
    public void setSSLCertificate(Certificate certificate) {
        this.fJobManager.setSSLCertificate(certificate);
    }

    @Override
    public void setSSLCertificate(File file) throws CertificateException, FileNotFoundException {
        this.fJobManager.setSSLCertificate(file);
    }

    @Override
    public void setSSLCertificate(String string) throws CertificateException {
        this.fJobManager.setSSLCertificate(string);
    }

    @Override
    public void forceVanillaRmi(boolean bl) {
        this.fJobManager.forceVanillaRmi(bl);
    }

    @Override
    public long getDataStoreMinLimit() {
        return this.fJobManager.getDataStoreMinLimit();
    }

    @Override
    public ExporterFactory getCredentialProviderExporterFactory() {
        return this.fJobManager.getCredentialProviderExporterFactory();
    }

    @Override
    public boolean testCommunication() {
        return this.fJobManager.testCommunication();
    }

    @Override
    public String[] getAllHostAddresses() {
        return this.fJobManager.getAllHostAddresses();
    }

    @Override
    public String getHostName() {
        return this.fJobManager.getHostName();
    }

    @Override
    public String getName() {
        return this.fJobManager.getName();
    }

    @Override
    public void prepareForShutdown() throws RemoteException {
        this.fJobManager.prepareForShutdown();
    }

    @Override
    public boolean isUsingSecureCommunication() throws RemoteException {
        return this.fJobManager.isUsingSecureCommunication();
    }

    @Override
    public int getState() throws RemoteException {
        return this.fJobManager.getState();
    }

    @Override
    public DistcompServiceInfo getServiceInfo() throws RemoteException {
        return this.fJobManager.getServiceInfo();
    }

    @Override
    public NodeInfo getNodeInfo() throws RemoteException {
        return this.fJobManager.getNodeInfo();
    }

    @Override
    public int getSecurityLevel() {
        return this.fJobManager.getSecurityLevel();
    }

    @Override
    public String getMatlabRoot() {
        return this.fJobManager.getMatlabRoot();
    }

    @Override
    public byte[] createSalt() throws RemoteException {
        return this.fJobManager.createSalt();
    }

    @Override
    public Object provideEvidence(Object object) {
        return this.fJobManager.provideEvidence(object);
    }

    @Override
    public boolean checkVersion() {
        return this.fJobManager.checkVersion();
    }

    @Override
    public String getVersionString() {
        return this.fJobManager.getVersionString();
    }

    @Override
    public int getVersionNumber() {
        return this.fJobManager.getVersionNumber();
    }

    @Override
    public Uuid getID() {
        return this.fJobManager.getID();
    }

    @Override
    public WorkerProperties[] getIdleWorkerProperties() throws RemoteException {
        return this.fJobManager.getIdleWorkerProperties();
    }

    @Override
    public WorkerProperties[] getBusyWorkerProperties() throws RemoteException {
        return this.fJobManager.getBusyWorkerProperties();
    }

    public boolean equals(Object object) {
        return object instanceof Identifiable && this.fJobManager != null && this.fJobManager.equals(object);
    }

    public int hashCode() {
        return this.fJobManager == null ? 0 : this.fJobManager.hashCode();
    }

    private static class JobManagerProxyDisposer
    implements Runnable {
        private final Cache<JobManagerAddress, JobManagerLocal> fCache;

        JobManagerProxyDisposer(Cache<JobManagerAddress, JobManagerLocal> cache) {
            this.fCache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<JobManagerLocal> list;
            this.fCache.lock();
            try {
                list = this.fCache.removeAll();
            }
            finally {
                this.fCache.unlock();
            }
            for (JobManagerLocal jobManagerLocal : list) {
                jobManagerLocal.dispose();
            }
        }
    }
}

