/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerlookupservice;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.JobManagerLookupRequest;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.Log;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupExceptionResponse;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupRequest;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupResponse;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupSucceededResponse;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.WorkerLookupRequest;
import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.util.Accessor;
import com.mathworks.toolbox.distcomp.util.AccessorException;
import java.util.logging.Level;

final class LookupServiceDispatcher
implements PeerDispatcher<ServiceLookupRequest> {
    private ReturnGroup fReturnGroup;
    private final Accessor fAccessor;

    LookupServiceDispatcher(Accessor accessor) throws DistcompException {
        this.fAccessor = accessor;
    }

    @Override
    public void initReturnGroup(ReturnGroup returnGroup) {
        this.fReturnGroup = returnGroup;
    }

    @Override
    public void dispatch(ServiceLookupRequest serviceLookupRequest, Instance instance) {
        Log.LOGGER.finest("LookupServiceDispatcher dispatching " + serviceLookupRequest);
        if (serviceLookupRequest instanceof JobManagerLookupRequest) {
            this.handleJobManagerLookup(serviceLookupRequest, instance);
        } else if (serviceLookupRequest instanceof WorkerLookupRequest) {
            this.handleWorkerLookup(serviceLookupRequest, instance);
        } else {
            assert (false) : "LookupServiceDispatcher can not handle request type: " + serviceLookupRequest;
            Log.LOGGER.severe("LookupServiceDispatcher can not handle request type: " + serviceLookupRequest);
        }
    }

    private void handleWorkerLookup(ServiceLookupRequest serviceLookupRequest, Instance instance) {
        ServiceLookupResponse serviceLookupResponse;
        try {
            String string = serviceLookupRequest.getServiceName();
            Object[] objectArray = this.fAccessor.getMLWorkers(string);
            serviceLookupResponse = new ServiceLookupSucceededResponse(serviceLookupRequest.getSequenceNumber(), objectArray);
        }
        catch (AccessorException accessorException) {
            serviceLookupResponse = new ServiceLookupExceptionResponse(serviceLookupRequest.getSequenceNumber(), accessorException);
        }
        this.sendResponse(instance, serviceLookupResponse);
    }

    private void handleJobManagerLookup(ServiceLookupRequest serviceLookupRequest, Instance instance) {
        ServiceLookupResponse serviceLookupResponse;
        try {
            String string = serviceLookupRequest.getServiceName();
            Object[] objectArray = this.fAccessor.getJobManagers(string);
            serviceLookupResponse = new ServiceLookupSucceededResponse(serviceLookupRequest.getSequenceNumber(), objectArray);
        }
        catch (AccessorException accessorException) {
            serviceLookupResponse = new ServiceLookupExceptionResponse(serviceLookupRequest.getSequenceNumber(), accessorException);
        }
        this.sendResponse(instance, serviceLookupResponse);
    }

    private void sendResponse(Instance instance, ServiceLookupResponse serviceLookupResponse) {
        try {
            this.fReturnGroup.returnTo(instance, serviceLookupResponse);
        }
        catch (CommunicationGroup.NoSuchDestinationException noSuchDestinationException) {
            Log.LOGGER.log(Level.SEVERE, "LookupServiceDispatcher: Failed to send response.", noSuchDestinationException);
        }
    }
}

