/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class LabsState {
    private EnumMap<State, IntSet> fLabsInState = new EnumMap(State.class);
    private LabData[] fLabData;
    private List<ChangeListener> fListeners;
    private ChangeEvent fChangeEvent;

    LabsState(int n) {
        this.fLabsInState.put(State.IDLE, new IntSet(1, n));
        for (State state : State.values()) {
            if (state == State.IDLE) continue;
            this.fLabsInState.put(state, new IntSet());
        }
        this.fLabData = new LabData[n + 1];
        for (int i = 1; i < this.fLabData.length; ++i) {
            this.fLabData[i] = new LabData(i);
        }
    }

    State getState(int n) {
        return this.fLabData[n].iState;
    }

    State getPreviousState(int n) {
        return this.fLabData[n].iPreviousState;
    }

    IntSet getLabsInState(State state) {
        return this.fLabsInState.get((Object)state);
    }

    void setState(int n, State state, String string) {
        boolean bl = false;
        if (state != this.fLabData[n].iState) {
            State state2 = this.fLabData[n].iState;
            this.fLabData[n].iPreviousState = state2;
            this.fLabData[n].iState = state;
            this.fLabsInState.get((Object)state2).remove(n);
            this.fLabsInState.get((Object)state).add(n);
            bl = true;
        }
        if (state == State.STOPPED) {
            this.fLabData[n].iStopLocation = string;
            bl = true;
        }
        if (bl && this.fListeners != null) {
            for (ChangeListener changeListener : this.fListeners) {
                changeListener.stateChanged(this.fChangeEvent);
            }
        }
    }

    void addListener(ChangeListener changeListener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList<ChangeListener>();
            this.fChangeEvent = new ChangeEvent(this);
        }
        this.fListeners.add(changeListener);
    }

    void removeListener(ChangeListener changeListener) {
        if (this.fListeners != null) {
            this.fListeners.remove(changeListener);
        }
    }

    private class LabData {
        int iLab;
        State iState;
        State iPreviousState;
        String iStopLocation;

        LabData(int n) {
            this.iLab = n;
            this.iState = State.IDLE;
            this.iPreviousState = State.IDLE;
        }
    }

    static enum State {
        IDLE,
        BUSY,
        TRANSMIT,
        RECEIVE,
        STOPPED;

    }
}

