/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.jidesoft.swing.StyleRange;
import com.mathworks.toolbox.distcomp.parallelui.TextStyleInfo;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class SubRegionStyleInfo
implements TextStyleInfo {
    private final TextStyleInfo fParent;
    private final int fRegionStart;
    private final int fRegionLength;
    private int fFirstAttributesIndex;
    private int fAttributesCount;

    public SubRegionStyleInfo(TextStyleInfo textStyleInfo, int n, int n2) {
        this.fParent = textStyleInfo;
        this.fRegionStart = n;
        this.fRegionLength = n2;
        int n3 = this.fParent.getAttributesCount();
        this.fFirstAttributesIndex = 0;
        while (this.fFirstAttributesIndex < n3 && this.fParent.getAttributesStart(this.fFirstAttributesIndex) + this.fParent.getAttributesLength(this.fFirstAttributesIndex) <= n) {
            ++this.fFirstAttributesIndex;
        }
        int n4 = this.fRegionStart + this.fRegionLength;
        this.fAttributesCount = 1;
        int n5 = this.fFirstAttributesIndex + 1;
        while (n5 < n3 && this.fParent.getAttributesStart(n5) < n4) {
            ++n5;
            ++this.fAttributesCount;
        }
    }

    @Override
    public int getAttributesCount() {
        return this.fAttributesCount;
    }

    @Override
    public int getAttributesStart(int n) {
        return n == 0 ? 0 : this.fParent.getAttributesStart(this.fFirstAttributesIndex + n) - this.fRegionStart;
    }

    @Override
    public int getAttributesLength(int n) {
        if (n == 0) {
            int n2 = this.fParent.getAttributesLength(this.fFirstAttributesIndex) - this.fRegionStart + this.fParent.getAttributesStart(this.fFirstAttributesIndex);
            return n2 > this.fRegionLength ? this.fRegionLength : n2;
        }
        if (n < this.fAttributesCount - 1) {
            return this.fParent.getAttributesLength(this.fFirstAttributesIndex + n);
        }
        return this.fRegionStart + this.fRegionLength - this.fParent.getAttributesStart(this.fFirstAttributesIndex + this.fAttributesCount - 1);
    }

    @Override
    public AttributeSet getAttributes(int n) {
        return this.fParent.getAttributes(this.fFirstAttributesIndex + n);
    }

    @Override
    public StyleRange[] getStyleRanges() {
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>(this.fAttributesCount);
        for (int i = 0; i < this.fAttributesCount; ++i) {
            AttributeSet attributeSet = this.getAttributes(i);
            if (attributeSet == null) continue;
            Color color = StyleConstants.getForeground(attributeSet);
            int n = 0;
            if (StyleConstants.isBold(attributeSet)) {
                ++n;
            }
            if (StyleConstants.isItalic(attributeSet)) {
                n += 2;
            }
            arrayList.add(new StyleRange(this.getAttributesStart(i), this.getAttributesLength(i), n, color));
        }
        return arrayList.toArray(new StyleRange[arrayList.size()]);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SubRegionStyleInfo)) {
            return false;
        }
        SubRegionStyleInfo subRegionStyleInfo = (SubRegionStyleInfo)object;
        if (!this.fParent.equals(subRegionStyleInfo.fParent)) {
            return false;
        }
        return this.fRegionStart == subRegionStyleInfo.fRegionStart && this.fRegionLength == subRegionStyleInfo.fRegionLength && this.fFirstAttributesIndex == subRegionStyleInfo.fFirstAttributesIndex && this.fAttributesCount == subRegionStyleInfo.fAttributesCount;
    }

    public int hashCode() {
        int n = this.fParent.hashCode();
        n += 17 * this.fRegionStart;
        return n += 17 * this.fRegionLength;
    }
}

