/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.MDispatchableCommand;
import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.SessionFactory;
import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.BufferTransferrable;
import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.io.Serializable;
import java.util.concurrent.Semaphore;

public final class CommunicationGroupProfiler {
    private CommunicationGroupProfiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommunicationGroupProfilerResult profileCommunicationsGroup(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws InterruptedException {
        final Semaphore semaphore = new Semaphore(0);
        Session session = SessionFactory.getCurrentSession();
        CommunicationGroup communicationGroup = session.getCommGroupForDebugONLY();
        int n3 = communicationGroup.getNumDestinations();
        long[] lArray = bl4 ? new long[n2] : null;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            if (bl3) {
                n4 = n;
            }
            int n5 = 0;
            if (bl2) {
                n5 = n;
            }
            CommunicationGroupProfilerMessage communicationGroupProfilerMessage = new CommunicationGroupProfilerMessage(n4, n5, bl);
            try {
                long l = System.nanoTime();
                communicationGroup.sendToAll(communicationGroupProfilerMessage, new MessageObserver(){

                    @Override
                    public void completed(ReturnMessage returnMessage, Instance instance) {
                        semaphore.release();
                    }
                });
                semaphore.acquire(n3);
                long l2 = System.nanoTime();
                long l3 = l2 - l;
                if (bl4) {
                    lArray[i] = l3;
                }
                d += (double)l3;
                d2 += (double)(l3 * l3);
                continue;
            }
            finally {
                communicationGroupProfilerMessage.free();
            }
        }
        double d3 = (double)n * (double)n2 * (double)n3;
        CommunicationGroupProfilerResult communicationGroupProfilerResult = new CommunicationGroupProfilerResult(d3, d, d2, lArray, n, n2, n3, bl, bl2, bl3);
        System.out.println(communicationGroupProfilerResult.getSummary());
        return communicationGroupProfilerResult;
    }

    private static final class CommunicationGroupProfilerResult
    implements Serializable {
        private final double fBytesSent;
        private final double fNanosecondsUsed;
        private final double fNanosecondsSquaredUsed;
        private final long[] fRawSamples;
        private final int fBytesPerMessage;
        private final int fRepetitions;
        private final int fNumLabs;
        private final boolean fUseDirect;
        private final boolean fInbound;
        private final boolean fOutbound;

        CommunicationGroupProfilerResult(double d, double d2, double d3, long[] lArray, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
            this.fBytesSent = d;
            this.fNanosecondsUsed = d2;
            this.fNanosecondsSquaredUsed = d3;
            this.fRawSamples = lArray;
            this.fBytesPerMessage = n;
            this.fRepetitions = n2;
            this.fNumLabs = n3;
            this.fUseDirect = bl;
            this.fInbound = bl2;
            this.fOutbound = bl3;
        }

        public String getSummary() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("time: " + this.fNanosecondsUsed + "ns for " + this.fBytesSent + " bytes\n");
            stringBuilder.append("Megabits/sec: " + this.getMegabytesPerSecond() * 8.0 + "\n");
            stringBuilder.append("Average round-trip latency (ns): " + this.getAverageRoundTripLatency() + "\n");
            stringBuilder.append("Standard deviation of round trip latency (ns)" + this.getStandardDeviationOfLatency());
            return stringBuilder.toString();
        }

        public double getBytesPerNanosecond() {
            return this.fBytesSent / this.fNanosecondsUsed;
        }

        public double getStandardDeviationOfLatency() {
            return Math.sqrt(Math.abs(this.fNanosecondsSquaredUsed / (double)this.fRepetitions - this.getAverageRoundTripLatency() * this.getAverageRoundTripLatency()));
        }

        public double getBytesPerSecond() {
            return this.getBytesPerNanosecond() * 1.0E9;
        }

        public double getMegabytesPerSecond() {
            return this.getBytesPerNanosecond() * 1000.0;
        }

        public double getAverageRoundTripLatency() {
            return this.fNanosecondsUsed / (double)this.fRepetitions;
        }

        public double getBytesSent() {
            return this.fBytesSent;
        }

        public double getNanosecondsUsed() {
            return this.fNanosecondsUsed;
        }

        public double getNanosecondsSquaredUsed() {
            return this.fNanosecondsSquaredUsed;
        }

        public long[] getRawSamples() {
            return this.fRawSamples;
        }

        public int getBytesPerMessage() {
            return this.fBytesPerMessage;
        }

        public int getRepetitions() {
            return this.fRepetitions;
        }

        public int getNumlabs() {
            return this.fNumLabs;
        }

        public boolean isUseDirect() {
            return this.fUseDirect;
        }

        public boolean isInbound() {
            return this.fInbound;
        }

        public boolean isOutbound() {
            return this.fOutbound;
        }

        public String toString() {
            return "CommunicationGroupProfilerResult{fBytesSent=" + this.fBytesSent + ", fNanosecondsUsed=" + this.fNanosecondsUsed + ", fNanosecondsSquaredUsed=" + this.fNanosecondsSquaredUsed + ", fBytesPerMessage=" + this.fBytesPerMessage + ", fRepetitions=" + this.fRepetitions + ", fNumLabs=" + this.fNumLabs + ", fUseDirect=" + this.fUseDirect + ", fInbound=" + this.fInbound + ", fOutbound=" + this.fOutbound + '}';
        }
    }

    private static final class CommunicationGroupProfilerReply
    extends FinalReturnMessage
    implements BufferTransferrable {
        private transient ByteBufferHandle fByteBufferHandle;

        private CommunicationGroupProfilerReply(long l, int n, boolean bl) {
            super(l);
            this.fByteBufferHandle = bl ? ByteBufferHandle.allocateDirect(n) : ByteBufferHandle.allocate(n);
        }

        @Override
        public ByteBufferHandle[] getByteBuffers() {
            this.fByteBufferHandle.get();
            return new ByteBufferHandle[]{this.fByteBufferHandle};
        }

        public void free() {
            this.fByteBufferHandle.free();
        }

        @Override
        public void setByteBuffers(ByteBufferHandle[] byteBufferHandleArray) {
            this.fByteBufferHandle = byteBufferHandleArray[0];
        }
    }

    private static final class CommunicationGroupProfilerMessage
    extends MDispatchableCommand
    implements BufferTransferrable {
        private transient ByteBufferHandle fByteBufferHandle;
        private final int fReplyMessageSize;
        private final boolean fUseDirect;

        private CommunicationGroupProfilerMessage(int n, int n2, boolean bl) {
            this.fReplyMessageSize = n2;
            this.fUseDirect = bl;
            this.fByteBufferHandle = bl ? ByteBufferHandle.allocateDirect(n) : ByteBufferHandle.allocate(n);
        }

        @Override
        public ByteBufferHandle[] getByteBuffers() {
            this.fByteBufferHandle.get();
            return new ByteBufferHandle[]{this.fByteBufferHandle};
        }

        public void free() {
            this.fByteBufferHandle.free();
        }

        @Override
        public void setByteBuffers(ByteBufferHandle[] byteBufferHandleArray) {
            this.fByteBufferHandle = byteBufferHandleArray[0];
        }

        @Override
        public void dispatch(ReturnGroup returnGroup, Instance instance, Session session) {
            returnGroup.returnTo(instance, new CommunicationGroupProfilerReply(this.getSequenceNumber(), this.fReplyMessageSize, this.fUseDirect));
        }
    }
}

