/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.LoopState;

class LoopStateTracker {
    private LoopState fLoopState;
    private LoopState[] fLabLoopState;
    private int fNumStarted;
    private int fNumSendComplete;
    private int fNumReceiveComplete;

    LoopStateTracker(int n) {
        this.fLabLoopState = new LoopState[n];
        for (int i = 0; i < n; ++i) {
            this.fLabLoopState[i] = LoopState.Initialized;
        }
        this.fLoopState = LoopState.Initialized;
        this.fNumStarted = 0;
        this.fNumSendComplete = 0;
        this.fNumReceiveComplete = 0;
    }

    public synchronized LoopState getState() {
        return this.fLoopState;
    }

    public synchronized LoopState getState(int n) {
        return this.fLabLoopState[n];
    }

    public synchronized int getNumStarted() {
        return this.fNumStarted;
    }

    public synchronized int getNumSendComplete() {
        return this.fNumSendComplete;
    }

    public synchronized int getNumReceiveComplete() {
        return this.fNumReceiveComplete;
    }

    synchronized void setState(LoopState loopState) {
        assert (loopState.ordinal() >= this.fLoopState.ordinal()) : "LoopState must increase";
        this.fLoopState = loopState;
    }

    synchronized void setState(int n, LoopState loopState) {
        assert (loopState.ordinal() > this.fLabLoopState[n].ordinal()) : "LoopState must increase";
        this.fLabLoopState[n] = loopState;
        boolean bl = false;
        switch (loopState) {
            case Acquired: {
                bl = this.fLoopState != loopState;
                break;
            }
            case Started: {
                ++this.fNumStarted;
                bl = this.fLoopState != loopState;
                break;
            }
            case SendComplete: {
                bl = ++this.fNumSendComplete == this.fLabLoopState.length;
                break;
            }
            case ReceiveComplete: {
                boolean bl2 = bl = ++this.fNumReceiveComplete == this.fLabLoopState.length;
            }
        }
        if (bl) {
            this.fLoopState = loopState;
        }
    }
}

