/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.BufferType;
import com.mathworks.toolbox.distcomp.pmode.io.DefaultHeaderPayload;
import com.mathworks.toolbox.distcomp.pmode.io.HeaderPayload;
import com.mathworks.toolbox.distcomp.pmode.io.MessageType;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.io.SerializationHelpers;
import com.mathworks.toolbox.distcomp.pmode.shared.BufferTransferrable;
import com.mathworks.toolbox.distcomp.pmode.shared.PmodeSerializable;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.EnumUtils;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Vector;

final class Messages {
    public static HeaderPayload createHeaderPayloadForReceive() {
        ByteBufferHandle byteBufferHandle = ByteBufferHandle.allocate(80);
        byteBufferHandle.get().position(0).limit(byteBufferHandle.get().capacity());
        return new DefaultHeaderPayload(byteBufferHandle);
    }

    public static void configurePayload(HeaderPayload headerPayload) {
        assert (headerPayload.isHeaderCompletelyTransmitted()) : "Illegal attempt to configure payload";
        ByteBufferHandle byteBufferHandle = headerPayload.getHeaderMessage();
        int[] nArray = Messages.readHeaderInfo(byteBufferHandle);
        MessageType messageType = EnumUtils.ordinalToEnum(MessageType.class, nArray[0]);
        switch (messageType) {
            case PLAIN_SERIAL: {
                Messages.configurePlainSerial(headerPayload, nArray);
                break;
            }
            case BUFFER_ATTACHED: {
                Messages.configureBufTransf(headerPayload, nArray);
            }
        }
    }

    public static PmodeSerializable interpretCompletedMessage(HeaderPayload headerPayload) throws IOException, ClassNotFoundException {
        assert (headerPayload.isHeaderCompletelyTransmitted()) : "Illegal attempt to interpret message when header not transmitted: " + headerPayload.getHeaderMessage();
        assert (headerPayload.isPayloadCompletelyTransmitted()) : "Illegal attempt to interpret message when payload not transmitted";
        ByteBufferHandle[] byteBufferHandleArray = headerPayload.getPayloadMessages();
        assert (byteBufferHandleArray.length > 0) : "Currently, cannot handle 0 payloads - no concept of header-only message";
        byteBufferHandleArray[0].get().flip();
        PmodeSerializable pmodeSerializable = SerializationHelpers.deserializeFromByteBuffer(byteBufferHandleArray[0]);
        if (pmodeSerializable instanceof BufferTransferrable) {
            BufferTransferrable bufferTransferrable = (BufferTransferrable)pmodeSerializable;
            ByteBufferHandle[] byteBufferHandleArray2 = new ByteBufferHandle[byteBufferHandleArray.length - 1];
            for (int i = 0; i < byteBufferHandleArray.length - 1; ++i) {
                ByteBufferHandle byteBufferHandle = byteBufferHandleArray[i + 1];
                byteBufferHandle.get().rewind();
                byteBufferHandleArray2[i] = byteBufferHandle;
            }
            bufferTransferrable.setByteBuffers(byteBufferHandleArray2);
        } else assert (byteBufferHandleArray.length == 1) : "Unhandled ByteBufferHandles!";
        return pmodeSerializable;
    }

    public static HeaderPayload createHeaderPayloadForSend(PmodeSerializable pmodeSerializable) throws IOException {
        if (pmodeSerializable instanceof BufferTransferrable) {
            return Messages.createHeaderPayloadForSendBT((BufferTransferrable)pmodeSerializable);
        }
        return Messages.createHeaderPayloadForSendDefault(pmodeSerializable);
    }

    private static ByteBufferHandle buildHeader(Integer[] integerArray) {
        ByteBufferHandle byteBufferHandle = ByteBufferHandle.allocate(80);
        byteBufferHandle.get().putLong(System.currentTimeMillis());
        for (Integer n : integerArray) {
            byteBufferHandle.get().putInt(n);
        }
        byteBufferHandle.get().position(0).limit(byteBufferHandle.get().capacity());
        return byteBufferHandle;
    }

    private static HeaderPayload createHeaderPayloadForSendDefault(PmodeSerializable pmodeSerializable) throws IOException {
        ByteBufferHandle byteBufferHandle = SerializationHelpers.serializeToByteBuffer(pmodeSerializable, BufferType.HEAP);
        ByteBufferHandle byteBufferHandle2 = Messages.buildHeader(new Integer[]{MessageType.PLAIN_SERIAL.ordinal(), 1, byteBufferHandle.get().capacity()});
        return new DefaultHeaderPayload(byteBufferHandle2, new ByteBufferHandle[]{byteBufferHandle});
    }

    private static HeaderPayload createHeaderPayloadForSendBT(BufferTransferrable bufferTransferrable) throws IOException {
        ByteBufferHandle byteBufferHandle = SerializationHelpers.serializeToByteBuffer(bufferTransferrable, BufferType.HEAP);
        ByteBufferHandle[] byteBufferHandleArray = bufferTransferrable.getByteBuffers();
        Vector<ByteBufferHandle> vector = new Vector<ByteBufferHandle>();
        Vector<Integer> vector2 = new Vector<Integer>();
        vector2.addElement(MessageType.BUFFER_ATTACHED.ordinal());
        vector2.addElement(1 + byteBufferHandleArray.length);
        vector2.addElement(byteBufferHandle.get().capacity());
        vector.addElement(byteBufferHandle);
        for (ByteBufferHandle byteBufferHandle2 : byteBufferHandleArray) {
            ByteBufferHandle byteBufferHandle3 = byteBufferHandle2.duplicate();
            vector.addElement(byteBufferHandle3);
            vector2.addElement(byteBufferHandle3.get().capacity());
        }
        ByteBufferHandle byteBufferHandle4 = Messages.buildHeader(vector2.toArray(new Integer[vector2.size()]));
        ByteBufferHandle[] byteBufferHandleArray2 = vector.toArray(new ByteBufferHandle[vector.size()]);
        return new DefaultHeaderPayload(byteBufferHandle4, byteBufferHandleArray2);
    }

    private static int[] readHeaderInfo(ByteBufferHandle byteBufferHandle) {
        ByteBufferHandle byteBufferHandle2 = byteBufferHandle.duplicate();
        byteBufferHandle2.get().position(0);
        long l = byteBufferHandle2.get().getLong();
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Received message latency: " + (System.currentTimeMillis() - l));
        IntBuffer intBuffer = byteBufferHandle2.get().asIntBuffer();
        int[] nArray = new int[intBuffer.capacity()];
        intBuffer.get(nArray);
        byteBufferHandle2.free();
        return nArray;
    }

    private static void configurePlainSerial(HeaderPayload headerPayload, int[] nArray) {
        int n = nArray[1];
        int n2 = nArray[2];
        assert (n == 1) : "Expected only 1 buffer for plain old PmodeSerializable";
        ByteBufferHandle byteBufferHandle = n2 > 102400 ? ByteBufferHandle.allocateDirect(n2) : ByteBufferHandle.allocate(n2);
        byteBufferHandle.get().position(0).limit(n2);
        headerPayload.setPayloadMessages(new ByteBufferHandle[]{byteBufferHandle});
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Configured for PmodeSerializable expecting " + n2);
    }

    private static void configureBufTransf(HeaderPayload headerPayload, int[] nArray) {
        int n = nArray[1];
        int n2 = 2;
        ByteBufferHandle[] byteBufferHandleArray = new ByteBufferHandle[n];
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[n2++];
            byteBufferHandleArray[i] = i == 0 ? ByteBufferHandle.allocate(n3) : ByteBufferHandle.allocateDirect(n3);
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Configured for BufferTransferrable, buffer " + i + " expecting " + n3);
        }
        headerPayload.setPayloadMessages(byteBufferHandleArray);
    }

    private Messages() {
    }
}

