/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.util.concurrent.DaemonThreadFactory;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;

public final class AsyncSelector {
    private static final String PREFIX = "AsyncSelector: ";
    private final BlockingQueue<PendingRegistration> fPendingRegistrations;
    private final BlockingQueue<SelectableChannel> fPendingCancellations;
    private final Selector fSelector;
    private final int fSelectTimeout;
    private final int fKeepAliveTime;
    private final ThreadFactory fThreadFactory;
    private boolean fSelectThreadExpired;
    private Thread fSelectThread;
    private final Lock fSelectThreadLock = new ReentrantLock();

    public AsyncSelector(int n, int n2, ThreadFactory threadFactory) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("keepAliveTime can not be negative.");
        }
        this.fKeepAliveTime = n2;
        this.fSelector = Selector.open();
        this.fSelectTimeout = n;
        this.fPendingRegistrations = new LinkedBlockingQueue<PendingRegistration>();
        this.fPendingCancellations = new LinkedBlockingQueue<SelectableChannel>();
        this.fSelectThreadExpired = true;
        this.fThreadFactory = threadFactory;
    }

    public void close() throws IOException {
        this.fSelector.close();
    }

    public AsyncSelector(int n, int n2) throws IOException {
        this(n, n2, new DaemonThreadFactory(AsyncSelector.class.getSimpleName()));
    }

    public void register(SelectableChannel selectableChannel, int n, SelectHandler selectHandler) {
        if (selectableChannel.isBlocking()) {
            throw new IllegalArgumentException("SelectableChannel should be configured to be non-blocking");
        }
        if (n != 16) {
            throw new IllegalArgumentException("Only OP_ACCEPT is supported for interestSet at this time.");
        }
        PackageInfo.LOGGER.info("AsyncSelector: Adding pending registration for channel " + selectableChannel);
        PendingRegistration pendingRegistration = new PendingRegistration(selectableChannel, n, selectHandler);
        this.fPendingRegistrations.add(pendingRegistration);
        this.ensureSelectThreadRunning();
        this.fSelector.wakeup();
    }

    public void cancel(SelectableChannel selectableChannel) {
        PackageInfo.LOGGER.info("AsyncSelector: Adding pending cancellation of registration for channel " + selectableChannel);
        this.fPendingCancellations.add(selectableChannel);
        this.fSelector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSelectThreadRunning() {
        this.fSelectThreadLock.lock();
        try {
            if (this.fSelectThreadExpired || this.fSelectThread != null && !this.fSelectThread.isAlive()) {
                PackageInfo.LOGGER.fine("AsyncSelector: Creating new Thread");
                this.fSelectThread = this.fThreadFactory.newThread(new SelectTask());
                this.fSelectThreadExpired = false;
                this.fSelectThread.start();
            }
        }
        finally {
            this.fSelectThreadLock.unlock();
        }
    }

    private static class PendingRegistration {
        private final SelectableChannel fChannel;
        private final SelectHandler fHandler;
        private final int fInterestSet;

        private PendingRegistration(SelectableChannel selectableChannel, int n, SelectHandler selectHandler) {
            this.fChannel = selectableChannel;
            this.fHandler = selectHandler;
            this.fInterestSet = n;
        }

        private SelectableChannel getChannel() {
            return this.fChannel;
        }

        private SelectHandler getHandler() {
            return this.fHandler;
        }

        private int getInterestSet() {
            return this.fInterestSet;
        }

        public String toString() {
            return "PendingRegistration{fChannel=" + this.fChannel + ", fHandler=" + this.fHandler + ", fInterestSet=" + this.fInterestSet + '}';
        }
    }

    private static class KeepAliveDeadLine {
        private static final long DEAD_LINE_NOT_SET = -1L;
        private final long fKeepAliveTime;
        private long fKeepAliveDeadLine;

        private KeepAliveDeadLine(long l) {
            this.fKeepAliveTime = l;
        }

        private boolean hasExpired(boolean bl) {
            boolean bl2;
            if (bl) {
                this.fKeepAliveDeadLine = -1L;
                bl2 = false;
            } else {
                long l = System.currentTimeMillis();
                if (this.fKeepAliveDeadLine == -1L) {
                    this.fKeepAliveDeadLine = l + this.fKeepAliveTime;
                }
                bl2 = l >= this.fKeepAliveDeadLine;
                PackageInfo.LOGGER.finest("AsyncSelector: KeepAliveDeadLine expired: " + bl2);
            }
            return bl2;
        }
    }

    private class SelectTask
    implements Runnable {
        private SelectTask() {
        }

        @Override
        public void run() {
            PackageInfo.LOGGER.fine("AsyncSelector: Starting new SelectTask");
            KeepAliveDeadLine keepAliveDeadLine = new KeepAliveDeadLine(AsyncSelector.this.fKeepAliveTime);
            while (true) {
                try {
                    do {
                        this.handlePendingRegistrations();
                        this.handlePendingCancellations();
                        int n = AsyncSelector.this.fSelector.select(AsyncSelector.this.fSelectTimeout);
                        if (n <= 0) continue;
                        this.handleSelect();
                    } while (AsyncSelector.this.fSelector.isOpen() && !this.shouldThreadEnd(keepAliveDeadLine));
                    PackageInfo.LOGGER.fine("AsyncSelector: Selector has been closed, or there are no keys in Selector and no work pending. Select thread will now end.");
                    return;
                }
                catch (ClosedSelectorException closedSelectorException) {
                    PackageInfo.LOGGER.finest("AsyncSelector: Selector has been closed");
                    continue;
                }
                catch (IOException iOException) {
                    PackageInfo.LOGGER.log(Level.SEVERE, "AsyncSelector: IOException", iOException);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shouldThreadEnd(KeepAliveDeadLine keepAliveDeadLine) {
            int n = AsyncSelector.this.fSelector.keys().size();
            if (n == 0) {
                PackageInfo.LOGGER.finest("AsyncSelector: No keys in Selector.");
                AsyncSelector.this.fSelectThreadLock.lock();
                try {
                    boolean bl = !AsyncSelector.this.fPendingRegistrations.isEmpty() || !AsyncSelector.this.fPendingCancellations.isEmpty();
                    PackageInfo.LOGGER.finest("AsyncSelector: workPending=" + bl);
                    AsyncSelector.this.fSelectThreadExpired = keepAliveDeadLine.hasExpired(bl);
                    boolean bl2 = AsyncSelector.this.fSelectThreadExpired;
                    return bl2;
                }
                finally {
                    AsyncSelector.this.fSelectThreadLock.unlock();
                }
            }
            return false;
        }

        private void handlePendingRegistrations() throws ClosedChannelException {
            PendingRegistration pendingRegistration = (PendingRegistration)AsyncSelector.this.fPendingRegistrations.poll();
            while (pendingRegistration != null) {
                PackageInfo.LOGGER.fine("AsyncSelector: handlePendingRegistration " + pendingRegistration);
                SelectableChannel selectableChannel = pendingRegistration.getChannel();
                if (AsyncSelector.this.fPendingCancellations.contains(selectableChannel)) {
                    AsyncSelector.this.fPendingCancellations.remove(selectableChannel);
                } else {
                    SelectHandler selectHandler = pendingRegistration.getHandler();
                    int n = pendingRegistration.getInterestSet();
                    PackageInfo.LOGGER.info("AsyncSelector: registering new channel " + selectableChannel);
                    try {
                        selectableChannel.register(AsyncSelector.this.fSelector, n, selectHandler);
                    }
                    catch (RuntimeException runtimeException) {
                        PackageInfo.LOGGER.log(Level.SEVERE, "AsyncSelector: Failed to register channel " + selectableChannel, runtimeException);
                    }
                }
                pendingRegistration = (PendingRegistration)AsyncSelector.this.fPendingRegistrations.poll();
            }
        }

        private void handlePendingCancellations() {
            SelectableChannel selectableChannel = (SelectableChannel)AsyncSelector.this.fPendingCancellations.poll();
            while (selectableChannel != null) {
                PackageInfo.LOGGER.fine("AsyncSelector: cancel channel " + selectableChannel);
                Set<SelectionKey> set = AsyncSelector.this.fSelector.keys();
                boolean bl = false;
                for (SelectionKey selectionKey : set) {
                    if (!selectionKey.channel().equals(selectableChannel)) continue;
                    PackageInfo.LOGGER.info("AsyncSelector: cancelling selection key for " + selectableChannel);
                    selectionKey.cancel();
                    bl = true;
                    break;
                }
                if (!bl) {
                    PackageInfo.LOGGER.info("AsyncSelector: Failed to cancel registration for channel: " + selectableChannel);
                }
                selectableChannel = (SelectableChannel)AsyncSelector.this.fPendingCancellations.poll();
            }
        }

        private void handleSelect() throws IOException {
            Iterator<SelectionKey> iterator = AsyncSelector.this.fSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                if (selectionKey.isValid()) {
                    if (selectionKey.isAcceptable()) {
                        this.handleAccept(selectionKey);
                        continue;
                    }
                    assert (false) : "Not currently handling this interest " + selectionKey.interestOps();
                    continue;
                }
                PackageInfo.LOGGER.info("AsyncSelector: invalid key " + selectionKey);
            }
        }

        private void handleAccept(SelectionKey selectionKey) throws IOException {
            PackageInfo.LOGGER.fine("AsyncSelector: About to accept new channel.");
            SocketChannel socketChannel = ((ServerSocketChannel)selectionKey.channel()).accept();
            PackageInfo.LOGGER.fine("AsyncSelector: Accepted new channel " + socketChannel);
            Object object = selectionKey.attachment();
            if (object instanceof SelectHandler) {
                SelectHandler selectHandler = (SelectHandler)object;
                PackageInfo.LOGGER.fine("AsyncSelector: Calling handleAccept.");
                selectHandler.handleAccept(socketChannel);
            } else {
                PackageInfo.LOGGER.warning("AsyncSelector: unexpected attachment type " + object.getClass());
            }
        }
    }

    public static interface SelectHandler {
        public void handleAccept(SocketChannel var1);
    }
}

