/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.cli;

import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.NoMatchingProtocolException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutor;
import com.mathworks.toolbox.distcomp.remote.RemoteStreamException;
import com.mathworks.toolbox.distcomp.remote.ShellFuture;
import com.mathworks.toolbox.distcomp.remote.cli.CopyCommandFactory;
import com.mathworks.toolbox.distcomp.remote.spi.Protocol;
import com.mathworks.toolbox.distcomp.remote.util.OutputRedirector;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public final class CommandExecutor {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Map<String, Future> fFutureByHost = new HashMap<String, Future>();
    private final List<OutputRedirector> fRedirectors = new LinkedList<OutputRedirector>();
    private int fNumCommandsDispatched;
    private int fNumCommandsSucceeded;

    int execute(Command command, ParameterMap parameterMap, List<String> list, Protocol protocol) {
        int n = list.size();
        this.fNumCommandsDispatched = 0;
        this.fNumCommandsSucceeded = 0;
        this.dispatchCommandToAllHosts(command, parameterMap, list, protocol);
        this.redirectShellOutput();
        this.awaitEndOfOutput();
        this.awaitEnd();
        this.cleanup();
        if (this.fNumCommandsSucceeded == n) {
            return 0;
        }
        if (this.fNumCommandsDispatched == 0) {
            return 1;
        }
        if (this.fNumCommandsSucceeded == 0) {
            return 2;
        }
        return 3;
    }

    private void dispatchCommandToAllHosts(Command command, ParameterMap parameterMap, List<String> list, Protocol protocol) {
        for (String string : list) {
            Command command2 = command;
            if (command instanceof CopyFromRemoteCommand && list.size() > 1) {
                command2 = CopyCommandFactory.createCommand((CopyCommand)command, "." + string);
            }
            try {
                Future future = protocol == null ? RemoteExecutor.executeUsingRecommendedProtocol(command2, string, parameterMap) : protocol.execute(command2, string, parameterMap);
                this.fFutureByHost.put(string, future);
                ++this.fNumCommandsDispatched;
            }
            catch (DispatchException dispatchException) {
                this.processFailure(string, dispatchException);
            }
            catch (NoMatchingProtocolException noMatchingProtocolException) {
                this.processFailure(string, noMatchingProtocolException);
            }
        }
    }

    private void redirectShellOutput() {
        for (String string : this.fFutureByHost.keySet()) {
            Future future = this.fFutureByHost.get(string);
            if (!(future instanceof ShellFuture)) continue;
            ShellFuture shellFuture = (ShellFuture)future;
            try {
                this.fRedirectors.add(new OutputRedirector(shellFuture.getInputStream(), shellFuture.getErrorStream(), System.out, System.err, string + " out: ", string + " err: "));
            }
            catch (RemoteStreamException remoteStreamException) {
                this.processFailure(string, remoteStreamException);
            }
        }
    }

    private void awaitEndOfOutput() {
        for (OutputRedirector outputRedirector : this.fRedirectors) {
            try {
                outputRedirector.awaitEndOfRedirects();
            }
            catch (InterruptedException interruptedException) {
                Logger.LOGGER.log(Level.WARNING, "Interrupted while waiting for eofs. May have lost some data.", interruptedException);
            }
        }
    }

    private void awaitEnd() {
        for (String string : this.fFutureByHost.keySet()) {
            Future future = this.fFutureByHost.get(string);
            try {
                future.awaitEnd();
                if (future instanceof ShellFuture) {
                    ShellFuture shellFuture = (ShellFuture)future;
                    if (shellFuture.getExitStatus() == 0) {
                        ++this.fNumCommandsSucceeded;
                    }
                    String string2 = shellFuture.isExitStatusOfRemoteCommand() ? "remote command" : "local client";
                    Logger.LOGGER.info(String.format("%s exit code of %s: %d", string, string2, shellFuture.getExitStatus()));
                    continue;
                }
                ++this.fNumCommandsSucceeded;
            }
            catch (Exception exception) {
                this.processFailure(string, exception);
            }
        }
    }

    private void cleanup() {
        for (OutputRedirector outputRedirector : this.fRedirectors) {
            outputRedirector.close();
        }
    }

    private void processFailure(String string, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%s err: Execution failed for the following reason:\n", string));
        stringBuilder.append(String.format("%s err:   %s", string, throwable.getMessage()));
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuilder.append(String.format("\n%s err:   Caused by:\n", string));
            stringBuilder.append(String.format("%s err:     %s", string, throwable2.getMessage()));
        }
        System.err.println(stringBuilder.toString());
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        for (String string2 : stringWriter.toString().split(LINE_SEPARATOR)) {
            Logger.LOGGER.warning(String.format("%s err: %s", string, string2));
        }
    }
}

