/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class StreamRedirector
implements Runnable {
    private static final StreamRedirector sStreamRedirector = new StreamRedirector();
    private static final int MAX_TO_REDIRECT_IN_ONE_CALL = 0x100000;
    private static final int MIN_SLEEP_TIME = 50;
    private static final int SLEEP_TIME_INC = 50;
    private static final int MAX_SLEEP_TIME = 1000;
    private final List<RedirectionPair> fActiveRedirections = Collections.synchronizedList(new LinkedList());
    private final ReentrantLock fSleepLock = new ReentrantLock();
    private final Condition fSleepCondition = this.fSleepLock.newCondition();
    private Thread fThread;

    public static StreamRedirector getInstance() {
        return sStreamRedirector;
    }

    public RedirectionPair addRedirect(InputStream inputStream, OutputStream outputStream) {
        RedirectionPair redirectionPair = new RedirectionPair(new BufferedInputStream(inputStream), new BufferedOutputStream(outputStream));
        this.addPairToList(redirectionPair);
        return redirectionPair;
    }

    public RedirectionPair addRedirect(InputStream inputStream, OutputStream outputStream, String string) {
        RedirectionPair redirectionPair = new RedirectionPair(new BufferedInputStream(inputStream), new BufferedOutputStream(outputStream), string);
        this.addPairToList(redirectionPair);
        return redirectionPair;
    }

    public void removeRedirect(RedirectionPair redirectionPair) {
        this.removePairFromList(redirectionPair);
        try {
            redirectionPair.pipeAvailableData();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized boolean containsRedirect(RedirectionPair redirectionPair) {
        return this.fActiveRedirections.contains(redirectionPair);
    }

    public int getNumberOfRedirections() {
        return this.fActiveRedirections.size();
    }

    public boolean isThreadAlive() {
        return this.fThread == null ? false : this.fThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 50;
        while (true) {
            Object object;
            boolean bl = false;
            for (RedirectionPair redirectionPair : object = this.fActiveRedirections.toArray(new RedirectionPair[0])) {
                try {
                    bl |= redirectionPair.pipeAvailableData() > 0;
                }
                catch (IOException iOException) {
                    this.removePairFromList(redirectionPair);
                }
            }
            int n2 = n = bl ? 50 : n;
            if (bl) continue;
            this.fSleepLock.lock();
            try {
                boolean bl2 = this.fSleepCondition.await(n, TimeUnit.MILLISECONDS);
                n = bl2 ? 50 : Math.min(n + 50, 1000);
            }
            catch (InterruptedException interruptedException) {
                this.fThread = null;
                return;
            }
            finally {
                this.fSleepLock.unlock();
            }
            object = this;
            synchronized (object) {
                if (this.fActiveRedirections.size() == 0) {
                    this.fThread = null;
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addPairToList(RedirectionPair redirectionPair) {
        boolean bl = this.fThread == null;
        this.fActiveRedirections.add(redirectionPair);
        if (bl) {
            this.fThread = new Thread(this);
            this.fThread.start();
        } else {
            this.fSleepLock.lock();
            try {
                this.fSleepCondition.signal();
            }
            finally {
                this.fSleepLock.unlock();
            }
        }
    }

    private synchronized void removePairFromList(RedirectionPair redirectionPair) {
        this.fActiveRedirections.remove(redirectionPair);
    }

    public static class RedirectionPair {
        private InputStream fInput;
        private OutputStream fOutput;
        private boolean fPreprendLineHeaders;
        private boolean fNextLineNeedsHeader;
        private String fBareLineHeader;
        private String fLineHeaderReplacement;
        private static String sLineSeparator = System.getProperty("line.separator");

        RedirectionPair(InputStream inputStream, OutputStream outputStream) {
            this(inputStream, outputStream, null);
        }

        RedirectionPair(InputStream inputStream, OutputStream outputStream, String string) {
            this.fInput = inputStream;
            this.fOutput = outputStream;
            this.fPreprendLineHeaders = string != null;
            this.fNextLineNeedsHeader = true;
            this.fBareLineHeader = string == null ? "" : string + " ";
            this.fLineHeaderReplacement = string == null ? "" : sLineSeparator + string + " ";
        }

        private synchronized int pipeAvailableData() throws IOException {
            try {
                int n;
                int n2 = 0;
                while ((n = this.fInput.available()) > 0) {
                    byte[] byArray = new byte[n];
                    int n3 = this.fInput.read(byArray);
                    if (n3 > 0) {
                        if (this.fPreprendLineHeaders) {
                            String string = this.prependLineHeaders(new String(byArray, 0, n3));
                            byArray = string.getBytes();
                            n3 = byArray.length;
                        }
                        this.fOutput.write(byArray, 0, n3);
                        this.fOutput.flush();
                        n2 += n3;
                    }
                    if (n2 < 0x100000) continue;
                }
                return n2;
            }
            catch (IOException iOException) {
                String string = "IOException caught in stream redirection - log closing : " + iOException.getMessage();
                this.fOutput.write(string.getBytes(), 0, string.length());
                throw iOException;
            }
        }

        private String prependLineHeaders(String string) {
            if (this.fNextLineNeedsHeader) {
                string = this.fBareLineHeader + string;
            }
            this.fNextLineNeedsHeader = string.endsWith(sLineSeparator);
            if (this.fNextLineNeedsHeader) {
                string = string.substring(0, string.length() - sLineSeparator.length());
                string = string.replace(sLineSeparator, this.fLineHeaderReplacement) + sLineSeparator;
            } else {
                string = string.replace(sLineSeparator, this.fLineHeaderReplacement);
            }
            return string;
        }
    }
}

