/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.service.PersistenceDirException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.sun.jini.reliableLog.LogException;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.Name;
import org.apache.commons.io.FileUtils;

public class PersistentServiceConfiguration
extends LogHandler
implements Serializable {
    private transient ReliableLog fPersistenceLog;
    protected String fPersistenceDirName;
    private boolean fValuesInitialized = false;
    private String fServiceName;
    private LookupLocator[] fLookupLocators;
    private int fMinExportPort;
    private String fLogDirName;
    private String fServiceLogFile;
    private int fLogLevel;
    private transient Handler fServiceHandler;
    private int fSecurityLevel;
    private String fSecurityDir;
    private boolean fUsingSecureCommunication;
    private boolean fTrustingClients;
    private boolean fRequireWebLicensing;
    private boolean fUsingActivatableExporter;
    private int fDefaultRmiClientConnectTimeoutSecs;
    private String fMatlabRoot;

    public PersistentServiceConfiguration(Configuration configuration, String string) throws ConfigurationException, PersistenceDirException {
        this.fPersistenceDirName = (String)configuration.getEntry(string, "persistenceDirectory", String.class);
        try {
            this.fPersistenceLog = new ReliableLog(this.fPersistenceDirName, (LogHandler)this);
        }
        catch (IOException iOException) {
            throw new PersistenceDirException("Unable to create the directory: " + this.fPersistenceDirName, iOException, this.fPersistenceDirName);
        }
        this.recover();
        if (!this.fValuesInitialized) {
            this.initServiceInfo(configuration, string);
            this.fValuesInitialized = true;
            this.snapshot();
        }
        if (this.fServiceHandler == null) {
            this.fServiceHandler = (Handler)configuration.getEntry(string, "serviceHandler", Handler.class);
            Level level = DistcompLevel.getLevelFromValue(this.getLogLevel());
            this.fServiceHandler.setLevel(level);
        }
    }

    public synchronized Entry[] getLookupAttributes() {
        return new Entry[]{new Name(this.fServiceName)};
    }

    public synchronized String getPersistenceDirectory() {
        return this.fPersistenceDirName;
    }

    public synchronized String getServiceName() {
        return this.fServiceName;
    }

    public synchronized LookupLocator[] getLookupLocators() {
        return this.fLookupLocators;
    }

    public synchronized int getMinExportPort() {
        return this.fMinExportPort;
    }

    public synchronized int getLogLevel() {
        return this.fLogLevel;
    }

    public synchronized Handler getServiceHandler() {
        return this.fServiceHandler;
    }

    public synchronized String getLogDirectory() {
        return this.fLogDirName;
    }

    public synchronized String getServiceLogFile() {
        return this.fServiceLogFile;
    }

    public synchronized void setLogLevel(int n) throws PersistenceDirException {
        Level level = DistcompLevel.getLevelFromValue(n);
        this.fServiceHandler.setLevel(level);
        this.fLogLevel = n;
        this.snapshot();
    }

    public synchronized int getSecurityLevel() {
        return this.fSecurityLevel;
    }

    public synchronized String getSecurityDirectory() {
        return this.fSecurityDir;
    }

    public synchronized boolean isUsingSecureCommunication() {
        return this.fUsingSecureCommunication;
    }

    public synchronized boolean isTrustingClients() {
        return this.fTrustingClients;
    }

    public synchronized boolean requireWebLicensing() {
        return this.fRequireWebLicensing;
    }

    public synchronized boolean isUsingActivatableExporter() {
        return this.fUsingActivatableExporter;
    }

    public synchronized int getDefaultRmiClientConnectTimeoutSecs() {
        return this.fDefaultRmiClientConnectTimeoutSecs;
    }

    public synchronized String getMatlabRoot() {
        return this.fMatlabRoot;
    }

    public void snapshot() throws PersistenceDirException {
        try {
            try {
                this.fPersistenceLog.snapshot();
            }
            catch (LogException logException) {
                if (!this.detectOldSnapshotDeletion(logException)) {
                    throw logException;
                }
            }
        }
        catch (IOException iOException) {
            throw new PersistenceDirException("Unable to write files to the directory: " + this.fPersistenceDirName, iOException, this.fPersistenceDirName);
        }
    }

    public void recover() throws PersistenceDirException {
        try {
            this.fPersistenceLog.recover();
        }
        catch (IOException iOException) {
            throw new PersistenceDirException("Unable to read files from the directory: " + this.fPersistenceDirName, iOException, this.fPersistenceDirName);
        }
    }

    public synchronized void destroy() {
        this.fPersistenceLog.deletePersistentStore();
        try {
            FileUtils.deleteDirectory((File)new File(this.fPersistenceDirName));
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to delete persistence directory: " + this.fPersistenceDirName, iOException);
        }
    }

    public synchronized void applyUpdate(Object object) throws Exception {
    }

    public synchronized void recover(InputStream inputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.fValuesInitialized = (Boolean)objectInputStream.readObject();
        this.fServiceName = (String)objectInputStream.readObject();
        this.fLookupLocators = (LookupLocator[])objectInputStream.readObject();
        this.fMinExportPort = (Integer)objectInputStream.readObject();
        this.fLogLevel = (Integer)objectInputStream.readObject();
        this.fLogDirName = (String)objectInputStream.readObject();
        this.fServiceLogFile = (String)objectInputStream.readObject();
        this.fSecurityLevel = (Integer)objectInputStream.readObject();
        this.fSecurityDir = (String)objectInputStream.readObject();
        this.fUsingSecureCommunication = (Boolean)objectInputStream.readObject();
        this.fTrustingClients = (Boolean)objectInputStream.readObject();
        this.fRequireWebLicensing = (Boolean)objectInputStream.readObject();
        this.fUsingActivatableExporter = (Boolean)objectInputStream.readObject();
        this.fDefaultRmiClientConnectTimeoutSecs = (Integer)objectInputStream.readObject();
        this.fMatlabRoot = (String)objectInputStream.readObject();
    }

    public synchronized void snapshot(OutputStream outputStream) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this.fValuesInitialized);
        objectOutputStream.writeObject(this.fServiceName);
        objectOutputStream.writeObject(this.fLookupLocators);
        objectOutputStream.writeObject(this.fMinExportPort);
        objectOutputStream.writeObject(this.fLogLevel);
        objectOutputStream.writeObject(this.fLogDirName);
        objectOutputStream.writeObject(this.fServiceLogFile);
        objectOutputStream.writeObject(this.fSecurityLevel);
        objectOutputStream.writeObject(this.fSecurityDir);
        objectOutputStream.writeObject(this.fUsingSecureCommunication);
        objectOutputStream.writeObject(this.fTrustingClients);
        objectOutputStream.writeObject(this.fRequireWebLicensing);
        objectOutputStream.writeObject(this.fUsingActivatableExporter);
        objectOutputStream.writeObject(this.fDefaultRmiClientConnectTimeoutSecs);
        objectOutputStream.writeObject(this.fMatlabRoot);
        objectOutputStream.flush();
    }

    protected void initServiceInfo(Configuration configuration, String string) throws ConfigurationException {
        this.fServiceName = (String)configuration.getEntry(string, "serviceName", String.class);
        this.fMinExportPort = (Integer)configuration.getEntry(string, "minServiceExportPort", Integer.TYPE);
        int n = (Integer)configuration.getEntry(string, "lookupPort", Integer.TYPE);
        this.setLookupLocators(configuration, string, n);
        this.fLogLevel = Integer.parseInt((String)configuration.getEntry(string, "logLevel", String.class));
        this.fLogDirName = (String)configuration.getEntry(string, "logDirectory", String.class);
        this.fServiceLogFile = (String)configuration.getEntry(string, "serviceLogFilePattern", String.class);
        try {
            this.fSecurityLevel = Integer.parseInt((String)configuration.getEntry(string, "securityLevel", String.class));
        }
        catch (NumberFormatException numberFormatException) {
            this.fSecurityLevel = 0;
        }
        this.fSecurityDir = (String)configuration.getEntry(string, "securityDir", String.class);
        this.fUsingSecureCommunication = (Boolean)configuration.getEntry(string, "useSecureCommunication", Boolean.TYPE);
        this.fTrustingClients = (Boolean)configuration.getEntry(string, "trustClients", Boolean.TYPE);
        this.fRequireWebLicensing = (Boolean)configuration.getEntry(string, "requireWebLicensing", Boolean.TYPE);
        this.fUsingActivatableExporter = (Boolean)configuration.getEntry(string, "useActivatableExporter", Boolean.TYPE);
        this.fDefaultRmiClientConnectTimeoutSecs = (Integer)configuration.getEntry(string, "defaultRmiClientConnectTimeoutSecs", Integer.TYPE);
        this.fMatlabRoot = (String)configuration.getEntry(string, "matlabRoot", String.class);
    }

    private void setLookupLocators(Configuration configuration, String string, int n) throws ConfigurationException {
        String[] stringArray = this.readLookupHosts(configuration, string);
        HashSet<LookupLocator> hashSet = new HashSet<LookupLocator>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) continue;
            String string2 = stringArray[i] + ":" + n;
            try {
                hashSet.add(new LookupLocator("jini://" + string2 + "/"));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new ConfigurationException("Provided job manager host names are malformed.");
            }
        }
        LookupLocator[] lookupLocatorArray = hashSet.toArray(new LookupLocator[hashSet.size()]);
        this.fLookupLocators = lookupLocatorArray;
    }

    private String[] readLookupHosts(Configuration configuration, String string) throws ConfigurationException {
        String string2 = (String)configuration.getEntry(string, "lookupHosts", String.class);
        string2 = string2.trim();
        String[] stringArray = new String[]{};
        if (!string2.equals("USE_MULTICAST")) {
            stringArray = string2.split(" ");
        }
        return stringArray;
    }

    private boolean detectOldSnapshotDeletion(LogException logException) {
        StackTraceElement[] stackTraceElementArray = logException.getStackTrace();
        if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
            StackTraceElement stackTraceElement = stackTraceElementArray[0];
            String string = stackTraceElement.getClassName();
            String string2 = stackTraceElement.getMethodName();
            if (string.equals("com.sun.jini.reliableLog.ReliableLog") && string2.equals("deleteFile")) {
                String string3 = null;
                new ErrorPrinterImpl().printError(logException.getMessage(), string3);
                return true;
            }
        }
        return false;
    }
}

