/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.util.PlatformInfo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Ping {
    private static final int GLOBAL_MAXIMUM_CONCURRENT_REQUESTS = 64;
    private static final int WINDOWS_MAXIMUM_CONCURRENT_REQUESTS = 32;
    private static final int WINDOWS_MAXIMUM_CONCURRENT_TCP_REQUESTS = 8;
    private static final int JAVA_PINGER_TIMEOUT_MILLIS = 5000;
    private static final int WINDOWS_PINGER_TIMEOUT_MILLIS = 2000;
    private static Pinger sPinger = Ping.getJavaPinger();

    public static int getNumberOfMaximumConcurrentRequests() {
        if (PlatformInfo.isWindows()) {
            try {
                Pinger pinger = Ping.getWindowsPinger();
                pinger.ping("127.0.0.1");
                sPinger = pinger;
                return 32;
            }
            catch (Exception exception) {
                return 8;
            }
        }
        return 64;
    }

    public static void checkIfHostIsResolvable(String string) throws UnknownHostException {
        InetAddress.getByName(string);
    }

    public static void checkIfHostIsPingable(String string) throws AddressUnreachableException, IOException {
        if (!sPinger.ping(string)) {
            throw new AddressUnreachableException("Cannot reach host " + string);
        }
    }

    private static Pinger getJavaPinger() {
        return new Pinger(){

            @Override
            public boolean ping(String string) throws IOException {
                InetAddress inetAddress = InetAddress.getByName(string);
                return inetAddress.isReachable(5000);
            }
        };
    }

    private static Pinger getWindowsPinger() {
        return new Pinger(){
            private static final int MAXIMUM_OUTPUT_SIZE = 8192;

            @Override
            public boolean ping(String string) throws IOException {
                ProcessBuilder processBuilder = new ProcessBuilder("ping", "-n", "1", "-w", "2000", string);
                processBuilder.redirectErrorStream(true);
                final Process process = processBuilder.start();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream(), 8192);
                Callable<Integer> callable = new Callable<Integer>(){

                    @Override
                    public Integer call() throws InterruptedException {
                        return process.waitFor();
                    }
                };
                Future<Integer> future = Executors.newSingleThreadExecutor().submit(callable);
                try {
                    int n = future.get(4000L, TimeUnit.MILLISECONDS);
                    boolean bl = n == 0;
                    return bl;
                }
                catch (Exception exception) {
                    throw (IOException)new IOException().initCause(exception);
                }
                finally {
                    bufferedInputStream.close();
                    process.destroy();
                }
            }
        };
    }

    static interface Pinger {
        public boolean ping(String var1) throws IOException;
    }

    public static class AddressUnreachableException
    extends Exception {
        AddressUnreachableException(String string) {
            super(string);
        }
    }
}

