/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.io.IOException;

public class ProcessBuilderUtils {
    private ProcessBuilderUtils() {
    }

    public static Delayer nullDelayer() {
        return new NullDelayer();
    }

    public static Process createProcessFromBuilderWithRetry(ProcessBuilder processBuilder, Delayer delayer, int n, int n2) throws IOException, InterruptedException {
        int n3 = n;
        while (true) {
            try {
                delayer.delay();
                return processBuilder.start();
            }
            catch (IOException iOException) {
                if (--n3 <= 0) {
                    throw iOException;
                }
                Thread.sleep(n2);
                continue;
            }
            break;
        }
    }

    private static class NullDelayer
    implements Delayer {
        private NullDelayer() {
        }

        @Override
        public void delay() throws InterruptedException {
        }
    }

    public static interface Delayer {
        public void delay() throws InterruptedException;
    }
}

