/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.util.JiniAccessor;
import java.net.MalformedURLException;
import java.util.Arrays;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupLocatorDiscovery;

public class UnicastAccessor
extends JiniAccessor {
    private static final long MAX_UNICAST_DISCOVERY_TIME_MILLIS = 5000L;
    private static DiscoveryManagement sUnicastDiscMgmt = UnicastAccessor.createDiscoverer();

    public UnicastAccessor(String string) throws DistcompException {
        LookupLocator[] lookupLocatorArray;
        try {
            string = this.addDefaultPortIfNeeded(string);
            lookupLocatorArray = new LookupLocator[]{new LookupLocator("jini://" + string + "/")};
        }
        catch (MalformedURLException malformedURLException) {
            throw new DistcompException(malformedURLException);
        }
        this.configureDiscoverer(lookupLocatorArray);
    }

    public UnicastAccessor(String[] stringArray) throws DistcompException {
        LookupLocator[] lookupLocatorArray = new LookupLocator[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray[i] = this.addDefaultPortIfNeeded(stringArray[i]);
                lookupLocatorArray[i] = new LookupLocator("jini://" + stringArray[i] + "/");
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new DistcompException(malformedURLException);
            }
        }
        this.configureDiscoverer(lookupLocatorArray);
    }

    public UnicastAccessor(LookupLocator[] lookupLocatorArray) {
        this.configureDiscoverer(lookupLocatorArray);
    }

    private void setDiscovererProperties(LookupLocator[] lookupLocatorArray) {
        LookupLocatorDiscovery lookupLocatorDiscovery = (LookupLocatorDiscovery)sUnicastDiscMgmt;
        lookupLocatorDiscovery.setLocators(lookupLocatorArray);
        this.waitForDiscovery(5000L);
    }

    private void configureDiscoverer(LookupLocator[] lookupLocatorArray) {
        this.setDiscovererProperties(lookupLocatorArray);
    }

    private String addDefaultPortIfNeeded(String string) {
        if (string.indexOf(58) == -1) {
            string = string + ":" + 27350;
        }
        return string;
    }

    @Override
    protected DiscoveryManagement getDiscoverer() {
        return sUnicastDiscMgmt;
    }

    private static DiscoveryManagement createDiscoverer() {
        return new LookupLocatorDiscovery(new LookupLocator[0]);
    }

    public String toString() {
        LookupLocatorDiscovery lookupLocatorDiscovery = (LookupLocatorDiscovery)sUnicastDiscMgmt;
        return "UnicastAccessor{" + Arrays.deepToString(lookupLocatorDiscovery.getLocators()) + "}";
    }
}

