/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.storage.DataNotFoundException;
import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.LargeStorageItem;
import java.io.InputStream;
import java.io.OutputStream;
import net.jini.id.Uuid;

public abstract class LargeDataAccessor {
    abstract void putDataInStorage(Uuid var1, InputStream var2, int var3, DataStorage var4) throws DataStorageException;

    public int readLargeData(LargeStorageItem largeStorageItem, OutputStream outputStream, DataStorage dataStorage, int n) throws DataStorageException {
        try {
            return dataStorage.readData(largeStorageItem.getDataID(), outputStream, n);
        }
        catch (DataNotFoundException dataNotFoundException) {
            return 0;
        }
    }

    public byte[] readLargeData(LargeStorageItem largeStorageItem, DataStorage dataStorage) throws DataStorageException {
        try {
            return dataStorage.readData(largeStorageItem.getDataID());
        }
        catch (DataNotFoundException dataNotFoundException) {
            return null;
        }
    }

    public LargeStorageItem writeLargeData(LargeStorageItem largeStorageItem, TransferableData transferableData, DataStorage dataStorage) throws MJSException {
        int n = largeStorageItem.getNumBytes();
        Uuid uuid = largeStorageItem.getDataID();
        if (transferableData == null || transferableData.getNumBytes() == 0) {
            if (n != 0) {
                dataStorage.removeData(uuid);
            }
            return new LargeStorageItem(uuid, 0);
        }
        int n2 = transferableData.getNumBytes();
        if (n != 0) {
            dataStorage.updateData(uuid, transferableData.getInputStream(), n2);
        } else {
            this.putDataInStorage(uuid, transferableData.getInputStream(), n2, dataStorage);
        }
        return new LargeStorageItem(uuid, n2);
    }

    public LargeStorageItem appendToLargeData(LargeStorageItem largeStorageItem, TransferableData transferableData, DataStorage dataStorage) throws DataStorageException {
        assert (largeStorageItem != null) : "A work unit's dataItem must never be null";
        int n = largeStorageItem.getNumBytes();
        Uuid uuid = largeStorageItem.getDataID();
        if (transferableData == null || transferableData.getNumBytes() == 0) {
            return largeStorageItem;
        }
        int n2 = transferableData.getNumBytes();
        if (n != 0) {
            dataStorage.appendToData(uuid, transferableData.getInputStream(), n2);
        } else {
            this.putDataInStorage(uuid, transferableData.getInputStream(), transferableData.getNumBytes(), dataStorage);
        }
        return new LargeStorageItem(uuid, n + n2);
    }
}

