/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.Connect;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.net.ServerSocket;
import java.net.Socket;

public class EchoTCP
extends Thread {
    public static EchoTCP echoTCPIP = null;
    public static final int HTTP_PORT = 8080;
    protected boolean serverRunning = true;
    protected int portNumber = 8080;
    protected ServerSocket listen = null;
    protected Socket client = null;
    protected Connect connect = null;

    public static EchoTCP getEchoServer() {
        return echoTCPIP;
    }

    public EchoTCP() throws TMException {
        this(8080);
    }

    public EchoTCP(int n) throws TMException {
        this.portNumber = n;
        try {
            this.listen = new ServerSocket(this.portNumber);
            echoTCPIP = this;
            this.start();
        }
        catch (Exception exception) {
            try {
                if (this.listen != null) {
                    this.listen.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new TMException("An error occurred while creating echo server on port: " + this.portNumber + ".");
        }
    }

    @Override
    public void run() {
        try {
            while (this.serverRunning) {
                this.client = this.listen.accept();
                if (this.connect != null && !this.connect.isOK()) {
                    this.connect.shutDownServer();
                }
                this.connect = new Connect(this.client);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutDownServer() throws TMException {
        this.serverRunning = false;
        echoTCPIP = null;
        if (this.connect != null) {
            this.connect.shutDownServer();
        }
        try {
            this.listen.close();
        }
        catch (Exception exception) {
            throw new TMException("Could not close Server Socket.");
        }
    }

    public int getPort() {
        return this.portNumber;
    }
}

