/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.ASCIITableConverter;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.InstrumentAsyncContinuous;
import com.mathworks.toolbox.instrument.NetworkDataLink;
import com.mathworks.toolbox.instrument.util.ErrorMessages;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class Network
extends InstrumentAsyncContinuous
implements NetworkDataLink {
    public static final String DEFAULT_REMOTE_HOST = "127.0.0.1";
    protected static final int SUCCESS = 0;
    protected static final int WRITE_EC = -1;
    protected static final int WRITE_CTRLC_EC = -2;
    protected static final int WRITE_TIMEOUT_EC = -3;
    protected static final int WRITE_CTRLC_TIMEOUT_EC = -4;
    protected static final int WRITE_CONNECT_EC = -5;
    protected static final int WRITE_DISCONNECT_EC = -6;
    protected static final int READ_TIMEOUT_EC = -7;
    protected static final int INVALID_ADDRESS_EC = -8;
    protected static final int WRITE_ASYNC_EC = -9;
    protected static final String WRITE_ERROR = "An error occurred during writing.";
    protected static final String WRITE_CTRLC = "Ctrl-C interrupted the write operation.";
    protected static final String WRITE_TIMEOUT = "A timeout occurred during the write operation.";
    protected static final String WRITE_CTRLC_TIMEOUT = "A timeout or Ctrl-C occurred during the write operation.";
    protected static final String WRITE_CONNECT = "Connection closed by RemoteHost. Use FOPEN to connect to RemoteHost.";
    protected static final String WRITE_DISCONNECT = "Connection closed by RemoteHost. Use FCLOSE;FOPEN to connect to RemoteHost.";
    protected static final String READ_TIMEOUT = "A timeout occurred before the read operation completed.";
    protected static final String INVALID_ADDRESS = "Invalid network address.";
    protected static final String WRITE_ASYNC = "An error occurred during the asynchronous write.";
    protected static final String[] ERROR_MSG = new String[]{"An error occurred during writing.", "Ctrl-C interrupted the write operation.", "A timeout occurred during the write operation.", "A timeout or Ctrl-C occurred during the write operation.", "Connection closed by RemoteHost. Use FOPEN to connect to RemoteHost.", "Connection closed by RemoteHost. Use FCLOSE;FOPEN to connect to RemoteHost.", "A timeout occurred before the read operation completed.", "Invalid network address.", "An error occurred during the asynchronous write."};
    protected static final String ctrlcMsgWrite = "Ctrl-C interrupted the write operation.";
    protected static final String timeoutMsgWrite = "A timeout occurred during the write operation.";
    protected static final String ERROR_LOCALPORT_RANGE = "LocalPort must be an integer ranging from 1 to 65535.";
    protected static final int JAR_FILE_VERSION = 0;
    protected static final String[] HWINFO_FIELDS = new String[]{"JarFileVersion"};
    protected static final int AUTO = 0;
    protected static final String[] LPORT_MODE = new String[]{"auto", "manual"};
    protected static final int MIN_LOCAL_PORT = 0;
    protected static final int MIN_REMOTE_PORT = 1;
    protected static final int MAX_PORT = 65535;
    protected String localHost = "";
    protected int localPort = 0;
    protected int localPortMode = 0;
    protected String remoteHost = "";
    protected int remotePort = 0;
    protected String[] info = new String[1];
    protected static final String[] AsyncVals = new String[]{"continuous", "manual"};
    protected static final String[] dModeVals = new String[]{"terminator", "byte"};
    protected static final String[] TranSVals = new String[]{"idle", "read", "write", "read&write"};
    protected static final Object[] PortVals = new Object[]{new Double(0.0), new Double(65535.0)};
    protected static final Object[] RPortVals = new Object[]{new Double(1.0), new Double(65535.0)};
    protected static final String[] PModeVals = new String[]{"auto", "manual"};
    protected static final Object[] TermVals = new Object[]{new Double(0.0), new Double(127.0)};
    protected static final Object[] AsciiVals = new Object[]{TermVals, "CR/LF", "LF/CR"};

    public Network() {
        try {
            Object[] objectArray = new Object[]{new Integer(45), "LF"};
            this.terminatorObject = (MLArrayRef)MatlabMCR.mtFeval((String)"system_dependent", (Object[])objectArray, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dispose() throws TMException {
        super.dispose();
        this.info = null;
    }

    public void setLocalHost(String string) throws TMException {
        if (this.status == 1) {
            Network.displayError("LocalHost cannot be set while OBJ is open.");
        }
        this.localHost = string;
        this.postPropertyChangedEvent("LocalHost", this.localHost);
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalPort(int n) throws TMException {
        if (this.status == 1) {
            Network.displayError("LocalPort cannot be set while OBJ is open.");
        }
        if (n == 0) {
            this.localPortMode = 0;
            this.localPort = 0;
        } else {
            if (!this.verifySetRange(n, 1, 65535)) {
                Network.displayError(ERROR_LOCALPORT_RANGE);
            }
            this.localPort = n;
            this.localPortMode = 1;
            this.postPropertyChangedEvent("LocalPort", new Integer(this.localPort));
            this.postPropertyChangedEvent("LocalPortMode", LPORT_MODE[this.localPortMode]);
        }
    }

    public int getLocalPort() {
        if (this.localPort == 0) {
            return 0;
        }
        return this.localPort;
    }

    public void setLocalPortMode(int n) throws TMException {
        if (this.status == 1) {
            Network.displayError("LocalPortMode cannot be set while OBJ is open.");
        }
        this.localPortMode = n;
        if (n == 0) {
            this.localPort = 0;
        }
        this.postPropertyChangedEvent("LocalPortMode", LPORT_MODE[this.localPortMode]);
    }

    public int getLocalPortMode() {
        return this.localPortMode;
    }

    public void setRemoteHost(String string) throws TMException {
        if (this.status == 1) {
            Network.displayError("RemoteHost cannot be set while OBJ is open.");
        }
        this.verifyIPAddress(string);
        this.remoteHost = string;
        this.updateNameProperty();
        this.postPropertyChangedEvent("RemoteHost", this.remoteHost);
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemotePort(int n) throws TMException {
        if (this.status == 1) {
            Network.displayError("RemotePort cannot be set while OBJ is open.");
        }
        if (!this.verifySetRange(n, 1, 65535)) {
            Network.displayError("RemotePort must range between 1 and 65535.");
        }
        this.remotePort = n;
        this.postPropertyChangedEvent("RemotePort", new Integer(this.remotePort));
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    protected void setHardwareTerminator(int n) throws TMException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableOSBuffer(int n) {
        int n2 = NetworkDataLink.OSBUFFERSIZE;
        boolean bl = false;
        int n3 = 0;
        assert (n == 1 || n == 0);
        while (!bl && n2 > 8192) {
            try {
                if (n == 1) {
                    this.setSendBufferSize(n2);
                    n3 = this.getSendBufferSize();
                } else if (n == 0) {
                    this.setReceiveBufferSize(n2);
                    n3 = this.getReceiveBufferSize();
                }
                bl = n3 > n2 >> 1;
            }
            catch (Exception exception) {}
            continue;
            finally {
                n2 >>= 1;
            }
        }
    }

    @Override
    protected int[] getTerminatorInteger(MLArrayRef mLArrayRef) throws TMException {
        return ASCIITableConverter.convertTerminatorObjectToInt(mLArrayRef, true);
    }

    @Override
    public void setHardwareTimeout(double d) {
        this.timeout = d;
    }

    @Override
    public double getHardwareTimeout() {
        return this.timeout;
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"Address:", this.remoteHost, "Port:", String.valueOf(this.remotePort)};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return this.remoteHost + ":" + this.remotePort;
    }

    protected int writeAsciiToNetwork(String string) throws Exception {
        int n = string.length();
        int n2 = this.getBlockSizeForWrite();
        long l = Network.currentNanoTicTime();
        int n3 = n2;
        this.localBytesToOutput = n;
        this.updateWriteTransferStatus(true);
        int n4 = 0;
        try {
            for (int i = 0; i < string.length(); i += n2) {
                if (this.checkForCtrlC()) {
                    return this.returnWriteErrorCode(-2);
                }
                if (Network.nanoTicTimeout(l, this.timeout)) {
                    return this.returnWriteErrorCode(-3);
                }
                n3 = i + n2;
                if (n3 > n) {
                    n3 = n;
                }
                this.writeData(string, i, n3);
                this.localBytesToOutput -= n3 - i;
                n4 += n3 - i;
            }
            this.localBytesToOutput = 0;
            this.bytesToOutput = 0;
            this.updateWriteTransferStatus(false);
            return string.length();
        }
        catch (Exception exception) {
            this.valuesSent += (long)n4;
            throw exception;
        }
    }

    protected int writeBinaryToNetwork(Object object, int n, int n2) throws Exception {
        long l = Network.currentNanoTicTime();
        int n3 = this.getBlockSizeForWrite();
        this.updateWriteTransferStatus(true);
        byte[] byArray = this.breakDownToBytes(object, n2);
        this.localBytesToOutput = byArray.length;
        for (int i = 0; i < byArray.length; i += n3) {
            if (this.checkForCtrlC() || Network.nanoTicTimeout(l, this.timeout)) {
                return this.returnWriteErrorCode(-4);
            }
            if (n3 > this.localBytesToOutput) {
                n3 = this.localBytesToOutput;
            }
            this.writeData(byArray, i, n3);
            this.localBytesToOutput -= n3;
        }
        this.localBytesToOutput = 0;
        this.bytesToOutput = 0;
        this.updateWriteTransferStatus(false);
        return byArray.length / DATASIZE[n2];
    }

    @Override
    public int getSuccessValue() {
        return 0;
    }

    @Override
    public String getErrorMessageFromHardware(int n) {
        return ERROR_MSG[-1 * n - 1];
    }

    @Override
    protected int getReadTimeoutErrorCode() {
        return -7;
    }

    protected int returnWriteErrorCode(int n) {
        this.bytesToOutput = 0;
        this.updateWriteTransferStatus(false);
        return n;
    }

    @Override
    protected Object convertBinaryData(byte[] byArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            return null;
        }
        switch (this.byteOrder) {
            case 0: {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
            case 1: {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
        }
        throw new TMException("Unsupported byte order specified.");
    }

    @Override
    protected byte[] breakDownToBytes(Object object, int n) throws Exception {
        switch (this.byteOrder) {
            case 0: {
                return BinarySwapBytes.breakdownToBytes(object, n);
            }
            case 1: {
                return BinarySwapBytes.breakdownToBytesAndSwap(object, n);
            }
        }
        throw new TMException("Unsupported byte order specified.");
    }

    public Object[] hardwareInfo() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            Network.displayError("Undefined function or variable 'instrhwinfo'.");
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = this.findValidAddresses();
        if (objectArray[0] == null) {
            objectArray[0] = "";
        }
        objectArray[1] = Network.jarVersion();
        return objectArray;
    }

    public String[] ObjectHardwareInfo() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            Network.displayError("Undefined function or variable 'instrhwinfo'.");
        }
        this.info[0] = Network.jarVersion();
        return this.info;
    }

    @Override
    protected Object[] getHwInfoStruct() {
        try {
            this.ObjectHardwareInfo();
        }
        catch (TMException tMException) {
            // empty catch block
        }
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    public void verifyIPAddress(String string) throws TMException {
        int[] nArray = new int[5];
        int n = 1;
        int n2 = string.indexOf(".", 0);
        nArray[0] = -1;
        nArray[4] = string.length();
        while (n < 4 && n2 != -1) {
            nArray[n++] = n2;
            n2 = string.indexOf(".", n2 + 1);
        }
        if (n != 4) {
            return;
        }
        if (string.indexOf(".", nArray[3] + 1) != -1) {
            return;
        }
        try {
            for (int i = 0; i < 4; ++i) {
                double d = TMStringUtil.str2double((String)string.substring(nArray[i] + 1, nArray[i + 1]));
                if (!(d < 0.0) && !(d > 255.0)) continue;
                Network.displayError(ErrorMessages.INVALID_IP_ADDRESS);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected String[] findValidAddresses() {
        String[] stringArray = null;
        try {
            String string = InetAddress.getLocalHost().getHostName();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            stringArray = new String[inetAddressArray.length];
            for (int i = 0; i < inetAddressArray.length; ++i) {
                stringArray[i] = inetAddressArray[i].toString();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return stringArray;
    }

    protected boolean checkForCtrlC() {
        if (ctrlc_flag) {
            ctrlc_flag = false;
            return true;
        }
        return false;
    }

    protected abstract void updateNameProperty();

    protected abstract void writeData(String var1, int var2, int var3) throws Exception;

    protected abstract void writeData(byte[] var1, int var2, int var3) throws Exception;
}

