/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.Vxi;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Vector;

public final class VxiVisa
extends Vxi
implements ActionListener {
    private static final int TTL0 = 0;
    private static final String[] TRIGGER_LINES = new String[]{"TTL0", "TTL1", "TTL2", "TTL3", "TTL4", "TTL5", "TTL6", "TTL7", "ECL0", "ECL1"};
    private static final int HARDWARE = 0;
    private static final int SOFTWARE = 10;
    private static final String[] TRIGGER_TYPES = new String[]{"hardware", "software"};
    private MLArrayRef interruptFcn = ACTION;
    private MLArrayRef triggerFcn = ACTION;
    protected int triggerLine = 0;
    protected int triggerType = 0;
    private VISA visa;
    private int defaultRM;
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Alias", "string", "none", "", "", "always", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "eosCharCode", "whileOpen", 0, 0), new ICProp("ChassisIndex", "double", "none", "", "", "whileopen", 1, 0), new ICProp("CompareBits", "double", "bounded", comVals, new Integer(8), "never", 1, 2), new ICProp("EOIMode", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("EOSCharCode", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("EOSMode", "string", "enum", EOSMVals, "none", "never", 1, 0), new ICProp("InterruptFcn", "callback", "callback", "", "", "never", 1, 0), new ICProp("LogicalAddress", "double", "none", "", new Integer(0), "whileOpen", 1, 0), new ICProp("MappedMemoryBase", "string", "none", "", "0H", "always", 1, 0), new ICProp("MappedMemorySize", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("MemoryBase", "string", "none", "", "0H", "always", 1, 0), new ICProp("MemoryIncrement", "string", "enum", MIncVals, "block", "never", 1, 0), new ICProp("MemorySize", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("MemorySpace", "string", "enum", MSpVals, "A16", "always", 1, 0), new ICProp("RsrcName", "string", "none", "", "", "always", 1, 0), new ICProp("Slot", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("TriggerFcn", "callback", "callback", "", "", "never", 1, 0), new ICProp("TriggerLine", "string", "enum", TRIGGER_LINES, "TTL0", "never", 1, 0), new ICProp("TriggerType", "string", "enum", TRIGGER_TYPES, "hardware", "never", 1, 0), new ICProp("Type", "string", "none", "", "visa-vxi", "always", 0, 0)};

    public VxiVisa() {
        this.deleteInstrumentObject(this);
    }

    public VxiVisa(String string, String string2, String string3, String string4) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            VxiVisa.displayError("Undefined function or variable 'visa'.");
        }
        try {
            this.rsrcName = this.visaName = string3;
            try {
                this.parseName(this.visaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alias = string4;
            this.useAlias = !this.alias.equals("");
            this.info[0] = string + FILESEP + string2;
            this.info[1] = VxiVisa.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.name = "VISA-VXI" + this.chassisIndex + "-" + this.logicalAddress;
            this.type = "visa-vxi";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
            this.displayName = "VISA-VXI";
            this.visaobj = this.visa;
            this.objectPolls = this.visa.VerifyAsyncVISARead();
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    public String getInspectorToolbarObjectName() {
        return "VISA-VXI";
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "CompareBits", this.compareBits);
        this.addPVPair(vector, "EOIMode", this.bool2OnOff(this.eoiMode));
        this.addPVPair(vector, "EOSMode", EOSMODES[this.eosMode]);
        this.addPVPair(vector, "MemoryIncrement", MEMINC[this.memoryIncrement]);
        this.addPVPair(vector, "TriggerLine", TRIGGER_LINES[this.triggerLine]);
        this.addPVPair(vector, "TriggerType", TRIGGER_TYPES[this.triggerType]);
        if (this.bytesAvailableFcnMode == 1) {
            vector.addElement((Comparable<?>)((Object)"BytesAvailableFcnMode"));
            vector.addElement((Comparable<?>)((Object)"byte"));
        }
        if (this.eosCharCode != 10) {
            vector.addElement((Comparable<?>)((Object)"EOSCharCode"));
            vector.addElement(new Integer(this.eosCharCode));
        }
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public void setInterruptFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("InterruptFcn", 3, mLArrayRef);
        if (this.interruptFcn != ACTION) {
            this.interruptFcn.dispose();
        }
        this.interruptFcn = mLArrayRef2;
        this.disabledCallbacks[3] = 0;
        this.postPropertyChangedEvent("InterruptFcn", this.interruptFcn);
    }

    public MLArrayRef getInterruptFcn() {
        return this.interruptFcn;
    }

    public void setTriggerFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("TriggerFcn", 7, mLArrayRef);
        if (this.triggerFcn != ACTION) {
            this.triggerFcn.dispose();
        }
        this.triggerFcn = mLArrayRef2;
        this.disabledCallbacks[7] = 0;
        if (this.status == 0) {
            this.postPropertyChangedEvent("TriggerFcn", this.triggerFcn);
            return;
        }
        if (this.triggerFcn == ACTION) {
            this.visa.EnableAction(this, this.handle, 204, 0);
        } else {
            this.visa.EnableAction(this, this.handle, 204, 1);
        }
        this.postPropertyChangedEvent("TriggerFcn", this.triggerFcn);
    }

    public MLArrayRef getTriggerFcn() {
        return this.triggerFcn;
    }

    public void setTriggerLine(int n) throws TMException {
        if (this.status == 0) {
            this.triggerLine = n;
            this.postPropertyChangedEvent("TriggerLine", TRIGGER_LINES[this.triggerLine]);
            return;
        }
        boolean bl = false;
        if (this.triggerFcn != ACTION) {
            bl = true;
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 0);
        }
        try {
            this.setHardwareTriggerLine(n);
            this.triggerLine = n;
            this.postPropertyChangedEvent("TriggerLine", TRIGGER_LINES[this.triggerLine]);
        }
        catch (Exception exception) {
            if (bl) {
                this.visa.EnableAction(this, this.handle, 204, 1);
            }
            VxiVisa.displayError(exception.getMessage());
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 1);
        }
    }

    public int getTriggerLine() {
        return this.triggerLine;
    }

    public void setTriggerType(int n) throws TMException {
        if (this.status == 0) {
            this.triggerType = n;
            this.postPropertyChangedEvent("TriggerType", TRIGGER_TYPES[this.triggerType]);
            return;
        }
        boolean bl = false;
        if (this.triggerFcn != ACTION) {
            bl = true;
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 0);
        }
        try {
            this.setHardwareTriggerType(n);
            this.triggerType = n;
            this.postPropertyChangedEvent("TriggerType", TRIGGER_TYPES[this.triggerType]);
        }
        catch (Exception exception) {
            if (bl) {
                this.visa.EnableAction(this, this.handle, 204, 1);
            }
            VxiVisa.displayError(exception.getMessage());
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 1);
        }
    }

    public int getTriggerType() {
        return this.triggerType;
    }

    protected void setHardwareTriggerLine(int n) throws TMException {
        int n2 = this.visa.Set(this.handle, 205, n);
        if (n2 < 0) {
            VxiVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n2));
        }
    }

    protected void setHardwareTriggerType(int n) throws TMException {
        int n2 = 0;
        switch (this.triggerType) {
            case 0: {
                n2 = this.visa.Set(this.handle, 205, this.triggerLine);
                break;
            }
            case 10: {
                n2 = this.visa.Set(this.handle, 205, this.triggerType);
            }
        }
        if (n2 < 0) {
            VxiVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n2));
        }
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("VISA-VXI" + this.chassisIndex + "-" + this.logicalAddress);
    }

    @Override
    protected final void updateNameProperties() {
        this.rsrcName = "VXI" + this.chassisIndex + "::" + this.logicalAddress + "::INSTR";
        if (this.nameStandardFormat) {
            this.setName("VISA-VXI" + this.chassisIndex + "-" + this.logicalAddress);
        }
    }

    private void parseName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return;
        }
        this.chassisIndex = n == 3 ? 0 : this.str2num(string.substring(3, n));
        if (this.chassisIndex < 0) {
            return;
        }
        String string2 = string.substring(n + 2, string.length());
        if ((n = string2.indexOf("::")) == -1) {
            return;
        }
        this.logicalAddress = this.str2num(string2.substring(0, n));
        if (this.logicalAddress < 0) {
            return;
        }
        if (!(string2 = string2.substring(n + 2, string2.length())).toUpperCase().equals("INSTR")) {
            return;
        }
        this.rsrcName = "VXI" + this.chassisIndex + "::" + this.logicalAddress + "::INSTR";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", VxiVisa.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "VxiVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    protected void openHardware() throws TMException {
        int[] nArray;
        if (this.isInUse()) {
            VxiVisa.displayError("The specified configuration: " + this.rsrcName + " is not available. " + LINESEP + "Use INSTRHWINFO for a list of available configurations." + " Use INSTRFIND to " + LINESEP + "determine if other instrument " + "objects are connected to the requested instrument.");
        }
        if ((nArray = this.visa.Create(this, this.rsrcName)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
            this.getPropertyValuesUponConnecting();
        } else {
            VxiVisa.displayError("Could not open VISA object. Use INSTRHWINFO for a list of available configurations.");
        }
        Object[] objectArray = this.visa.GetAliasInfo(this.visaName);
        if (objectArray != null) {
            this.parseName((String)objectArray[1]);
        }
    }

    @Override
    protected void updatePropsOnOpen() throws Exception {
        String[] stringArray = new String[7];
        int n = 0;
        this.eosCharByteArray[0] = (byte)this.eosCharCode;
        try {
            this.setHardwareEOIMode(this.eoiMode);
        }
        catch (Exception exception) {
            stringArray[n++] = "EOIMode";
        }
        try {
            this.setHardwareEOSMode(this.eosMode);
        }
        catch (Exception exception) {
            stringArray[n++] = "EOSMode";
        }
        try {
            this.setHardwareEOSChar(this.eosCharCode);
        }
        catch (Exception exception) {
            stringArray[n++] = "EOSCharCode";
        }
        try {
            this.setHardwareMemoryIncrement(this.memoryIncrement);
        }
        catch (Exception exception) {
            stringArray[n++] = "MemoryIncrement";
        }
        try {
            this.setHardwareTimeout(this.timeout);
            this.timeout = this.getHardwareTimeout();
        }
        catch (Exception exception) {
            stringArray[n++] = "Timeout";
        }
        try {
            this.setHardwareTriggerLine(this.triggerLine);
            if (this.triggerFcn != ACTION) {
                this.visa.EnableAction(this, this.handle, 204, 1);
            }
        }
        catch (Exception exception) {
            stringArray[n++] = "TriggerLine";
        }
        if (n == 0) {
            return;
        }
        TMStringUtil.warning((String)this.constrctUpdatePropsOnOpenWarning(stringArray));
    }

    @Override
    protected void closeHardware() throws Exception {
        int n;
        if (this.objectPolls) {
            Poller.removeInstrument(this);
        }
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if (this.mappedMemorySize != 0) {
            this.visa.UnMapAddress(this.handle);
            this.mappedMemorySize = 0;
            this.mappedMemoryBase = "0H";
        }
        if ((n = this.visa.Close(this.handle, this.defaultRM)) < 0) {
            VxiVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    private boolean isInUse() {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof VxiVisa)) continue;
            VxiVisa vxiVisa = (VxiVisa)e;
            if (!(vxiVisa.rsrcName.equals(this.rsrcName) & vxiVisa.status == 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.interruptFcn != ACTION) {
            this.interruptFcn.dispose();
        }
        if (this.triggerFcn != ACTION) {
            this.triggerFcn.dispose();
        }
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
    }

    @Override
    public void clrdevice() throws TMException {
        this.verifyObjectState();
        int n = this.visa.Clear(this.handle);
        if (n < 0) {
            VxiVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    public void interruptAction() {
        if (!this.interruptFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(3, "Interrupt", this.eventTime, new ICEvent("Interrupt", VxiVisa.constructClockVector(this.eventTime)));
        }
    }

    @Override
    public void triggerAction(int n) {
        if (!this.triggerFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(7, "Trigger", this.eventTime, new ICEvent("Trigger", n - 10, VxiVisa.constructClockVector(this.eventTime)));
        }
    }

    public void trigger() throws TMException {
        this.verifyObjectState();
        int n = this.visa.Trigger(this.handle);
        if (n < 0) {
            VxiVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    public char spoll(int n) throws TMException {
        return this.visa.spoll(this.handle, n, this.getHardwareTimeout());
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("ChassisIndex")) {
                iCPropArray[i].setDefaultValue(new Integer(this.chassisIndex));
                continue;
            }
            if (string.equals("LogicalAddress")) {
                iCPropArray[i].setDefaultValue(new Integer(this.logicalAddress));
                continue;
            }
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("VISA-VXI" + this.chassisIndex + "-" + this.logicalAddress);
                continue;
            }
            if (string.equals("RsrcName")) {
                iCPropArray[i].setDefaultValue(this.rsrcName);
                continue;
            }
            if (!string.equals("Alias")) continue;
            iCPropArray[i].setDefaultValue(this.alias);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public String display() {
        if (!this.isvalid()) {
            return Displays.invalidDisplay();
        }
        return LINESEP + "   VISA-VXI Object Using " + this.info[2] + " Adaptor : " + this.name + LINESEP + LINESEP + "   Communication Address " + LINESEP + "      ChassisIndex:       " + this.chassisIndex + LINESEP + "      LogicalAddress:     " + this.logicalAddress + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay() + "    VISA-VXI specific properties:" + LINESEP + "    ChassisIndex" + LINESEP + "    EOIMode: [ {on} | off ]" + LINESEP + "    EOSCharCode" + LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + LINESEP + "    InterruptFcn: string -or- function handle -or- cell array" + LINESEP + "    LogicalAddress" + LINESEP + "    MemoryIncrement [ {block} | FIFO ] " + LINESEP + "    TriggerFcn: string -or- function handle -or- cell array" + LINESEP + "    TriggerLine: [ {TTL0} | TTL1 | TTL2 | TTL3 | TTL4 | TTL5 | TTL6 | TTL7 | ECL0 | ECL1 ]" + LINESEP + "    TriggerType: [ {hardware} | software ] " + LINESEP + " " + LINESEP;
    }
}

