/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.toolbox.instrument.browser.ICTBrowserTreeDetail;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.TreeView;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

public class ICTTreeView
extends TreeView {
    private static final long serialVersionUID = 1L;
    private ICTBrowserTreeDetail treeDetailviewController = null;

    public ICTTreeView(ICTBrowserTreeDetail iCTBrowserTreeDetail, BrowserTreeNode browserTreeNode) {
        super(null, browserTreeNode);
        this.treeDetailviewController = iCTBrowserTreeDetail;
    }

    public void addNode(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, boolean bl, int n) {
        this.addChildNode(browserTreeNode, browserTreeNode2, n);
        if (bl) {
            this.setSelectionPath(new TreePath(browserTreeNode2.getPath()));
            this.updateDetailView(browserTreeNode2);
        }
    }

    public void selectNode(BrowserTreeNode browserTreeNode) {
        this.setSelectionPath(new TreePath(browserTreeNode.getPath()));
        this.updateDetailView(browserTreeNode);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath;
        this.valueChangedNode = null;
        if (this.popup.isVisible()) {
            this.setSelectionPath(this.previousRightClickPath);
            return;
        }
        if (treeSelectionEvent != null && (treePath = treeSelectionEvent.getNewLeadSelectionPath()) != null) {
            this.valueChangedNode = this.getNode(treePath);
        }
        if (this.valueChangedNode == null) {
            this.valueChangedNode = (BrowserTreeNode)this.getLastSelectedPathComponent();
        }
        if (this.valueChangedNode == null) {
            return;
        }
        this.setSelectionPath(new TreePath(this.valueChangedNode.getPath()));
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ICTTreeView.this.updateDetailView(ICTTreeView.this.valueChangedNode);
                    }
                });
            }
            catch (Throwable throwable) {}
        } else {
            this.updateDetailView(this.valueChangedNode);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        BrowserTreeNode browserTreeNode;
        int n;
        if (this.popup.isVisible()) {
            // empty if block
        }
        BrowserTreeNode browserTreeNode2 = this.treeDetailviewController.getSelectedNode();
        int n2 = this.getRowForPath(new TreePath(browserTreeNode2.getPath()));
        int n3 = keyEvent.getKeyCode();
        switch (n3) {
            case 109: {
                this.collapseAll(browserTreeNode2);
                return;
            }
            case 106: 
            case 107: {
                this.expandAll(browserTreeNode2);
                return;
            }
        }
        if ((keyEvent.getModifiersEx() & 0x80) == 128) {
            return;
        }
        int n4 = this.getRowCount();
        String string = KeyEvent.getKeyText(n3);
        for (n = n2 + 1; n < n4; ++n) {
            browserTreeNode = (BrowserTreeNode)this.getPathForRow(n).getLastPathComponent();
            if (!browserTreeNode.getName().startsWith(string)) continue;
            TreePath treePath = new TreePath(browserTreeNode.getPath());
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
            this.updateDetailView(browserTreeNode);
            return;
        }
        for (n = 0; n < n2; ++n) {
            browserTreeNode = (BrowserTreeNode)this.getPathForRow(n).getLastPathComponent();
            if (!browserTreeNode.getName().startsWith(string)) continue;
            TreePath treePath = new TreePath(browserTreeNode.getPath());
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
            this.updateDetailView(browserTreeNode);
            return;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        BrowserTreeNode browserTreeNode = (BrowserTreeNode)treePath.getLastPathComponent();
        InstrumentControlBrowser instrumentControlBrowser = (InstrumentControlBrowser)browserTreeNode.getClient();
        instrumentControlBrowser.setSelectedNode(browserTreeNode);
    }

    public BrowserTreeNode[] getAllNodesSelected() {
        TreePath[] treePathArray = this.getSelectionPaths();
        BrowserTreeNode[] browserTreeNodeArray = new BrowserTreeNode[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            browserTreeNodeArray[i] = (BrowserTreeNode)treePathArray[i].getLastPathComponent();
        }
        return browserTreeNodeArray;
    }

    public void updateDetailView(BrowserTreeNode browserTreeNode) {
        this.treeDetailviewController.update(browserTreeNode);
    }
}

