/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.deviceobj;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.deviceobj.InvokeMCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.PropertyQueriedCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.ResultsMCode;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IVICInstrumentMCode;
import com.mathworks.toolbox.instrument.guiutil.ICSaveDialog;
import com.mathworks.toolbox.testmeas.guiutil.EditTextFieldTableCellEditor;
import com.mathworks.toolbox.testmeas.guiutil.TMFileDialog;
import com.mathworks.toolbox.testmeas.guiutil.TMHelpViewer;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class DeviceObjectResultsExporter
extends JPanel
implements ActionListener,
Runnable,
MatlabListener {
    private static final long serialVersionUID = 1L;
    private static final Boolean TRUE = new Boolean(true);
    private static final String ACTION = "ACTION";
    private static final int EXPORT = 0;
    private static final int CLOSE = 1;
    private static final int HELP = 2;
    private static final String[] destinations = new String[]{"MATLAB Workspace", "MATLAB Figure Window", "MAT-File", "MATLAB Array Editor"};
    private static final int MATLAB_WORKSPACE = 0;
    private static final int FIGURE_WINDOW = 1;
    private static final int MAT_FILE = 2;
    private static final int ARRAY_EDITOR = 3;
    private Object[] matlabArgs;
    private String filename;
    private String directoryName = "";
    private Matlab matlab = new Matlab();
    private MJDialog dialog;
    private MJFrame exporterFrame;
    private JComboBox destinationComboBox;
    private ExportResultsTableModel model;
    private Object[][] data;
    private String[] columnNames = new String[]{" ", "Function Name", "Object Type", "Variable Name"};
    private ResultsMCode[] mcode = null;

    public DeviceObjectResultsExporter(ResultsMCode[] resultsMCodeArray) {
        this.mcode = resultsMCodeArray;
        this.defineTableData(resultsMCodeArray);
        this.layoutPanel();
        this.setName("Export Device Object Results Dialog");
        this.directoryName = Instrument.getPreferenceFile().read("SaveDirectory");
    }

    public DeviceObjectResultsExporter(IVICInstrumentMCode iVICInstrumentMCode) {
        this.defineTableData(iVICInstrumentMCode);
        this.layoutPanel();
        this.setName("Export Device Object Results Dialog");
        this.directoryName = Instrument.getPreferenceFile().read("SaveDirectory");
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(10, 4, 4, 4));
        this.add((Component)this.createDestinationPanel(), "North");
        this.add((Component)this.createTablePanel(), "Center");
        this.add((Component)this.createButtonPanel(), "South");
    }

    private JPanel createDestinationPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.destinationComboBox = new JComboBox<String>(destinations);
        this.destinationComboBox.setSelectedItem(destinations[0]);
        this.destinationComboBox.setName("Destination ComboBox");
        jPanel.add((Component)new JLabel("Data destination:"), "West");
        jPanel.add((Component)this.destinationComboBox, "Center");
        return jPanel;
    }

    private JPanel createTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel.add((Component)new JLabel("Select the data to export:"), "North");
        this.model = new ExportResultsTableModel();
        ExportResultsTable exportResultsTable = new ExportResultsTable(this.model);
        exportResultsTable.setName("Export Table");
        JScrollPane jScrollPane = new JScrollPane(exportResultsTable);
        jPanel.add((Component)jScrollPane, "Center");
        JTableHeader jTableHeader = exportResultsTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        exportResultsTable.setSelectionMode(0);
        exportResultsTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        exportResultsTable.getColumnModel().getColumn(1).setPreferredWidth(120);
        exportResultsTable.getColumnModel().getColumn(2).setPreferredWidth(120);
        exportResultsTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        JButton jButton = new JButton("Export");
        jButton.addActionListener(this);
        jButton.setMnemonic(69);
        jButton.putClientProperty(ACTION, new Integer(0));
        jButton.setName("Export Button");
        if (this.data == null || this.data.length == 0) {
            jButton.setEnabled(false);
        }
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(this);
        jButton2.setMnemonic(67);
        jButton2.putClientProperty(ACTION, new Integer(1));
        jButton2.setName("Close Button");
        JButton jButton3 = new JButton("Help");
        jButton3.setMnemonic(72);
        jButton3.addActionListener(this);
        jButton3.putClientProperty(ACTION, new Integer(2));
        jButton3.setName("Help Button");
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void defineTableData(ResultsMCode[] resultsMCodeArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < resultsMCodeArray.length; ++n) {
            n2 += resultsMCodeArray[n].getVariableNames().length;
        }
        this.data = new Object[n2][this.columnNames.length];
        n = 0;
        for (int i = 0; i < resultsMCodeArray.length; ++i) {
            String[] stringArray = resultsMCodeArray[i].getVariableNames();
            if (resultsMCodeArray[i] instanceof InvokeMCode) {
                String string = ((InvokeMCode)resultsMCodeArray[i]).getFunctionName();
                String string2 = ((InvokeMCode)resultsMCodeArray[i]).getObject();
                for (int j = 0; j < stringArray.length; ++j) {
                    this.data[n][0] = TRUE;
                    this.data[n][1] = string;
                    this.data[n][2] = string2;
                    this.data[n][3] = stringArray[j];
                    ++n;
                }
                continue;
            }
            this.data[n][0] = TRUE;
            this.data[n][1] = ((PropertyQueriedCode)resultsMCodeArray[i]).getPropertyName();
            this.data[n][2] = ((PropertyQueriedCode)resultsMCodeArray[i]).getGroupName();
            this.data[n][3] = stringArray[0];
            ++n;
        }
    }

    private void defineTableData(IVICInstrumentMCode iVICInstrumentMCode) {
        int n = iVICInstrumentMCode.getVariableNames().length;
        this.data = new Object[n][this.columnNames.length];
        String string = iVICInstrumentMCode.getFunctionName();
        String string2 = iVICInstrumentMCode.getObject();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = iVICInstrumentMCode.getVariableNames();
            this.data[n2][0] = TRUE;
            this.data[n2][1] = string;
            this.data[n2][2] = string2;
            this.data[n2][3] = stringArray[i];
            ++n2;
        }
        this.mcode = new ResultsMCode[1];
        this.mcode[0] = new InvokeMCode(iVICInstrumentMCode.getCode(), string, string2);
        this.mcode[0].setVariableNames(iVICInstrumentMCode.getVariableNames());
        this.mcode[0].setVariables(iVICInstrumentMCode.getVariables());
    }

    private Vector<Object> getDataToExport() {
        if (this.data == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.data.length; ++i) {
            if ((Boolean)this.data[i][0] != TRUE) continue;
            vector.addElement(this.data[i][3]);
            int n = this.getInvokeMCodeForRow(i);
            vector.addElement(new Integer(this.getVariableIndexForRow(i)));
            vector.addElement(this.mcode[n].getVariables());
        }
        return vector;
    }

    private int getInvokeMCodeForRow(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mcode.length; ++i) {
            String[] stringArray = this.mcode[i].getVariableNames();
            if (n2 + stringArray.length - 1 >= n) {
                return i;
            }
            n2 += stringArray.length;
        }
        return 0;
    }

    private int getVariableIndexForRow(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mcode.length; ++i) {
            String[] stringArray = this.mcode[i].getVariableNames();
            if (n2 + stringArray.length - 1 >= n) {
                return stringArray.length - (n2 + stringArray.length - n) + 1;
            }
            n2 += stringArray.length;
        }
        return 1;
    }

    public void showAsDialog(MJFrame mJFrame) {
        this.exporterFrame = mJFrame;
        this.dialog = new MJDialog((Frame)mJFrame, "Data Exporter", true);
        this.dialog.getContentPane().add(this);
        this.dialog.setSize(404, 451);
        Point point = mJFrame.getLocation();
        this.dialog.setLocation(point.x, point.y);
        this.dialog.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                if (!this.okToExport()) {
                    return;
                }
                int n2 = this.destinationComboBox.getSelectedIndex();
                if (n2 == 2) {
                    this.createSaveDialog();
                    if (this.filename == null) {
                        return;
                    }
                    if (!this.directoryName.equals("")) {
                        Instrument.getPreferenceFile().update("SaveDirectory", this.directoryName);
                    }
                }
                this.export(n2);
                break;
            }
            case 1: {
                this.dialog.dispose();
                break;
            }
            case 2: {
                TMHelpViewer tMHelpViewer = TMHelpViewer.getInstance();
                tMHelpViewer.update("instrument", "tmtool_csh\\data_exporter.html", "Data Exporter Help");
                tMHelpViewer.addToDialog();
            }
        }
    }

    private void export(int n) {
        switch (n) {
            case 0: {
                this.matlabArgs = new Object[3];
                this.matlabArgs[0] = "privateBrowserHelper";
                this.matlabArgs[1] = "workspace";
                this.matlabArgs[2] = this.getDataToExport();
                break;
            }
            case 2: {
                this.matlabArgs = new Object[4];
                this.matlabArgs[0] = "privateBrowserHelper";
                this.matlabArgs[1] = "mat-file";
                this.matlabArgs[2] = this.filename;
                this.matlabArgs[3] = this.getDataToExport();
                break;
            }
            case 1: {
                this.matlabArgs = new Object[3];
                this.matlabArgs[0] = "privateBrowserHelper";
                this.matlabArgs[1] = "figure";
                this.matlabArgs[2] = this.getDataToExport();
                break;
            }
            case 3: {
                this.matlabArgs = new Object[3];
                this.matlabArgs[0] = "privateBrowserHelper";
                this.matlabArgs[1] = "arrayeditor";
                this.matlabArgs[2] = this.getDataToExport();
            }
        }
        Matlab.whenMatlabReady((Runnable)this);
    }

    private boolean okToExport() {
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < this.data.length; ++i) {
            if (!((Boolean)this.data[i][0]).booleanValue()) continue;
            if (vector.contains(this.data[i][3]) && !vector2.contains(this.data[i][3])) {
                int n = TMStringUtil.confirm((MJFrame)this.exporterFrame, (String)"Duplicate variable names", (String)("There are duplicate occurrences of the variable: " + this.data[i][3] + ". Do you want to continue exporting?"));
                switch (n) {
                    case 0: {
                        vector2.addElement(this.data[i][3]);
                        break;
                    }
                    case 1: {
                        return false;
                    }
                }
                continue;
            }
            vector.addElement(this.data[i][3]);
        }
        vector = null;
        vector2 = null;
        return true;
    }

    @Override
    public void run() {
        try {
            this.matlab.feval("instrgate", this.matlabArgs, 0, (MatlabListener)this);
        }
        catch (Exception exception) {
            System.out.println("Exporter Exception: " + exception.getMessage());
        }
    }

    public void matlabEvent(MatlabEvent matlabEvent) {
        this.dialog.dispose();
    }

    private void createSaveDialog() {
        int n;
        TMFileDialog tMFileDialog = new TMFileDialog("Export to MAT-File", 0);
        if (!this.directoryName.equals("")) {
            tMFileDialog.setCurrentDirectory(new File(this.directoryName));
        }
        tMFileDialog.setSelectedFile(new File("untitled.mat"));
        tMFileDialog.showSaveDialog((Component)this.exporterFrame);
        if (tMFileDialog.getState() != 0) {
            this.filename = null;
            return;
        }
        File file = tMFileDialog.getSelectedFile();
        this.directoryName = tMFileDialog.getCurrentDirectory().getAbsolutePath();
        this.filename = file.getPath();
        if (this.filename.indexOf(".") == -1) {
            this.filename = this.filename + ".mat";
        }
        if ((file = new File(this.filename)).exists() && (n = TMStringUtil.confirm((MJFrame)this.exporterFrame, (String)"Save Confirmation", (String)("File " + file.getName() + " already exists. Overwrite it?"))) == 1) {
            this.filename = null;
            return;
        }
        n = ICSaveDialog.checkFilePermissions(this.filename, ".mat", "Export to MAT-File", "MATLAB MAT-Files (*.mat)", this.exporterFrame);
        if (n == 0) {
            this.filename = null;
        }
    }

    public class ExportResultsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return DeviceObjectResultsExporter.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (DeviceObjectResultsExporter.this.data == null) {
                return 0;
            }
            return DeviceObjectResultsExporter.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return DeviceObjectResultsExporter.this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return DeviceObjectResultsExporter.this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ((DeviceObjectResultsExporter)DeviceObjectResultsExporter.this).data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 3 || n2 == 0;
        }
    }

    public class ExportResultsTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public ExportResultsTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == DeviceObjectResultsExporter.this.columnNames.length - 1) {
                EditTextFieldTableCellEditor editTextFieldTableCellEditor = new EditTextFieldTableCellEditor((AbstractTableModel)DeviceObjectResultsExporter.this.model, new JTextField(), n, n2);
                editTextFieldTableCellEditor.checkForValidVariableName(DeviceObjectResultsExporter.this.exporterFrame);
                return editTextFieldTableCellEditor;
            }
            return super.getCellEditor(n, n2);
        }
    }
}

