/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.toolbox.instrument.AdaptorInfo;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.guiutil.MatrixTableModel;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;

public abstract class BoardPage
extends InstrumentControlBrowserPage
implements ActionListener {
    public static String NO_INSTRUMENT_STRING;
    public static int NO_INSTRUMENT_NODE_COUNT;
    protected static Hashtable<String, String> vendors;
    protected String[] headings;
    protected Object[][] data;
    protected InstrumentControlBrowser browser;
    protected String[] path = new String[]{"Instrument Control Toolbox", "Hardware", "", ""};
    protected DefaultSortableTable table;
    protected MatrixTableModel tableModel;
    protected JButton scanButton;
    protected JLabel lastScanDateLabel;
    protected String initialDate;
    protected Object[] matlabArgs;
    protected String type;
    protected String infoLabel = "Chassis";
    protected String statusMessage;
    protected Vector<BrowserTreeNode> currentNodes = new Vector();
    protected Vector<BrowserTreeNode> lastNodes = new Vector();
    protected boolean disableOnStart = false;
    protected boolean enableOnFinish = false;
    private ScanInstrumentRunnable scanInstrumentRunnable = null;

    protected abstract void constructDataArray(Object var1, String var2);

    protected abstract void load(String var1, String var2, String var3, Element var4);

    public BoardPage(InstrumentControlBrowser instrumentControlBrowser, String string, String string2, String string3, String string4) {
        this.browser = instrumentControlBrowser;
        this.path[2] = this.type = string4;
        this.path[3] = string;
        this.matlabArgs = new Object[4];
        this.matlabArgs[0] = "privateBrowserHelper";
        this.matlabArgs[1] = "identify" + this.type + "Instruments";
        this.matlabArgs[2] = string2;
        this.matlabArgs[3] = string3;
    }

    protected void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.layoutPanel();
        this.cleanup();
    }

    @Override
    public void setup() {
        this.scanButton.addActionListener(this);
    }

    @Override
    public void cleanup() {
        this.scanButton.removeActionListener(this);
    }

    @Override
    public void dispose() {
        this.cleanup();
        this.data = null;
        this.headings = null;
        this.path = null;
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        if (this.data == null) {
            return;
        }
        String string = this.lastScanDateLabel.getText();
        for (int i = 0; i < this.data.length; ++i) {
            String string2 = (String)this.data[i][1];
            if (string2.equals(NO_INSTRUMENT_STRING)) continue;
            Element element2 = browserConfigFileWriter.addNode(element, "Instrument");
            element2.setAttribute("Type", this.type);
            element2.setAttribute("LastScanDate", string);
            element2.setAttribute("Vendor", (String)this.matlabArgs[2]);
            element2.setAttribute("Index", (String)this.matlabArgs[3]);
            for (int j = 0; j < this.headings.length; ++j) {
                element2.setAttribute(TMStringUtil.strrep((String)this.headings[j], (String)" ", (String)""), (String)this.data[i][j]);
            }
        }
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add(jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(6, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 10, 0, 0));
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 0, 2));
        jPanel3.add(new JLabel("Vendor:"));
        jPanel3.add(new JLabel(this.infoLabel + " index:"));
        jPanel2.add((Component)jPanel3, "West");
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1, 0, 2));
        jPanel4.add((Component)jPanel5, "West");
        String string = ((String)this.matlabArgs[2]).toLowerCase();
        String string2 = vendors.get(string) + " (" + string + ")";
        JLabel jLabel = new JLabel(string2);
        jLabel.setName("Vendor Label");
        jPanel5.add(jLabel);
        JLabel jLabel2 = new JLabel((String)this.matlabArgs[3]);
        jLabel2.setName("Index Label");
        jPanel5.add(jLabel2);
        jPanel2.add((Component)jPanel4, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        this.add(jPanel6, "Center");
        this.tableModel = new MatrixTableModel();
        this.tableModel.setColumnNames(this.headings);
        this.table = new DefaultSortableTable((TableModel)this.tableModel);
        this.table.setName("Board Table");
        if (this.table.getColumnCount() > 0) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(70);
        }
        if (this.table.getColumnCount() > 1) {
            this.table.getColumnModel().getColumn(1).setPreferredWidth(70);
        }
        if (this.type.equals("GPIB") && this.table.getColumnCount() > 2) {
            this.table.getColumnModel().getColumn(2).setPreferredWidth(110);
        }
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        jPanel6.add((Component)jScrollPane, "Center");
        jScrollPane.setPreferredSize(new Dimension(200, 50));
        JPanel jPanel7 = new JPanel(new BorderLayout(0, 0));
        this.initialDate = TMStringUtil.getDate();
        this.lastScanDateLabel = new JLabel("Last scan date: " + this.initialDate);
        jPanel7.add((Component)this.lastScanDateLabel, "West");
        jPanel7.add((Component)this.createButtonPanel(), "Center");
        jPanel6.add((Component)jPanel7, "South");
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
        this.scanButton = new JButton("Scan");
        this.scanButton.addActionListener(this);
        this.scanButton.setName("Board Scan Button");
        jPanel2.add(this.scanButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.disableOnStart = true;
        this.enableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    public void scanForAll() {
        this.disableOnStart = true;
        this.enableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    @Override
    public void scanForAll(boolean bl, boolean bl2) {
        this.disableOnStart = bl;
        this.enableOnFinish = bl2;
        this.getGUIReadyForMATLABCall();
    }

    public void getGUIReadyForMATLABCall() {
        if (this.disableOnStart) {
            this.browser.postBlockEventsEvent(true);
        }
        this.browser.postStatusBarUpdateEvent(this.statusMessage);
        Instrument.enableInstrumentObjectEvents(false);
        if (this.scanInstrumentRunnable == null) {
            this.scanInstrumentRunnable = new ScanInstrumentRunnable();
        }
        Matlab.whenMatlabReady((Runnable)this.scanInstrumentRunnable);
    }

    private void updateTableData(Object object) {
        this.data = null;
        String string = TMStringUtil.getDate();
        this.lastScanDateLabel.setText("Last scan date: " + string);
        this.constructDataArray(object, string);
        if (this.tableModel != null) {
            this.tableModel.setData(this.data);
        }
    }

    protected void cleanupNodes() {
        for (int i = 0; i < this.lastNodes.size(); ++i) {
            if (this.currentNodes.contains(this.lastNodes.elementAt(i))) continue;
            BrowserTreeNode browserTreeNode = this.lastNodes.elementAt(i);
            this.browser.removeNode(browserTreeNode.getName(), this.path, browserTreeNode.getUserData());
            if (browserTreeNode.getUserData() instanceof Integer) continue;
            this.browser.removeBrowserObjectFromCommunicationInfoStore((CommunicationInfo)browserTreeNode.getUserData());
        }
        this.lastNodes = this.currentNodes;
        this.currentNodes = null;
        this.currentNodes = new Vector();
    }

    protected String defineNodeIDString(String string) {
        String string2 = string;
        string2 = string2.equals("No instrument was identified") ? "" : " (" + string2 + ")";
        return string2;
    }

    static {
        int n;
        NO_INSTRUMENT_STRING = "No instruments were found";
        NO_INSTRUMENT_NODE_COUNT = 0;
        vendors = new Hashtable();
        for (n = 0; n < AdaptorInfo.GPIB_VENDORS.length; ++n) {
            vendors.put(AdaptorInfo.GPIB_VENDORS[n], AdaptorInfo.GPIB_NAMES[n]);
        }
        for (n = 0; n < AdaptorInfo.VISA_VENDORS.length; ++n) {
            vendors.put(AdaptorInfo.VISA_VENDORS[n], AdaptorInfo.VISA_NAMES[n]);
        }
    }

    public class ScanInstrumentRunnable
    implements Runnable,
    MatlabListener {
        private Matlab matlab = new Matlab();

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", BoardPage.this.matlabArgs, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            Instrument.enableInstrumentObjectEvents(true);
            if (matlabEvent.getStatus() == 0) {
                Object object = matlabEvent.getResult();
                BoardPage.this.updateTableData(object);
            }
            BoardPage.this.browser.postStatusBarUpdateEvent("");
            if (BoardPage.this.enableOnFinish) {
                BoardPage.this.browser.postBlockEventsEvent(false);
            }
            BoardPage.this.browser.postRefreshFinishedEvent();
        }
    }
}

