/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp;

import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.BasicParser;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.DefaultVendorParser;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.FunctionPanelParser;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.VendorParser;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.DefaultAttributeParser;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.SubFileParser;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DefaultDriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class VXIPnPLoader {
    private final List<String> iviCClassDriverNames = Arrays.asList("ividcpwr.fp", "ividmm.fp", "ivifgen.fp", "ivipwrmeter.fp", "Ivirfsiggen.fp", "iviscope.fp", "Ivispecan.fp", "iviswtch.fp");
    String fFunctionPanel = "";
    FunctionPanelParser fParser = null;
    DriverModel fModel = null;

    public static int getMinPropertiesPerGroup() {
        String string = Instrument.getPreferenceFile().read("DeviceObjectMinProperties");
        if (string == null) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int getMinFunctionsPerGroup() {
        String string = Instrument.getPreferenceFile().read("DeviceObjectMinFunctions");
        if (string == null) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static DriverModel toDriverModel(String string, boolean bl) throws TMException {
        VXIPnPLoader vXIPnPLoader = new VXIPnPLoader(string, bl);
        vXIPnPLoader.applyVendorParser();
        vXIPnPLoader.applyAttributeParser();
        return vXIPnPLoader.getModel();
    }

    public static DriverModel toBasicMatlabDriverModel(String string) throws TMException {
        VXIPnPLoader vXIPnPLoader = new VXIPnPLoader(string, false);
        BasicParser basicParser = new BasicParser();
        vXIPnPLoader.applyVendorParser(basicParser);
        return vXIPnPLoader.getModel();
    }

    private VXIPnPLoader(String string, boolean bl) throws TMException {
        this.fFunctionPanel = string;
        try {
            this.fParser = new FunctionPanelParser(this.fFunctionPanel);
            this.fParser.parse();
            this.fModel = new DefaultDriverModel();
            this.fModel.setDriverName(this.fParser.getPrefix());
            this.fModel.setDriverType(1);
            this.fModel.setInstrumentVersion("1.0");
            this.fModel.setInstrumentType("VXIPnPInstrument");
            this.fModel.setInstrumentManufacturer(this.fParser.getVendorName());
            this.fModel.setInstrumentModel(this.fParser.getDriverName());
            this.fModel.setErrorCommand("");
            this.fModel.setIdentifyCommand("");
            this.fModel.setResetCommand("");
            this.fModel.setSelfTestCommand("");
            this.fModel.setConnectInitType(1);
            this.fModel.setDisconnectType(1);
        }
        catch (Exception exception) {
            throw new TMException("The driver function panel could not be read.");
        }
        if (this.fModel.getDriverName().length() == 0) {
            this.fModel.setDriverName(new File(this.fFunctionPanel).getName());
        }
        if (bl) {
            this.fModel.setDriverType(2);
            this.fModel.setInstrumentType("IVIInstrument");
        }
        if (this.isIviCClassDriver(this.fFunctionPanel)) {
            this.fModel.setDriverType(7);
            this.fModel.setInstrumentType("IVIInstrument");
        }
    }

    private boolean isIviCClassDriver(String string) {
        int n = string.lastIndexOf("\\");
        String string2 = string.substring(n + 1);
        return this.iviCClassDriverNames.contains(string2);
    }

    private void applyVendorParser() throws TMException {
        VendorParser vendorParser;
        try {
            vendorParser = this.loadVendorParser(this.fParser.getVendorAbbreviation());
        }
        catch (TMException tMException) {
            vendorParser = new DefaultVendorParser();
        }
        this.applyVendorParser(vendorParser);
    }

    private void applyVendorParser(VendorParser vendorParser) throws TMException {
        try {
            vendorParser.parseFunctionPanels(this.fModel, this.fParser.getFunctionPanels());
        }
        catch (Exception exception) {
            throw new TMException(exception.getMessage());
        }
    }

    private void applyAttributeParser() throws TMException {
        try {
            String string = new File(this.fFunctionPanel).getParent() + File.separator + this.fModel.getDriverName() + ".sub";
            if (new File(string).exists()) {
                SubFileParser subFileParser = new SubFileParser(string);
                subFileParser.parse();
                DefaultAttributeParser defaultAttributeParser = new DefaultAttributeParser();
                defaultAttributeParser.parseAttributes(subFileParser, this.fModel);
            }
        }
        catch (Exception exception) {
            throw new TMException(exception.getMessage());
        }
    }

    private VendorParser loadVendorParser(String string) throws TMException {
        VendorParser vendorParser = null;
        try {
            vendorParser = (VendorParser)Class.forName("com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp." + string.toUpperCase() + "Parser").newInstance();
        }
        catch (Exception exception) {
            throw new TMException(exception.getMessage());
        }
        return vendorParser;
    }

    private DriverModel getModel() {
        return this.fModel;
    }
}

