/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml.property;

import com.mathworks.beans.EnumPair;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class StringEnumProperty
extends PropertyConstraint {
    private Vector<String> values = new Vector();
    private Vector<String> commands = new Vector();
    private Hashtable<String, String> valueLookupTable = new Hashtable();
    private Hashtable<String, String> reverseValueLookupTable = new Hashtable();
    private JComboBox valueComboBox = null;

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getConstraint() {
        return 1;
    }

    @Override
    public Object getDefaultValue() {
        if (this.values == null || this.values.size() == 0) {
            return "";
        }
        return this.values.elementAt(0);
    }

    @Override
    public void addEnumPair(String string, String string2) {
        this.values.addElement(string);
        this.commands.addElement(string2);
        this.valueLookupTable.put(string, string2);
        this.reverseValueLookupTable.put(string2, string);
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof String) {
            return this.isValidValue((String)object);
        }
        return false;
    }

    public boolean isValidValue(String string) {
        boolean bl = this.values.contains(string);
        if (bl) {
            return true;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.values.elementAt(i).toLowerCase().startsWith(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String getEnumFromInstrumentValue(String string) {
        String string2 = this.getEnum(string);
        if (string2 == null) {
            string2 = this.values.elementAt(0);
        }
        return string2;
    }

    @Override
    public String getEnum(String string) {
        int n;
        String string2 = this.reverseValueLookupTable.get(string = TMStringUtil.removeTrailingCRLF((String)string));
        if (string2 != null) {
            return string2;
        }
        string = string.toLowerCase();
        for (n = 0; n < this.commands.size(); ++n) {
            if (!string.equals(this.commands.elementAt(n).toLowerCase())) continue;
            return this.values.elementAt(n);
        }
        for (n = 0; n < this.values.size(); ++n) {
            if (!string.equals(this.values.elementAt(n).toLowerCase())) continue;
            return this.values.elementAt(n);
        }
        return null;
    }

    @Override
    public Object getValidValue(Object object) {
        return this.valueLookupTable.get(object);
    }

    @Override
    public EnumPair[] getEnumPair() {
        EnumPair[] enumPairArray = new EnumPair[this.values.size()];
        for (int i = 0; i < enumPairArray.length; ++i) {
            enumPairArray[i] = new EnumPair(this.values.elementAt(i), (Object)this.values.elementAt(i));
        }
        return enumPairArray;
    }

    @Override
    public Object[] getConstraintValues() {
        Object[] objectArray = new String[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            objectArray[i] = this.values.elementAt(i);
        }
        return objectArray;
    }

    @Override
    public String getSetList() {
        if (this.values.size() == 0) {
            return "";
        }
        String string = "[ ";
        for (int i = 0; i < this.values.size(); ++i) {
            string = string + this.values.elementAt(i) + " | ";
        }
        return string.substring(0, string.length() - 2) + "]";
    }

    @Override
    public String getSetError() {
        if (this.values.size() == 0) {
            return "";
        }
        String string = "";
        for (int i = 0; i < this.values.size(); ++i) {
            string = string + this.values.elementAt(i) + ", ";
        }
        return string.substring(0, string.length() - 2);
    }

    @Override
    public JPanel getPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.valueComboBox = new JComboBox();
        for (int i = 0; i < this.values.size(); ++i) {
            this.valueComboBox.addItem(this.values.elementAt(i));
        }
        jPanel.add(this.valueComboBox);
        Dimension dimension = this.valueComboBox.getPreferredSize();
        if (dimension.width < 93) {
            dimension.width = 93;
        }
        this.valueComboBox.setPreferredSize(dimension);
        return jPanel;
    }

    @Override
    public Object getPanelValue() {
        return this.valueComboBox.getSelectedItem();
    }

    @Override
    public void setPanelValue(Object object) {
        this.valueComboBox.setSelectedItem(object);
    }

    @Override
    public String getCellArrayOfValues() {
        String string = "";
        Object[] objectArray = this.getConstraintValues();
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + "'" + objectArray[i] + "', ";
        }
        string = string.substring(0, string.length() - 2);
        string = "{" + string + "}";
        return string;
    }
}

