/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest;

import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestTool;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private DataFlavor nodeFlavor = null;
    private String nodeType = "application/x-java-jvm-local-objectref;class=javax.swing.tree.DefaultMutableTreeNode";
    private MIDTestTool testTool = null;

    public TreeTransferHandler(MIDTestTool mIDTestTool) {
        this.testTool = mIDTestTool;
        try {
            this.nodeFlavor = new DataFlavor(this.nodeType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("MyTreeTransferHandler3: unable to create data flavor.");
        }
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        if (!(jComponent instanceof JTree)) {
            return null;
        }
        TreePath treePath = ((JTree)jComponent).getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return new TreeNodeTransferable(defaultMutableTreeNode);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (this.containsNodeFlavor(dataFlavorArray)) {
            return true;
        }
        return this.containsStringFlavor(dataFlavorArray);
    }

    private boolean containsNodeFlavor(DataFlavor[] dataFlavorArray) {
        if (this.nodeFlavor == null) {
            return false;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(this.nodeFlavor)) continue;
            return true;
        }
        return false;
    }

    private boolean containsStringFlavor(DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        if (this.containsNodeFlavor(transferable.getTransferDataFlavors())) {
            return this.moveNode(jComponent, transferable);
        }
        if (this.containsStringFlavor(transferable.getTransferDataFlavors())) {
            return this.addNode(jComponent);
        }
        return false;
    }

    private boolean moveNode(JComponent jComponent, Transferable transferable) {
        try {
            JTree jTree = (JTree)jComponent;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)transferable.getTransferData(this.nodeFlavor);
            int n = jTree.getRowForPath(new TreePath(defaultMutableTreeNode2.getPath()));
            int n2 = defaultTreeModel.getChildCount(defaultMutableTreeNode);
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode3 != null) {
                n2 = jTree.getRowForPath(new TreePath(defaultMutableTreeNode3.getPath()));
            }
            if (n == n2) {
                return true;
            }
            if (n < n2) {
                --n2;
            }
            this.testTool.moveStep((BrowserTreeNode)defaultMutableTreeNode2, n2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean addNode(JComponent jComponent) {
        try {
            JTree jTree = (JTree)jComponent;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
            int n = defaultTreeModel.getChildCount(defaultMutableTreeNode);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode2 != null) {
                n = jTree.getRowForPath(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            this.testTool.addStep(n);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    public class TreeNodeTransferable
    implements Transferable {
        private DefaultMutableTreeNode node;

        public TreeNodeTransferable(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.node = defaultMutableTreeNode;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.node;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{TreeTransferHandler.this.nodeFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return TreeTransferHandler.this.nodeFlavor.equals(dataFlavor);
        }
    }
}

