/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class MIDTextField
extends MJTextField
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    public static final int INTEGER = 0;
    public static final int DOUBLE = 1;
    public static final int STRING = 2;
    private static final String[] MODESTR = new String[]{"an integer", "a double", "a string"};
    private int mode = 2;
    private String lastValidValue = "";
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private String errorMessage = "";
    private String propertyName = "";
    private boolean okToBeEmpty = true;

    public MIDTextField() {
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public MIDTextField(String string) {
        this(string, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, "");
    }

    public MIDTextField(String string, double d) {
        this(string, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.toString(d));
    }

    public MIDTextField(String string, double d, double d2) {
        this(string, d, d2, "");
    }

    public MIDTextField(String string, double d, double d2, String string2) {
        this.propertyName = string;
        this.minValue = d;
        this.maxValue = d2;
        this.lastValidValue = string2;
        this.setText(this.lastValidValue);
        this.setMode(0);
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public void setText(String string) {
        this.lastValidValue = string;
        super.setText(string);
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setMax(double d) {
        this.maxValue = d;
    }

    public double getMax() {
        return this.maxValue;
    }

    public void setMin(double d) {
        this.minValue = d;
    }

    public double getMin() {
        return this.minValue;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setOKToBeEmpty(boolean bl) {
        this.okToBeEmpty = bl;
    }

    public boolean isOKToBeEmpty() {
        return this.okToBeEmpty;
    }

    public String getLastValidValue() {
        return this.lastValidValue;
    }

    public void error() {
        switch (this.mode) {
            case 0: 
            case 1: {
                if (!this.errorMessage.equals("")) break;
                this.errorMessage = "The " + this.propertyName + " must be " + MODESTR[this.mode] + " ranging from " + this.formatValue(this.minValue) + " to " + this.formatValue(this.maxValue) + ".";
                break;
            }
            case 2: {
                if (!this.errorMessage.equals("") || this.getText().length() != 0) break;
                this.errorMessage = "The " + this.propertyName + " cannot be empty.";
            }
        }
        TMStringUtil.error((String)"Invalid Value", (String)this.errorMessage);
    }

    private String formatValue(double d) {
        switch (this.mode) {
            case 0: {
                return "" + (int)d;
            }
            case 1: {
                return "" + d;
            }
        }
        return "";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.verifyValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.verifyValue();
    }

    private void verifyValue() {
        if (this.getText().equals("")) {
            if (this.okToBeEmpty) {
                this.lastValidValue = "";
                return;
            }
            this.error();
            super.setText(this.lastValidValue);
            return;
        }
        switch (this.mode) {
            case 0: {
                this.verifyIntegerValue();
                break;
            }
            case 1: {
                this.verifyDoubleValue();
            }
        }
    }

    private void verifyIntegerValue() {
        String string = this.getText();
        if (TMStringUtil.isinteger((String)string)) {
            int n;
            try {
                n = TMStringUtil.str2int((String)string);
            }
            catch (NumberFormatException numberFormatException) {
                this.setText(this.lastValidValue);
                this.error();
                return;
            }
            if (!((double)n >= this.minValue) || !((double)n <= this.maxValue)) {
                this.setText(this.lastValidValue);
                this.error();
                return;
            }
        } else {
            this.setText(this.lastValidValue);
            this.error();
            return;
        }
        this.lastValidValue = string;
    }

    public boolean verifyDoubleValue() {
        String string = this.getText();
        if (this.isdouble(string)) {
            double d = this.str2double(string);
            if (!(d >= this.minValue) || !(d <= this.maxValue)) {
                this.setText(this.lastValidValue);
                this.error();
                return false;
            }
        } else {
            this.setText(this.lastValidValue);
            this.error();
            return false;
        }
        this.lastValidValue = string;
        return true;
    }

    private boolean isdouble(String string) {
        try {
            this.str2double(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private double str2double(String string) {
        return Double.valueOf(string);
    }
}

