/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.guiutil;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.device.drivers.DriverUtil;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.guiutil.CreationDialogRunnable;
import com.mathworks.toolbox.instrument.guiutil.ObjectCreationDialog;
import com.mathworks.toolbox.testmeas.guiutil.RangeTextField;
import com.mathworks.toolbox.testmeas.guiutil.TMFileDialog;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class NewObjectDialog
extends ObjectCreationDialog
implements ItemListener,
MouseListener,
ActionListener,
InstrumentObjectListener {
    private static final long serialVersionUID = 1L;
    private final CreateObjectWorker createObjectWorker = new CreateObjectWorker();
    public static final String ACTION = "ACTION";
    private static final int BROWSE = 1000;
    private static final int CREATE = 1001;
    private static final int DRIVER_NAME = 1002;
    public static final int INSTRUMENT = 0;
    public static final int INTERFACE = 1;
    public static final int DEVICE = 2;
    private static final int GPIB = 0;
    private static final int VISA = 1;
    private static final int TCPIP = 2;
    private static final int UDP = 3;
    private static final int SERIAL = 4;
    private static final int BLUETOOTH = 5;
    private static final int DEVICE_OBJ = 6;
    private static final int LINUX_TCPIP = 0;
    private static final int LINUX_UDP = 1;
    private static final int LINUX_SERIAL = 2;
    private static final int LINUX_DEVICE_OBJ = 3;
    private static final String[] INSTRUMENT_OBJECT_TYPES = new String[]{"GPIB", "VISA", "TCPIP", "UDP", "serial port", "Bluetooth", "device"};
    private static final String[] INTERFACE_OBJECT_TYPES = new String[]{"GPIB", "VISA", "TCPIP", "UDP", "serial port", "Bluetooth"};
    private static final String[] INSTRUMENT_LINUX_OBJECT_TYPES = new String[]{"TCPIP", "UDP", "serial port", "device"};
    private static final String[] INTERFACE_LINUX_OBJECT_TYPES = new String[]{"TCPIP", "UDP", "serial port"};
    private static final String[] DEVICE_OBJECT_TYPES = new String[]{"device"};
    private int fInstrumentObjType = 1;
    private static boolean isInitialzed = false;
    private static String[] sInstalledGPIBVendors;
    private static Hashtable<String, String[]> sVendorsAndBids;
    private static Hashtable<Object, Object> sBidsAndPads;
    private static Hashtable<String, Object> sAllMatlabDrivers;
    private static Hashtable<String, String> sMatlabDriversOnPath;
    private static Hashtable<String, Object> sBrowsedDrivers;
    private static int sFirstAdaptorWithBid;
    private static final String sGpibNotInstalled;
    private String fLasttBoardIndex = "0";
    private String fLasttPrimaryAddress = "1";
    private static String[] sInstalledVisaVendors;
    private static String[] sVisaRsrcNames;
    private static final String sVisaNotInstalled;
    private static String[] sSerialPorts;
    private static String[] sBluetoothDevices;
    private static final String sBluetoothAdaptorOrDevicesNotDetected;
    private int fTopPad = 0;
    private MJLabel fTempLabel;
    private MJPanel fGpibPanel;
    private MJComboBox fGpibVendor;
    private MJComboBox fGpibBoardIndex;
    private MJComboBox fGpibPrimaryAddress;
    private MJPanel fSerialPanel;
    private MJComboBox fAvailableSerialPorts;
    private MJPanel fBluetoothPanel;
    private MJComboBox fAvailableBluetoothDevices;
    private MJPanel fVisaPanel;
    private MJComboBox fVisaVendor;
    private MJComboBox fVisaRsrcName;
    private MJPanel fTcpipPanel;
    private MJTextField fTcpipRemoteHost;
    private RangeTextField fTcpipRemotePort;
    private MJPanel fUdpPanel;
    private MJTextField fUdpRemoteHost;
    private RangeTextField fUdpRemotePort;
    private MJPanel fDevicePanel;
    private MJComboBox fDriverComboBox;
    private MJLabel fInterfaceLabel;
    private MJComboBox fInterfaceBox;
    private MJTextField fInterfaceField;
    private MJButton fBrowseButton;
    private MJButton fCreateButton;
    private MJPanel fInterfacePanelHolder;
    private int fDriverType = 0;
    String fInterfaceText = sResources.getString("NewObject.Device.Interface");
    String fResourceNameText = sResources.getString("NewObject.Device.ResourceName");
    private Hashtable<Instrument, String> fInstrumentObjects = new Hashtable();
    private Object[] fMatlabArgs;

    public NewObjectDialog(int n) {
        this.fInstrumentObjType = n;
        switch (this.fInstrumentObjType) {
            case 2: {
                this.fTempLabel = new MJLabel(sResources.getString("NewObject.ObjectTypeLabel.Device"));
                break;
            }
            case 1: {
                this.fTempLabel = new MJLabel(sResources.getString("NewObject.ObjectTypeLabel.Interface"));
                break;
            }
            default: {
                this.fTempLabel = new MJLabel(sResources.getString("NewObject.ObjectTypeLabel.Instrument"));
            }
        }
        this.fTopPad = this.fTempLabel.getPreferredSize().width + 8;
        if (this.fInstrumentObjType != 1) {
            Instrument.addInstrumentObjectListener(this);
        }
    }

    @Override
    protected void makeVisible() {
        this.setMode(0);
        if (!isInitialzed) {
            isInitialzed = true;
            CreationDialogRunnable creationDialogRunnable = new CreationDialogRunnable(this);
            Matlab.whenMatlabReady((Runnable)creationDialogRunnable);
        } else {
            this.updateDeviceComponents();
            this.setMode(1);
        }
        super.makeVisible();
    }

    public void updateForData() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int n = NewObjectDialog.this.getObjTypeIndex();
                        if (n == 0 && NewObjectDialog.this.fGpibVendor != null) {
                            NewObjectDialog.this.updateGPIBComponents();
                        }
                    }
                });
            }
            catch (Throwable throwable) {}
        } else {
            int n = this.getObjTypeIndex();
            if (n == 0 && this.fGpibVendor != null) {
                this.updateGPIBComponents();
            }
        }
    }

    public static void initHardwareForLayout(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[] objectArray4, Object[] objectArray5, Object[] objectArray6) {
        sSerialPorts = (String[])objectArray;
        sBluetoothDevices = (String[])objectArray5;
        sFirstAdaptorWithBid = -1;
        if (objectArray2 != null) {
            int n = 0;
            sInstalledGPIBVendors = new String[objectArray2.length / 3];
            for (int i = 0; i < objectArray2.length; i += 3) {
                NewObjectDialog.sInstalledGPIBVendors[n] = (String)objectArray2[i];
                String[] stringArray = (String[])objectArray2[i + 1];
                Object[] objectArray7 = (Object[])objectArray2[i + 2];
                if (stringArray != null) {
                    if (stringArray.length > 0 && sFirstAdaptorWithBid < 0) {
                        sFirstAdaptorWithBid = n;
                    }
                    sVendorsAndBids.put(sInstalledGPIBVendors[n], stringArray);
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (objectArray7[j] == null) continue;
                        sBidsAndPads.put(sInstalledGPIBVendors[n] + stringArray[j], NewObjectDialog.convertToStringArray((Object[])objectArray7[j]));
                    }
                }
                ++n;
            }
        }
        if (objectArray3 != null) {
            sInstalledVisaVendors = NewObjectDialog.convertToStringArray(objectArray3);
        }
        if (objectArray4 != null) {
            sVisaRsrcNames = NewObjectDialog.convertToStringArray(objectArray4);
        }
        NewObjectDialog.updateDriversForLayout(objectArray6);
    }

    public static void updateDriversForLayout(Object[][] objectArray) {
        sMatlabDriversOnPath.clear();
        sAllMatlabDrivers.clear();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = DriverUtil.parseDriverName(objectArray[i][0].toString());
                sMatlabDriversOnPath.put(string, objectArray[i][2].toString() + Instrument.FILESEP + string);
                sAllMatlabDrivers.put(string, objectArray[i][2].toString() + Instrument.FILESEP + string);
            }
        }
        NewObjectDialog.addBrowsedDrivers();
    }

    public static void updateDriversForLayout(Object[] objectArray) {
        sMatlabDriversOnPath.clear();
        sAllMatlabDrivers.clear();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                String string2 = DriverUtil.parseDriverName(string);
                sMatlabDriversOnPath.put(string2, string);
                sAllMatlabDrivers.put(string2, string);
            }
        }
        NewObjectDialog.addBrowsedDrivers();
    }

    private static void addBrowsedDrivers() {
        Enumeration<String> enumeration = sBrowsedDrivers.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (sMatlabDriversOnPath.contains(sBrowsedDrivers.get(string))) continue;
            if (sMatlabDriversOnPath.keySet().contains(string)) {
                int n = 1;
                while (sMatlabDriversOnPath.keySet().contains(string + " (" + n + ")")) {
                    ++n;
                }
                Object object = sBrowsedDrivers.get(string);
                sBrowsedDrivers.remove(string);
                sBrowsedDrivers.put(string + " (" + n + ")", object);
                sAllMatlabDrivers.put(string + " (" + n + ")", object);
                continue;
            }
            sAllMatlabDrivers.put(string, sBrowsedDrivers.get(string));
        }
    }

    public void setInstrumentObjType(int n) {
        int n2 = this.fInstrumentObjType;
        this.fInstrumentObjType = n;
        if (this.fInstrumentObjType != 1) {
            Instrument.addInstrumentObjectListener(this);
        }
        if (n2 != this.fInstrumentObjType) {
            this.update();
        }
    }

    @Override
    public String getObjectTypeLabel() {
        switch (this.fInstrumentObjType) {
            case 2: {
                return sResources.getString("NewObject.ObjectTypeLabel.Device");
            }
            case 1: {
                return sResources.getString("NewObject.ObjectTypeLabel.Interface");
            }
        }
        return sResources.getString("NewObject.ObjectTypeLabel.Instrument");
    }

    @Override
    public String[] getObjectTypes() {
        switch (this.fInstrumentObjType) {
            case 0: {
                if (PlatformInfo.isLinux()) {
                    return INSTRUMENT_LINUX_OBJECT_TYPES;
                }
                return INSTRUMENT_OBJECT_TYPES;
            }
            case 1: {
                if (PlatformInfo.isLinux()) {
                    return INTERFACE_LINUX_OBJECT_TYPES;
                }
                return INTERFACE_OBJECT_TYPES;
            }
            case 2: {
                return DEVICE_OBJECT_TYPES;
            }
        }
        return DEVICE_OBJECT_TYPES;
    }

    @Override
    public MJPanel getPanel(int n) {
        if (this.fInstrumentObjType == 2) {
            return this.createDevicePanel();
        }
        if (PlatformInfo.isLinux()) {
            switch (n) {
                case 0: {
                    return this.createTCPIPPanel();
                }
                case 1: {
                    return this.createUDPPanel();
                }
                case 2: {
                    return this.createSerialPortPanel();
                }
                case 3: {
                    return this.createDevicePanel();
                }
            }
        }
        switch (n) {
            case 0: {
                return this.createGPIBPanel();
            }
            case 1: {
                return this.createVISAPanel();
            }
            case 2: {
                return this.createTCPIPPanel();
            }
            case 3: {
                return this.createUDPPanel();
            }
            case 4: {
                return this.createSerialPortPanel();
            }
            case 5: {
                return this.createBluetoothPanel();
            }
            case 6: {
                return this.createDevicePanel();
            }
        }
        return null;
    }

    private MJPanel createGPIBPanel() {
        if (this.fGpibPanel != null) {
            return this.fGpibPanel;
        }
        String string = sResources.getString("NewObject.Gpib.VendorLabel");
        String string2 = sResources.getString("NewObject.Gpib.BoardIdxLabel");
        String string3 = sResources.getString("NewObject.Gpib.PrimaryAddrLabel");
        String[] stringArray = new String[]{string, string2, string3};
        this.fTempLabel.setText(string);
        int n = this.fTempLabel.getPreferredSize().width;
        this.fTempLabel.setText(string2);
        int n2 = this.fTempLabel.getPreferredSize().width;
        if (n2 > n) {
            n = n2;
        }
        this.fTempLabel.setText(string3);
        n2 = this.fTempLabel.getPreferredSize().width;
        if (n2 > n) {
            n = n2;
        }
        String[] stringArray2 = new String[]{"GPIB Vendor Combobox", "GPIB BoardIndex Combobox", "GPIB PrimaryAddress Combobox"};
        JComponent[] jComponentArray = new JComponent[3];
        this.fGpibVendor = new MJComboBox();
        this.fGpibBoardIndex = new MJComboBox();
        this.fGpibPrimaryAddress = new MJComboBox();
        this.fGpibBoardIndex.setEditable(true);
        this.fGpibPrimaryAddress.setEditable(true);
        jComponentArray[0] = this.fGpibVendor;
        jComponentArray[1] = this.fGpibBoardIndex;
        jComponentArray[2] = this.fGpibPrimaryAddress;
        this.fGpibVendor.addItemListener((ItemListener)this);
        this.fGpibBoardIndex.addItemListener((ItemListener)this);
        this.fGpibPrimaryAddress.addItemListener((ItemListener)this);
        this.updateGPIBComponents();
        this.fGpibPanel = this.createPanel(stringArray, jComponentArray, stringArray2, this.fTopPad - n);
        return this.fGpibPanel;
    }

    private MJPanel createVISAPanel() {
        if (this.fVisaPanel != null) {
            return this.fVisaPanel;
        }
        String string = sResources.getString("NewObject.Visa.VendorLabel");
        String string2 = sResources.getString("NewObject.Visa.ResourceNameLabel");
        String[] stringArray = new String[]{string, string2};
        this.fTempLabel.setText(string);
        int n = this.fTempLabel.getPreferredSize().width;
        this.fTempLabel.setText(string2);
        int n2 = this.fTempLabel.getPreferredSize().width;
        if (n2 > n) {
            n = n2;
        }
        String[] stringArray2 = new String[]{"VISA Vendor Combobox", "VISA RsrcName Combobox"};
        JComponent[] jComponentArray = new JComponent[2];
        this.fVisaVendor = new MJComboBox();
        this.fVisaRsrcName = sVisaRsrcNames != null && sVisaRsrcNames.length > 0 ? new MJComboBox((Object[])sVisaRsrcNames) : new MJComboBox();
        jComponentArray[0] = this.fVisaVendor;
        jComponentArray[1] = this.fVisaRsrcName;
        this.fVisaRsrcName.setEditable(true);
        if (sInstalledVisaVendors != null && sInstalledVisaVendors.length > 0) {
            for (int i = 0; i < sInstalledVisaVendors.length; ++i) {
                this.fVisaVendor.addItem((Object)sInstalledVisaVendors[i]);
            }
            this.fVisaVendor.setSelectedItem((Object)sInstalledVisaVendors[0]);
        } else {
            this.fVisaVendor.addItem((Object)sVisaNotInstalled);
            this.fVisaVendor.setSelectedIndex(0);
            this.fVisaVendor.setEnabled(false);
            this.fVisaRsrcName.setEditable(false);
            this.fVisaRsrcName.setEnabled(false);
        }
        this.fVisaPanel = this.createPanel(stringArray, jComponentArray, stringArray2, this.fTopPad - n);
        return this.fVisaPanel;
    }

    private MJPanel createSerialPortPanel() {
        if (this.fSerialPanel != null) {
            return this.fSerialPanel;
        }
        String string = sResources.getString("NewObject.Serial.PortLabel");
        String[] stringArray = new String[]{string};
        this.fTempLabel.setText(string);
        int n = this.fTempLabel.getPreferredSize().width;
        String[] stringArray2 = new String[]{"Serial Ports Combobox"};
        JComponent[] jComponentArray = new JComponent[1];
        this.fAvailableSerialPorts = new MJComboBox((Object[])sSerialPorts);
        this.fAvailableSerialPorts.setEditable(false);
        jComponentArray[0] = this.fAvailableSerialPorts;
        this.fSerialPanel = this.createPanel(stringArray, jComponentArray, stringArray2, this.fTopPad - n);
        return this.fSerialPanel;
    }

    private MJPanel createBluetoothPanel() {
        if (this.fBluetoothPanel != null) {
            return this.fBluetoothPanel;
        }
        String string = sResources.getString("NewObject.Bluetooth.Label");
        String[] stringArray = new String[]{string};
        this.fTempLabel.setText(string);
        int n = this.fTempLabel.getPreferredSize().width;
        String[] stringArray2 = new String[]{"Bluetooth Combobox"};
        JComponent[] jComponentArray = new JComponent[1];
        this.fAvailableBluetoothDevices = new MJComboBox((Object[])sBluetoothDevices);
        this.fAvailableBluetoothDevices.setEditable(false);
        if (sBluetoothDevices == null || sBluetoothDevices.length == 0) {
            this.fAvailableBluetoothDevices.addItem((Object)sBluetoothAdaptorOrDevicesNotDetected);
            this.fAvailableBluetoothDevices.setEnabled(false);
        }
        jComponentArray[0] = this.fAvailableBluetoothDevices;
        this.fBluetoothPanel = this.createPanel(stringArray, jComponentArray, stringArray2, this.fTopPad - n);
        return this.fBluetoothPanel;
    }

    private MJPanel createTCPIPPanel() {
        if (this.fTcpipPanel != null) {
            return this.fTcpipPanel;
        }
        String string = sResources.getString("NewObject.Network.RemoteHostLabel");
        String string2 = sResources.getString("NewObject.Network.RemotePortLabel");
        String[] stringArray = new String[]{string, string2};
        this.fTempLabel.setText(string);
        int n = this.fTempLabel.getPreferredSize().width;
        this.fTempLabel.setText(string2);
        int n2 = this.fTempLabel.getPreferredSize().width;
        if (n2 > n) {
            n = n2;
        }
        String[] stringArray2 = new String[]{"TCPIP RemoteHost Textfield", "TCPIP RemotePort Textfield"};
        JComponent[] jComponentArray = new JComponent[2];
        this.fTcpipRemoteHost = new MJTextField("127.0.0.1");
        this.fTcpipRemotePort = new RangeTextField(string2, 1.0, 65535.0, "80");
        this.fTcpipRemotePort.setOKToBeEmpty(true);
        jComponentArray[0] = this.fTcpipRemoteHost;
        jComponentArray[1] = this.fTcpipRemotePort;
        this.fTcpipPanel = this.createPanel(stringArray, jComponentArray, stringArray2, this.fTopPad - n);
        return this.fTcpipPanel;
    }

    private MJPanel createUDPPanel() {
        if (this.fUdpPanel != null) {
            return this.fUdpPanel;
        }
        String string = sResources.getString("NewObject.Network.RemoteHostLabel");
        String string2 = sResources.getString("NewObject.Network.RemotePortLabel");
        String[] stringArray = new String[]{string, string2};
        this.fTempLabel.setText(string);
        int n = this.fTempLabel.getPreferredSize().width;
        this.fTempLabel.setText(string2);
        int n2 = this.fTempLabel.getPreferredSize().width;
        if (n2 > n) {
            n = n2;
        }
        String[] stringArray2 = new String[]{"UDP RemoteHost Textfield", "UDP RemotePort Textfield"};
        JComponent[] jComponentArray = new JComponent[2];
        this.fUdpRemoteHost = new MJTextField("127.0.0.1");
        this.fUdpRemoteHost.selectAll();
        this.fUdpRemotePort = new RangeTextField(string2, 1.0, 65535.0, "9090");
        this.fUdpRemotePort.setOKToBeEmpty(true);
        jComponentArray[0] = this.fUdpRemoteHost;
        jComponentArray[1] = this.fUdpRemotePort;
        this.fUdpPanel = this.createPanel(stringArray, jComponentArray, stringArray2, this.fTopPad - n);
        return this.fUdpPanel;
    }

    private MJPanel createDevicePanel() {
        if (this.fDevicePanel != null) {
            this.updateInterfaceComboBox();
            return this.fDevicePanel;
        }
        String string = sResources.getString("NewObject.Device.Driver");
        String[] stringArray = new String[]{string, this.fInterfaceText};
        this.fTempLabel.setText(string);
        int n = this.fTempLabel.getPreferredSize().width;
        this.fTempLabel.setText(this.fInterfaceText);
        int n2 = this.fTempLabel.getPreferredSize().width;
        if (n2 > n) {
            n = n2;
        }
        this.fDriverComboBox = new MJComboBox();
        this.fInterfaceBox = new MJComboBox();
        this.fInterfaceField = new MJTextField(20);
        this.fDriverComboBox.setName("Driver Text Field");
        this.fInterfaceBox.setName("Interface Combobox");
        this.fInterfaceField.setName("Interface Text Field");
        this.fBrowseButton = new MJButton(sResources.getString("NewObject.Button.Browse"));
        this.fCreateButton = new MJButton(sResources.getString("NewObject.Button.Create"));
        Dimension dimension = new Dimension(100, 21);
        this.fBrowseButton.setPreferredSize(dimension);
        this.fCreateButton.setPreferredSize(dimension);
        this.fBrowseButton.setName("Browse Button");
        this.fCreateButton.setName("Create Button");
        Enumeration<String> enumeration = sAllMatlabDrivers.keys();
        while (enumeration.hasMoreElements()) {
            this.fDriverComboBox.addItem((Object)enumeration.nextElement());
        }
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(2, 0));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(2, 1, 0, 4));
        mJPanel2.add((Component)this.fBrowseButton);
        mJPanel2.add((Component)this.fCreateButton);
        mJPanel.add((Component)mJPanel2, (Object)"East");
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(2, 1, 0, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel4.add((Component)this.fDriverComboBox, (Object)gridBagConstraints);
        mJPanel3.add((Component)mJPanel4);
        this.fInterfacePanelHolder = new MJPanel((LayoutManager)new GridBagLayout());
        this.fInterfacePanelHolder.add((Component)this.fInterfaceBox, (Object)gridBagConstraints);
        mJPanel3.add((Component)this.fInterfacePanelHolder);
        mJPanel.add((Component)mJPanel3, (Object)"Center");
        this.fInterfaceBox.setEnabled(false);
        this.fCreateButton.setEnabled(false);
        this.fBrowseButton.putClientProperty((Object)ACTION, (Object)new Integer(1000));
        this.fBrowseButton.addActionListener((ActionListener)this);
        this.fCreateButton.putClientProperty((Object)ACTION, (Object)new Integer(1001));
        this.fCreateButton.addActionListener((ActionListener)this);
        this.fDriverComboBox.putClientProperty((Object)ACTION, (Object)new Integer(1002));
        this.fDriverComboBox.addActionListener((ActionListener)this);
        this.fDriverComboBox.addMouseListener((MouseListener)this);
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new BorderLayout(this.fTopPad - n, 0));
        mJPanel5.setBorder((Border)BorderFactory.createTitledBorder(sResources.getString("ObjectCreate.ConfigureCreation.Border")));
        MJPanel mJPanel6 = new MJPanel((LayoutManager)new GridLayout(stringArray.length, 1, 0, 2));
        mJPanel6.add((Component)new MJLabel(stringArray[0]));
        this.fInterfaceLabel = new MJLabel(this.fInterfaceText);
        mJPanel6.add((Component)this.fInterfaceLabel);
        mJPanel5.add((Component)mJPanel6, (Object)"West");
        mJPanel5.add((Component)mJPanel, (Object)"Center");
        this.fDevicePanel = mJPanel5;
        this.updateGUIWithDriverInfo();
        return this.fDevicePanel;
    }

    protected void updateGPIBComponents() {
        boolean bl;
        this.fGpibVendor.removeItemListener((ItemListener)this);
        this.fGpibBoardIndex.removeItemListener((ItemListener)this);
        this.fGpibPrimaryAddress.removeItemListener((ItemListener)this);
        this.fGpibVendor.removeAllItems();
        if (sInstalledGPIBVendors != null && sInstalledGPIBVendors.length > 0 && sInstalledGPIBVendors[0] != null) {
            int n;
            for (n = 0; n < sInstalledGPIBVendors.length; ++n) {
                this.fGpibVendor.addItem((Object)sInstalledGPIBVendors[n]);
            }
            n = 0;
            if (sFirstAdaptorWithBid >= 0) {
                n = sFirstAdaptorWithBid;
            }
            this.fGpibVendor.setSelectedIndex(n);
            this.updateComboBoxValues(this.fGpibBoardIndex, sVendorsAndBids.get(sInstalledGPIBVendors[n]));
            this.fLasttBoardIndex = (String)this.fGpibBoardIndex.getSelectedItem();
            this.updateComboBoxValues(this.fGpibPrimaryAddress, (String[])sBidsAndPads.get(sInstalledGPIBVendors[n] + this.fGpibBoardIndex.getSelectedItem()));
            this.fLasttPrimaryAddress = (String)this.fGpibPrimaryAddress.getSelectedItem();
            if (this.fLasttBoardIndex == null) {
                this.fGpibBoardIndex.addItem((Object)"0");
                this.fLasttBoardIndex = "0";
            }
            if (this.fLasttPrimaryAddress == null) {
                this.fGpibPrimaryAddress.addItem((Object)"1");
                this.fLasttPrimaryAddress = "1";
            }
            bl = true;
        } else {
            this.fGpibVendor.addItem((Object)sGpibNotInstalled);
            this.fGpibVendor.setSelectedIndex(0);
            bl = false;
        }
        this.fGpibVendor.setEnabled(bl);
        this.fGpibBoardIndex.setEnabled(bl);
        this.fGpibBoardIndex.setEditable(bl);
        this.fGpibPrimaryAddress.setEnabled(bl);
        this.fGpibPrimaryAddress.setEditable(bl);
        this.fGpibVendor.addItemListener((ItemListener)this);
        this.fGpibBoardIndex.addItemListener((ItemListener)this);
        this.fGpibPrimaryAddress.addItemListener((ItemListener)this);
    }

    public void updateDeviceComponents() {
        if (this.fDriverComboBox == null) {
            return;
        }
        this.fDriverComboBox.removeAllItems();
        Enumeration<String> enumeration = sAllMatlabDrivers.keys();
        while (enumeration.hasMoreElements()) {
            this.fDriverComboBox.addItem((Object)enumeration.nextElement());
        }
    }

    @Override
    protected void updateObjectCreationPanel() {
        MJPanel mJPanel = this.getPanel(this.getObjTypeIndex());
        if (mJPanel == null) {
            this.getDialog().setSize(this.getDialogDefaultSize());
            return;
        }
        if (mJPanel == this.fTcpipPanel) {
            this.fTcpipRemoteHost.requestFocus();
            this.fTcpipRemoteHost.selectAll();
        } else if (mJPanel == this.fUdpPanel) {
            this.fUdpRemoteHost.requestFocus();
            this.fUdpRemoteHost.selectAll();
        } else if (mJPanel == this.fBluetoothPanel) {
            this.fAvailableBluetoothDevices.requestFocus();
        }
        super.updateObjectCreationPanel();
        this.getDialog().pack();
        this.getDialog().repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 1000: {
                int n2 = this.createLoadDialog();
                if (n2 != 0) break;
                this.updateGUIWithDriverInfo();
                break;
            }
            case 1001: {
                new NewObjectDialog(1).showAsDialog((MJDialog)SwingUtilities.windowForComponent((Component)this.fCreateButton), 20, 20);
            }
            case 1002: {
                this.updateGUIWithDriverInfo();
                break;
            }
            case 1: {
                if (this.fInstrumentObjType != 1) {
                    Instrument.removeInstrumentObjectListener(this);
                }
                super.actionPerformed(actionEvent);
                break;
            }
            case 0: {
                if (this.fInstrumentObjType != 1) {
                    Instrument.removeInstrumentObjectListener(this);
                }
                super.actionPerformed(actionEvent);
                break;
            }
            default: {
                super.actionPerformed(actionEvent);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JComponent jComponent = (JComponent)itemEvent.getSource();
        if (jComponent.equals(this.fGpibVendor)) {
            this.updateComboBoxValues(this.fGpibBoardIndex, sVendorsAndBids.get(this.fGpibVendor.getSelectedItem()));
            if (this.fGpibBoardIndex.getItemCount() == 0) {
                this.fGpibBoardIndex.addItem((Object)"0");
                this.fGpibBoardIndex.setSelectedIndex(0);
            }
        } else if (jComponent.equals(this.fGpibBoardIndex)) {
            try {
                int n = TMStringUtil.str2int((String)((String)this.fGpibBoardIndex.getSelectedItem()));
                if (n < 0) {
                    this.fGpibBoardIndex.setSelectedItem((Object)this.fLasttBoardIndex);
                    return;
                }
            }
            catch (Exception exception) {
                this.fGpibBoardIndex.setSelectedItem((Object)this.fLasttBoardIndex);
                return;
            }
            this.updateComboBoxValues(this.fGpibPrimaryAddress, (String[])sBidsAndPads.get((String)this.fGpibVendor.getSelectedItem() + this.fGpibBoardIndex.getSelectedItem()));
            if (this.fGpibPrimaryAddress.getItemCount() == 0) {
                this.fGpibPrimaryAddress.addItem((Object)"1");
                this.fGpibPrimaryAddress.setSelectedIndex(0);
            }
            this.fLasttBoardIndex = (String)this.fGpibBoardIndex.getSelectedItem();
        } else if (jComponent.equals(this.fGpibPrimaryAddress)) {
            try {
                int n = TMStringUtil.str2int((String)((String)this.fGpibPrimaryAddress.getSelectedItem()));
                if (n < 1 || n > 30) {
                    this.fGpibPrimaryAddress.setSelectedItem((Object)this.fLasttPrimaryAddress);
                    return;
                }
            }
            catch (Exception exception) {
                this.fGpibPrimaryAddress.setSelectedItem((Object)this.fLasttPrimaryAddress);
                return;
            }
            this.fLasttPrimaryAddress = (String)this.fGpibPrimaryAddress.getSelectedItem();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.fDriverComboBox.getSelectedItem() == null) {
            return;
        }
        Object object = sAllMatlabDrivers.get(this.fDriverComboBox.getSelectedItem());
        if (object == null) {
            return;
        }
        this.fDriverComboBox.setToolTipText(object.toString());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.fDriverComboBox.setToolTipText(null);
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        if (this.fInterfaceBox == null) {
            return;
        }
        this.updateInterfaceComboBox();
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
    }

    private void updateGUIWithDriverInfo() {
        try {
            String string = (String)sAllMatlabDrivers.get(this.fDriverComboBox.getSelectedItem());
            Parser parser = new Parser(string);
            parser.parse();
            this.fDriverType = parser.getDriverTypeId();
            parser.dispose();
        }
        catch (Exception exception) {
            this.fDriverType = 0;
        }
        if (this.fDriverType == 0) {
            this.fInterfaceBox.setEnabled(true);
            this.fInterfaceBox.setEditable(false);
            this.fCreateButton.setEnabled(true);
            this.fCreateButton.setVisible(true);
            this.fInterfaceLabel.setText(this.fInterfaceText);
            this.updateInterfaceComboBox();
            this.updateInterfacePanel((JComponent)this.fInterfaceField, (JComponent)this.fInterfaceBox);
        } else {
            this.fInterfaceLabel.setText(this.fResourceNameText);
            this.fCreateButton.setEnabled(false);
            this.fCreateButton.setVisible(false);
            this.updateInterfacePanel((JComponent)this.fInterfaceBox, (JComponent)this.fInterfaceField);
            this.validate();
            this.repaint();
        }
    }

    private void updateInterfaceComboBox() {
        Instrument instrument = this.getInstrument();
        this.fInstrumentObjects.clear();
        this.fInterfaceBox.removeAllItems();
        Vector<Instrument> vector = Instrument.getNonLockedObjects();
        String string = "";
        Instrument instrument2 = null;
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            instrument2 = vector.elementAt(i);
            string = this.getInstrumentNameForComboBox(instrument2.getName());
            if (string.equals("Serial-TEMP")) continue;
            this.fInterfaceBox.addItem((Object)string);
            this.fInstrumentObjects.put(instrument2, string);
            if (!instrument2.equals(instrument)) continue;
            n = i;
        }
        if (n != -1) {
            this.fInterfaceBox.setSelectedIndex(n);
        } else if (this.fInterfaceBox.getItemCount() > 0) {
            this.fInterfaceBox.setSelectedIndex(0);
        }
    }

    private String getInstrumentNameForComboBox(String string) {
        int n = 0;
        for (int i = 0; i < this.fInterfaceBox.getItemCount(); ++i) {
            String string2 = (String)this.fInterfaceBox.getItemAt(i);
            if (!string2.equals(string) && !string2.startsWith(string + " (")) continue;
            ++n;
        }
        if (n == 0) {
            return string;
        }
        return string + " (" + n + ")";
    }

    private void updateInterfacePanel(JComponent jComponent, JComponent jComponent2) {
        if (jComponent2.getParent() != null) {
            return;
        }
        this.fInterfacePanelHolder.remove((Component)jComponent);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.fInterfacePanelHolder.add((Component)jComponent2, (Object)gridBagConstraints);
        this.repaint();
    }

    private Instrument getInstrument() {
        String string = (String)this.fInterfaceBox.getSelectedItem();
        if (string == null) {
            return null;
        }
        Enumeration<Instrument> enumeration = this.fInstrumentObjects.keys();
        while (enumeration.hasMoreElements()) {
            Instrument instrument = enumeration.nextElement();
            String string2 = this.fInstrumentObjects.get(instrument);
            if (!string2.equals(string)) continue;
            return instrument;
        }
        return null;
    }

    private Object getSecondArgumentForDeviceConstructor() {
        if (this.fDriverType == 0) {
            return this.getInstrument();
        }
        return this.fInterfaceField.getText();
    }

    private int createLoadDialog() {
        try {
            TMFileDialog tMFileDialog = new TMFileDialog(sResources.getString("NewObject.LoadDialog.Title"), "mdd", "MATLAB Instrument Driver (*.mdd)");
            tMFileDialog.setCurrentDirectory(new File(Instrument.getPreferenceFile().read("SaveDirectory")));
            int n = tMFileDialog.showDialog(1, new MJFrame());
            if (n == 0) {
                String string = tMFileDialog.getSelectedFile().getAbsolutePath();
                String string2 = DriverUtil.parseDriverName(string);
                if (sAllMatlabDrivers.contains(string)) {
                    this.fDriverComboBox.setSelectedItem((Object)string2);
                } else if (sAllMatlabDrivers.keySet().contains(string2)) {
                    int n2 = 1;
                    while (sAllMatlabDrivers.keySet().contains(string2 + " (" + n2 + ")")) {
                        ++n2;
                    }
                    sAllMatlabDrivers.put(string2 + " (" + n2 + ")", string);
                    sBrowsedDrivers.put(string2 + " (" + n2 + ")", string);
                    this.fDriverComboBox.addItem((Object)(string2 + " (" + n2 + ")"));
                    this.fDriverComboBox.setSelectedItem((Object)(string2 + " (" + n2 + ")"));
                } else {
                    sAllMatlabDrivers.put(string2, string);
                    sBrowsedDrivers.put(string2, string);
                    this.fDriverComboBox.addItem((Object)string2);
                    this.fDriverComboBox.setSelectedItem((Object)string2);
                }
                Instrument.getPreferenceFile().update("SaveDirectory", tMFileDialog.getSelectedFile().getParentFile().getPath());
            }
            return n;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private void updateComboBoxValues(MJComboBox mJComboBox, String[] stringArray) {
        mJComboBox.removeAllItems();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            mJComboBox.addItem((Object)stringArray[i]);
        }
        if (stringArray.length != 0) {
            mJComboBox.setSelectedIndex(0);
        }
    }

    private boolean isValidDriverName() {
        if (this.fDriverComboBox.getSelectedIndex() < 0) {
            TMStringUtil.error((MJFrame)this.getFrame(), (String)sResources.getString("NewObject.ErrorDialog.Title"), (String)sResources.getString("NewObject.ErrorDialog.Message"));
            return false;
        }
        return true;
    }

    @Override
    public boolean createObject(int n) {
        if (this.fInstrumentObjType == 2) {
            if (!this.isValidDriverName()) {
                return false;
            }
            this.fMatlabArgs = new Object[4];
            this.fMatlabArgs[0] = "privateCreateObjHelper";
            this.fMatlabArgs[1] = "device";
            this.fMatlabArgs[2] = sAllMatlabDrivers.get(this.fDriverComboBox.getSelectedItem()).toString();
            this.fMatlabArgs[3] = this.getSecondArgumentForDeviceConstructor();
            this.createObjectWorker.start();
            return true;
        }
        if (PlatformInfo.isLinux()) {
            switch (n) {
                case 0: {
                    this.fMatlabArgs = new Object[4];
                    this.fMatlabArgs[0] = "privateCreateObjHelper";
                    this.fMatlabArgs[1] = "tcpip";
                    this.fMatlabArgs[2] = this.fTcpipRemoteHost.getText();
                    this.fMatlabArgs[3] = this.fTcpipRemotePort.getText();
                    break;
                }
                case 1: {
                    this.fMatlabArgs = new Object[4];
                    this.fMatlabArgs[0] = "privateCreateObjHelper";
                    this.fMatlabArgs[1] = "udp";
                    this.fMatlabArgs[2] = this.fUdpRemoteHost.getText();
                    this.fMatlabArgs[3] = this.fUdpRemotePort.getText();
                    break;
                }
                case 2: {
                    this.fMatlabArgs = new Object[3];
                    this.fMatlabArgs[0] = "privateCreateObjHelper";
                    this.fMatlabArgs[1] = "serial";
                    this.fMatlabArgs[2] = this.fAvailableSerialPorts.getSelectedItem();
                    break;
                }
                case 3: {
                    this.fMatlabArgs = new Object[4];
                    this.fMatlabArgs[0] = "privateCreateObjHelper";
                    this.fMatlabArgs[1] = "device";
                    this.fMatlabArgs[2] = sAllMatlabDrivers.get(this.fDriverComboBox.getSelectedItem()).toString();
                    this.fMatlabArgs[3] = this.getSecondArgumentForDeviceConstructor();
                    if (this.isValidDriverName()) break;
                    return false;
                }
            }
            this.createObjectWorker.start();
            return true;
        }
        switch (n) {
            case 0: {
                this.fMatlabArgs = new Object[5];
                this.fMatlabArgs[0] = "privateCreateObjHelper";
                this.fMatlabArgs[1] = "gpib";
                this.fMatlabArgs[2] = this.fGpibVendor.getSelectedItem();
                this.fMatlabArgs[3] = this.fGpibBoardIndex.getSelectedItem();
                this.fMatlabArgs[4] = this.fGpibPrimaryAddress.getSelectedItem();
                break;
            }
            case 1: {
                this.fMatlabArgs = new Object[4];
                this.fMatlabArgs[0] = "privateCreateObjHelper";
                this.fMatlabArgs[1] = "visa";
                this.fMatlabArgs[2] = this.fVisaVendor.getSelectedItem();
                this.fMatlabArgs[3] = this.fVisaRsrcName.getSelectedItem();
                break;
            }
            case 4: {
                this.fMatlabArgs = new Object[3];
                this.fMatlabArgs[0] = "privateCreateObjHelper";
                this.fMatlabArgs[1] = "serial";
                this.fMatlabArgs[2] = this.fAvailableSerialPorts.getSelectedItem();
                break;
            }
            case 5: {
                this.fMatlabArgs = new Object[4];
                this.fMatlabArgs[0] = "privateCreateObjHelper";
                this.fMatlabArgs[1] = "Bluetooth";
                String[] stringArray = new String[]{"", ""};
                String string = (String)this.fAvailableBluetoothDevices.getSelectedItem();
                if (!string.equals(sBluetoothAdaptorOrDevicesNotDetected)) {
                    if (!string.contains("[check device, rescan]")) {
                        try {
                            stringArray = string.split(" \\[Channel: ");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        String[] stringArray2 = string.split("\\[check device, rescan\\]");
                        stringArray[0] = stringArray2[0];
                        stringArray[1] = "0]";
                    }
                    try {
                        Long.parseLong(stringArray[0], 16);
                        this.fMatlabArgs[2] = "btspp://" + stringArray[0];
                    }
                    catch (Exception exception) {
                        this.fMatlabArgs[2] = stringArray[0];
                    }
                    this.fMatlabArgs[3] = Character.valueOf(stringArray[1].charAt(0));
                    break;
                }
                this.fMatlabArgs[2] = "";
                this.fMatlabArgs[3] = "";
                break;
            }
            case 2: {
                this.fMatlabArgs = new Object[4];
                this.fMatlabArgs[0] = "privateCreateObjHelper";
                this.fMatlabArgs[1] = "tcpip";
                this.fMatlabArgs[2] = this.fTcpipRemoteHost.getText();
                this.fMatlabArgs[3] = this.fTcpipRemotePort.getText();
                break;
            }
            case 3: {
                this.fMatlabArgs = new Object[4];
                this.fMatlabArgs[0] = "privateCreateObjHelper";
                this.fMatlabArgs[1] = "udp";
                this.fMatlabArgs[2] = this.fUdpRemoteHost.getText();
                this.fMatlabArgs[3] = this.fUdpRemotePort.getText();
                break;
            }
            case 6: {
                this.fMatlabArgs = new Object[4];
                this.fMatlabArgs[0] = "privateCreateObjHelper";
                this.fMatlabArgs[1] = "device";
                this.fMatlabArgs[2] = sAllMatlabDrivers.get(this.fDriverComboBox.getSelectedItem()).toString();
                this.fMatlabArgs[3] = this.getSecondArgumentForDeviceConstructor();
                if (this.isValidDriverName()) break;
                return false;
            }
        }
        this.createObjectWorker.start();
        return true;
    }

    private static String[] convertToStringArray(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static {
        sVendorsAndBids = new Hashtable();
        sBidsAndPads = new Hashtable();
        sAllMatlabDrivers = new Hashtable();
        sMatlabDriversOnPath = new Hashtable();
        sBrowsedDrivers = new Hashtable();
        sFirstAdaptorWithBid = -1;
        sGpibNotInstalled = sResources.getString("NewObject.NoGpibVendors");
        sVisaNotInstalled = sResources.getString("NewObject.NoVisaVendors");
        sBluetoothAdaptorOrDevicesNotDetected = sResources.getString("NewObject.NoBluetoothAdaptorOrDevices");
    }

    private class CreateObjectWorker
    extends MatlabWorker<Object> {
        private CreateObjectWorker() {
        }

        public Object runOnMatlabThread() {
            String string = null;
            try {
                CreateObjectWorker.feval((String)"instrgate", (Object[])NewObjectDialog.this.fMatlabArgs, (int)0, (boolean)false);
            }
            catch (Exception exception) {
                string = exception.getMessage();
            }
            return string;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (object != null && object instanceof String) {
                TMStringUtil.error((MJFrame)NewObjectDialog.this.getFrame(), (String)ObjectCreationDialog.sResources.getString("NewObject.ErrorDialog.Title"), (String)object.toString());
            }
        }
    }
}

