/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.misc.IOUtils;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.CertificateRevokedException;
import sun.security.provider.certpath.OCSPRequest;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.SerialNumber;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCSPChecker
extends PKIXCertPathChecker {
    public static final String OCSP_ENABLE_PROP = "ocsp.enable";
    public static final String OCSP_URL_PROP = "ocsp.responderURL";
    public static final String OCSP_CERT_SUBJECT_PROP = "ocsp.responderCertSubjectName";
    public static final String OCSP_CERT_ISSUER_PROP = "ocsp.responderCertIssuerName";
    public static final String OCSP_CERT_NUMBER_PROP = "ocsp.responderCertSerialNumber";
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private static final int[] OCSP_NONCE_DATA = new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2};
    private static final ObjectIdentifier OCSP_NONCE_OID = ObjectIdentifier.newInternal(OCSP_NONCE_DATA);
    private int remainingCerts;
    private X509Certificate[] certs;
    private CertPath cp;
    private PKIXParameters pkixParams;
    private boolean onlyEECert = false;

    OCSPChecker(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathValidatorException {
        this(certPath, pKIXParameters, false);
    }

    OCSPChecker(CertPath certPath, PKIXParameters pKIXParameters, boolean bl) throws CertPathValidatorException {
        this.cp = certPath;
        this.pkixParams = pKIXParameters;
        this.onlyEECert = bl;
        List<? extends Certificate> list = this.cp.getCertificates();
        this.certs = list.toArray(new X509Certificate[list.size()]);
        this.init(false);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certs.length + 1;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        --this.remainingCerts;
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8 = null;
            boolean bl = false;
            X500Principal x500Principal = null;
            X500Principal x500Principal2 = null;
            BigInteger bigInteger = null;
            boolean bl2 = true;
            X509CertImpl x509CertImpl = null;
            X509CertImpl x509CertImpl2 = X509CertImpl.toImpl((X509Certificate)certificate);
            if (this.onlyEECert && x509CertImpl2.getBasicConstraints() != -1) {
                if (DEBUG != null) {
                    DEBUG.println("Skipping revocation check, not end entity cert");
                }
                return;
            }
            String[] stringArray = OCSPChecker.getOCSPProperties();
            URL uRL = OCSPChecker.getOCSPServerURL(x509CertImpl2, stringArray);
            if (stringArray[1] != null) {
                x500Principal = new X500Principal(stringArray[1]);
            } else if (stringArray[2] != null && stringArray[3] != null) {
                x500Principal2 = new X500Principal(stringArray[2]);
                object7 = OCSPChecker.stripOutSeparators(stringArray[3]);
                bigInteger = new BigInteger((String)object7, 16);
            } else if (stringArray[2] != null || stringArray[3] != null) {
                throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
            }
            if (x500Principal != null || x500Principal2 != null) {
                bl = true;
            }
            if (this.remainingCerts < this.certs.length) {
                x509CertImpl = X509CertImpl.toImpl(this.certs[this.remainingCerts]);
                bl2 = false;
                if (!bl) {
                    object8 = this.certs[this.remainingCerts];
                    if (DEBUG != null) {
                        DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                    }
                }
            }
            if (bl2 || bl) {
                if (DEBUG != null && bl) {
                    DEBUG.println("Searching trust anchors for responder's certificate");
                }
                if (!(object7 = this.pkixParams.getTrustAnchors().iterator()).hasNext()) {
                    throw new CertPathValidatorException("Must specify at least one trust anchor");
                }
                object6 = x509CertImpl2.getIssuerX500Principal();
                while (object7.hasNext() && (bl2 || bl)) {
                    object5 = (TrustAnchor)object7.next();
                    object4 = ((TrustAnchor)object5).getTrustedCert();
                    object3 = ((X509Certificate)object4).getSubjectX500Principal();
                    if (bl2 && ((X500Principal)object6).equals(object3)) {
                        x509CertImpl = X509CertImpl.toImpl((X509Certificate)object4);
                        bl2 = false;
                        if (!bl && object8 == null) {
                            object8 = object4;
                            if (DEBUG != null) {
                                DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                            }
                        }
                    }
                    if (!bl || (x500Principal == null || !x500Principal.equals(object3)) && (x500Principal2 == null || bigInteger == null || !x500Principal2.equals(((X509Certificate)object4).getIssuerX500Principal()) || !bigInteger.equals(((X509Certificate)object4).getSerialNumber()))) continue;
                    object8 = object4;
                    bl = false;
                }
                if (x509CertImpl == null) {
                    throw new CertPathValidatorException("No trusted certificate for " + x509CertImpl2.getIssuerDN());
                }
                if (bl) {
                    if (DEBUG != null) {
                        DEBUG.println("Searching cert stores for responder's certificate");
                    }
                    object5 = null;
                    if (x500Principal != null) {
                        object5 = new X509CertSelector();
                        ((X509CertSelector)object5).setSubject(x500Principal.getName());
                    } else if (x500Principal2 != null && bigInteger != null) {
                        object5 = new X509CertSelector();
                        ((X509CertSelector)object5).setIssuer(x500Principal2.getName());
                        ((X509CertSelector)object5).setSerialNumber(bigInteger);
                    }
                    if (object5 != null) {
                        object4 = this.pkixParams.getCertStores();
                        object3 = AlgorithmChecker.getInstance();
                        object2 = object4.iterator();
                        while (object2.hasNext()) {
                            CertStore certStore = (CertStore)object2.next();
                            for (Certificate object9 : certStore.getCertificates((CertSelector)object5)) {
                                try {
                                    AlgorithmChecker.check(object9);
                                    object8 = (X509Certificate)object9;
                                    bl = false;
                                    break;
                                }
                                catch (CertPathValidatorException serialNumber) {
                                    if (DEBUG == null) continue;
                                    DEBUG.println("OCSP responder certificate algorithm check failed: " + serialNumber);
                                }
                            }
                            if (bl) continue;
                            break;
                        }
                    }
                }
            }
            if (bl) {
                throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
            }
            object7 = new OCSPRequest(x509CertImpl2, x509CertImpl);
            object6 = (HttpURLConnection)uRL.openConnection();
            if (DEBUG != null) {
                DEBUG.println("connecting to OCSP service at: " + uRL);
            }
            ((URLConnection)object6).setDoOutput(true);
            ((URLConnection)object6).setDoInput(true);
            ((HttpURLConnection)object6).setRequestMethod("POST");
            ((URLConnection)object6).setRequestProperty("Content-type", "application/ocsp-request");
            object5 = ((OCSPRequest)object7).encodeBytes();
            object4 = ((OCSPRequest)object7).getCertId();
            ((URLConnection)object6).setRequestProperty("Content-length", String.valueOf(((Object)object5).length));
            object3 = ((URLConnection)object6).getOutputStream();
            ((OutputStream)object3).write((byte[])object5);
            ((OutputStream)object3).flush();
            if (DEBUG != null && ((HttpURLConnection)object6).getResponseCode() != 200) {
                DEBUG.println("Received HTTP error: " + ((HttpURLConnection)object6).getResponseCode() + " - " + ((HttpURLConnection)object6).getResponseMessage());
            }
            object2 = ((URLConnection)object6).getInputStream();
            int n = ((URLConnection)object6).getContentLength();
            Object object10 = IOUtils.readFully((InputStream)object2, n, false);
            ((InputStream)object2).close();
            ((OutputStream)object3).close();
            OCSPResponse oCSPResponse = new OCSPResponse((byte[])object10, this.pkixParams, (X509Certificate)object8);
            if (!((CertId)object4).equals(oCSPResponse.getCertId())) {
                throw new CertPathValidatorException("Certificate in the OCSP response does not match the certificate supplied in the OCSP request.");
            }
            SerialNumber serialNumber = x509CertImpl2.getSerialNumberObject();
            int n2 = oCSPResponse.getCertStatus(serialNumber);
            if (DEBUG != null) {
                DEBUG.println("Status of certificate (with serial number " + serialNumber.getNumber() + ") is: " + OCSPResponse.certStatusToText(n2));
            }
            if (n2 == 1) {
                throw new CertificateRevokedException("Certificate has been revoked", this.cp, this.remainingCerts - 1);
            }
            if (n2 == 2) {
                throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.cp, this.remainingCerts - 1);
            }
        }
        catch (CertificateRevokedException certificateRevokedException) {
            throw certificateRevokedException;
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw certPathValidatorException;
        }
        catch (Exception exception) {
            throw new CertPathValidatorException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static URL getOCSPServerURL(X509CertImpl x509CertImpl, String[] stringArray) throws CertificateParsingException, CertPathValidatorException {
        if (stringArray[0] != null) {
            try {
                return new URL(stringArray[0]);
            }
            catch (MalformedURLException malformedURLException) {
                throw new CertPathValidatorException(malformedURLException);
            }
        }
        AuthorityInfoAccessExtension authorityInfoAccessExtension = x509CertImpl.getAuthorityInfoAccessExtension();
        if (authorityInfoAccessExtension == null) {
            throw new CertPathValidatorException("Must specify the location of an OCSP Responder");
        }
        try {
            List list = (List)authorityInfoAccessExtension.get("descriptions");
            for (AccessDescription accessDescription : list) {
                GeneralName generalName;
                if (!accessDescription.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = accessDescription.getAccessLocation()).getType() != 6) continue;
                try {
                    URIName uRIName = (URIName)generalName.getName();
                    return new URL(uRIName.getName());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new CertPathValidatorException(malformedURLException);
                    throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
    }

    private static String[] getOCSPProperties() {
        final String[] stringArray = new String[4];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                stringArray[0] = Security.getProperty(OCSPChecker.OCSP_URL_PROP);
                stringArray[1] = Security.getProperty(OCSPChecker.OCSP_CERT_SUBJECT_PROP);
                stringArray[2] = Security.getProperty(OCSPChecker.OCSP_CERT_ISSUER_PROP);
                stringArray[3] = Security.getProperty(OCSPChecker.OCSP_CERT_NUMBER_PROP);
                return null;
            }
        });
        return stringArray;
    }

    private static String stripOutSeparators(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < cArray.length; ++i) {
            if (HEX_DIGITS.indexOf(cArray[i]) == -1) continue;
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }
}

