/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.common.icons;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.mathworks.common.icons.IconContainer;
import com.mathworks.util.StringUtils;
import com.mathworks.util.logger.Log;
import java.util.Map;
import javax.swing.ImageIcon;

public class IconEnumerationUtils {
    private static final Log LOG = Log.getInstance((String)"com.mathworks.common.icons.IconEnumerationUtils");
    private static final Map<String, ImageIcon> ICON_CACHE = new MapMaker().softValues().makeMap();
    private static final String COMMON_ICONS = "/com/mathworks/common/icons/resources/";
    private static final String COMMON_PACKAGE = "com.mathworks.common.icons.";

    private IconEnumerationUtils() {
    }

    public static boolean isValidCommonKey(String string) {
        return IconEnumerationUtils.isValidKey(COMMON_PACKAGE, string);
    }

    public static boolean isValidKey(String string) {
        return IconEnumerationUtils.isValidCommonKey(string);
    }

    public static boolean isValidKey(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("'packageName' cannot be null or empty");
        }
        boolean bl = false;
        if (string2 != null && string2.matches("[A-Z][A-Za-z]*\\.[A-Z0-9x_]*")) {
            bl = IconEnumerationUtils.doFindIcon(string, string2, false) != null;
        }
        return bl;
    }

    public static ImageIcon findCommonIcon(String string) {
        return IconEnumerationUtils.findIcon(COMMON_PACKAGE, string);
    }

    public static ImageIcon findIcon(String string) {
        return IconEnumerationUtils.findCommonIcon(string);
    }

    public static ImageIcon findIcon(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("'packageName' cannot be null or empty");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("'key' cannot be null or empty");
        }
        int n = string2.indexOf(46);
        if (n == -1) {
            throw new IllegalArgumentException("'key' must be of the form \"EnumName.ICON_NAME\"");
        }
        return IconEnumerationUtils.doFindIcon(string, string2, true);
    }

    private static ImageIcon doFindIcon(String string, String string2, boolean bl) {
        int n = string2.indexOf(46);
        assert (n != -1);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        try {
            if (!string.endsWith(".")) {
                string = string + ".";
            }
            Class<?> clazz = Class.forName(string + string3);
            IconContainer iconContainer = (IconContainer)Enum.valueOf(clazz, string4);
            return iconContainer.getIcon();
        }
        catch (Exception exception) {
            if (bl) {
                LOG.warn("Couldn't find icon %s in package %s", new Object[]{string2, string});
            }
            return null;
        }
    }

    public static ImageIcon getIcon(String string) {
        return IconEnumerationUtils.getIcon(COMMON_ICONS, string);
    }

    public static ImageIcon getIcon(String string, String string2) {
        return IconEnumerationUtils.getIcon(string, string2, null);
    }

    public static ImageIcon getIcon(String string, String string2, ClassLoader classLoader) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)string) ? 1 : 0) != 0, (Object)"'path' cannot be null or empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)string2) ? 1 : 0) != 0, (Object)"'fileName' cannot be null or empty");
        Preconditions.checkArgument((string.indexOf(92) == -1 ? 1 : 0) != 0, (String)"'path' %s should not use windows-style separators", (Object[])new Object[]{string});
        Preconditions.checkArgument((string2.indexOf(47) == -1 && string2.indexOf(92) == -1 ? 1 : 0) != 0, (String)"'filename' %s should not contain path information", (Object[])new Object[]{string2});
        if (string2.indexOf(46) == -1) {
            string2 = string2 + ".png";
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return IconEnumerationUtils.getIconFromCache(string + string2, classLoader);
    }

    public static ImageIcon getIcon(String string, ClassLoader classLoader) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)string) ? 1 : 0) != 0, (Object)"'fullPath' cannot be null or empty");
        Preconditions.checkArgument((string.indexOf(92) == -1 ? 1 : 0) != 0, (String)"'fullPath' %s should not use windows-style separators", (Object[])new Object[]{string});
        return IconEnumerationUtils.getIconFromCache(string, classLoader);
    }

    private static ImageIcon getIconFromCache(String string, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = IconEnumerationUtils.class.getClassLoader();
        }
        try {
            String string2;
            ImageIcon imageIcon;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if ((imageIcon = ICON_CACHE.get(string2 = string + ":" + classLoader.hashCode())) == null) {
                imageIcon = new ImageIcon(classLoader.getResource(string));
                ICON_CACHE.put(string2, imageIcon);
            }
            return imageIcon;
        }
        catch (Throwable throwable) {
            LOG.warn("Couldn't find icon '%s'", new Object[]{string});
            return null;
        }
    }
}

