/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolstrip.components.gallery.GalleryIcon;
import com.mathworks.toolstrip.components.gallery.GalleryResources;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class CategoryHeader {
    private final MJPanel fComponent;
    private final MJLabel fLabel;
    private final Category fCategory;
    private final Runnable fMoveToTopCode;
    private boolean fMinimalAppearance;
    private JLabel fTopLabel;
    private MJButton fMoveToTopButton;

    CategoryHeader(Category category, Runnable runnable) {
        this.fCategory = category;
        this.fMoveToTopCode = runnable;
        this.fLabel = new MJLabel(category.getLabel().toUpperCase(Locale.ENGLISH));
        this.fLabel.setOpaque(false);
        this.fLabel.setFont(this.fMinimalAppearance ? ToolstripTheme.getInstance().getGalleryReducedHeaderFont() : ToolstripTheme.getInstance().getGalleryHeaderFont());
        this.fLabel.setForeground(ToolstripTheme.getInstance().getGalleryHeaderColor());
        this.fMoveToTopButton = this.createMoveToTopButton();
        this.fTopLabel = this.createTopLabel();
        this.fComponent = new MJPanel(){

            public void paintComponent(Graphics graphics) {
                if (!CategoryHeader.this.fMinimalAppearance) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    int n = this.getHeight();
                    int n2 = this.getWidth();
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, ToolstripTheme.getInstance().getGalleryHeaderFromColor(), 0.0f, n, ToolstripTheme.getInstance().getGalleryHeaderToColor()));
                    graphics2D.fillRect(0, 0, n2, n);
                }
            }
        };
        this.fComponent.setName("CategoryHeader_" + category.getName());
        this.fComponent.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.fComponent.setOpaque(!this.fMinimalAppearance);
        if (!this.fCategory.equals(Category.FAVORITES)) {
            this.buildNonFavorites();
        } else {
            this.buildFavorites();
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    void setMinimalAppearance(boolean bl) {
        if (bl != this.fMinimalAppearance) {
            if (bl) {
                this.fComponent.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
                this.fLabel.setForeground(ToolstripTheme.getInstance().getGalleryTitleColor());
                this.fMoveToTopButton.setIcon((Icon)GalleryIcon.MOVE_TO_TOP_ICON_ICON_VIEW.getIcon());
                this.fTopLabel.setForeground(ToolstripTheme.getInstance().getGalleryTopLabelForegroundIconView());
            } else {
                this.fComponent.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
                this.fLabel.setForeground(ToolstripTheme.getInstance().getGalleryHeaderColor());
                this.fMoveToTopButton.setIcon((Icon)GalleryIcon.MOVE_TO_TOP_ICON_DETAILS_VIEW.getIcon());
                this.fTopLabel.setForeground(ToolstripTheme.getInstance().getGalleryTopLabelForegroundDetailsView());
            }
            this.fMinimalAppearance = bl;
            this.fComponent.setOpaque(!this.fMinimalAppearance);
            this.fComponent.repaint();
        }
    }

    private void buildNonFavorites() {
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.setLayout((LayoutManager)new FormLayout("2dlu, fill:d, 2dlu:grow, fill:d, 2dlu, p, 2dlu", "25px"));
        this.fComponent.add((Component)this.fLabel, (Object)cellConstraints.xy(2, 1));
        this.fComponent.add((Component)this.fTopLabel, (Object)cellConstraints.xy(4, 1));
        this.fComponent.add((Component)this.fMoveToTopButton, (Object)cellConstraints.xy(6, 1));
    }

    private void buildFavorites() {
        CellConstraints cellConstraints = new CellConstraints();
        this.fLabel.setIcon((Icon)GalleryIcon.FAVORITES_CATEGORY_ICON.getIcon());
        this.fComponent.setLayout((LayoutManager)new FormLayout("2dlu, fill:d, 2dlu:grow", "25px"));
        this.fComponent.add((Component)this.fLabel, (Object)cellConstraints.xy(2, 1));
    }

    private JLabel createTopLabel() {
        MJLabel mJLabel = new MJLabel(GalleryResources.getString("top.label"));
        mJLabel.setEnabled(this.fMoveToTopCode != null);
        mJLabel.setOpaque(false);
        mJLabel.setForeground(this.fMinimalAppearance ? ToolstripTheme.getInstance().getGalleryTopLabelForegroundIconView() : ToolstripTheme.getInstance().getGalleryTopLabelForegroundDetailsView());
        mJLabel.setFont(mJLabel.getFont().deriveFont(8.0f));
        mJLabel.setVisible(this.fMoveToTopCode != null);
        return mJLabel;
    }

    private MJButton createMoveToTopButton() {
        MJButton mJButton = new MJButton((Icon)(this.fMinimalAppearance ? GalleryIcon.MOVE_TO_TOP_ICON_ICON_VIEW.getIcon() : GalleryIcon.MOVE_TO_TOP_ICON_DETAILS_VIEW.getIcon()));
        mJButton.setName("MoveToTop_" + this.fCategory.getName());
        mJButton.setFocusable(false);
        mJButton.setFocusPainted(false);
        mJButton.setOpaque(false);
        mJButton.setFlyOverAppearance(true);
        mJButton.setMargin(new Insets(3, 2, 3, 2));
        if (this.fMoveToTopCode == null) {
            mJButton.setVisible(false);
        } else {
            mJButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CategoryHeader.this.fMoveToTopCode.run();
                }
            });
        }
        return mJButton;
    }
}

