/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.popupview.CategoryContentPanel;
import com.mathworks.toolstrip.components.gallery.popupview.GallerySelectionModel;
import com.mathworks.toolstrip.components.gallery.popupview.ItemPanel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class CategoryListPanel
extends CategoryContentPanel {
    private List<ItemPanel> fItemPanels = new ArrayList<ItemPanel>();
    private Dragger fDragger;
    private static final int DRAG_THRESHOLD = 6;

    CategoryListPanel(Category category, GalleryModel galleryModel, GallerySelectionModel gallerySelectionModel, PopupMenuCustomizer popupMenuCustomizer, Runnable runnable) {
        super(category, galleryModel, gallerySelectionModel, popupMenuCustomizer, runnable);
        this.init();
    }

    private void init() {
        this.setLayout(null);
        for (Item item : this.fModel.getItems(this.fCategory)) {
            ItemPanel itemPanel = new ItemPanel(this.fModel, this.fSelectionModel, this.fCategory, item, this.fFavoritesAnimation);
            this.fItemPanels.add(itemPanel);
            this.add(itemPanel.getComponent());
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        for (ItemPanel itemPanel : this.fItemPanels) {
            Dimension dimension2 = itemPanel.getComponent().getPreferredSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            dimension.height += dimension2.height;
        }
        return dimension;
    }

    public void doLayout() {
        int n = 0;
        for (ItemPanel itemPanel : this.fItemPanels) {
            int n2 = itemPanel.getComponent().getPreferredSize().height;
            itemPanel.getComponent().setBounds(0, n, this.getWidth(), n2);
            n += n2;
        }
        if (this.fDragger != null && this.fDragger.iDragLayer != null) {
            this.fDragger.iDragLayer.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    void setDragEnabled(boolean bl) {
        if (bl) {
            if (this.fDragger == null) {
                this.fDragger = new Dragger();
                for (ItemPanel itemPanel : this.fItemPanels) {
                    itemPanel.getComponent().addMouseListener(this.fDragger);
                    itemPanel.getComponent().addMouseMotionListener(this.fDragger);
                }
            }
        } else if (this.fDragger != null) {
            for (ItemPanel itemPanel : this.fItemPanels) {
                itemPanel.getComponent().removeMouseListener(this.fDragger);
                itemPanel.getComponent().removeMouseMotionListener(this.fDragger);
            }
            this.fDragger = null;
        }
    }

    @Override
    void setActionListener(ActionListener actionListener) {
        for (ItemPanel itemPanel : this.fItemPanels) {
            itemPanel.setActionListener(actionListener);
        }
    }

    @Override
    void setCloseListener(ActionListener actionListener) {
        for (ItemPanel itemPanel : this.fItemPanels) {
            itemPanel.setCloseListener(actionListener);
        }
    }

    @Override
    Item getItemAtPoint(Point point) {
        ItemPanel itemPanel = this.getItemPanelAt(point);
        return itemPanel == null ? null : itemPanel.getItem();
    }

    private ItemPanel getItemPanelAt(Point point) {
        if (this.contains(point)) {
            for (ItemPanel itemPanel : this.fItemPanels) {
                Point point2 = SwingUtilities.convertPoint((Component)((Object)this), point, itemPanel.getComponent());
                if (!itemPanel.getComponent().contains(point2)) continue;
                return itemPanel;
            }
        }
        return null;
    }

    @Override
    public Component getComponentForItem(Item item) {
        for (ItemPanel itemPanel : this.fItemPanels) {
            if (!itemPanel.getItem().equals(item)) continue;
            return itemPanel.getComponent();
        }
        return null;
    }

    @Override
    Item getNextItem(Item item) {
        if (item == null) {
            for (ItemPanel itemPanel : this.fItemPanels) {
                if (itemPanel.getItem() == null || !itemPanel.getItem().isEnabled()) continue;
                return itemPanel.getItem();
            }
        }
        Object object = null;
        for (int i = 0; i < this.fItemPanels.size(); ++i) {
            ItemPanel itemPanel = this.fItemPanels.get(i);
            if (!itemPanel.getItem().equals(item) || i + 1 >= this.fItemPanels.size()) continue;
            object = this.fItemPanels.get(i + 1).getItem();
            if (((Item)object).isEnabled()) break;
            int n = 2;
            boolean bl = false;
            while (!bl && i + n <= this.fItemPanels.size() - 1) {
                Item item2 = this.fItemPanels.get(i + n).getItem();
                if (item2.isEnabled()) {
                    object = item2;
                    bl = true;
                    continue;
                }
                object = null;
                ++n;
            }
        }
        if (object != null && !((Item)object).isEnabled()) {
            object = null;
        }
        return object;
    }

    @Override
    Item getPreviousItem(Item item) {
        if (item == null) {
            for (int i = this.fItemPanels.size() - 1; i >= 0; --i) {
                if (this.fItemPanels.get(i).getItem() == null || !this.fItemPanels.get(i).getItem().isEnabled()) continue;
                return this.fItemPanels.get(i).getItem();
            }
        }
        Item item2 = null;
        for (int i = 0; i < this.fItemPanels.size(); ++i) {
            ItemPanel itemPanel = this.fItemPanels.get(i);
            if (!itemPanel.getItem().equals(item) || i - 1 < 0) continue;
            item2 = this.fItemPanels.get(i - 1).getItem();
            if (item2.isEnabled()) break;
            int n = 2;
            boolean bl = false;
            while (!bl && i - n >= 0) {
                Item item3 = this.fItemPanels.get(i - n).getItem();
                if (item3.isEnabled()) {
                    item2 = item3;
                    bl = true;
                    continue;
                }
                item2 = null;
                ++n;
            }
        }
        if (item2 != null && !item2.isEnabled()) {
            item2 = null;
        }
        return item2;
    }

    private int getIndexAt(Point point) {
        if (point.y < 0) {
            return 0;
        }
        if (point.y > this.getHeight()) {
            return this.fItemPanels.size();
        }
        ItemPanel itemPanel = this.getItemPanelAt(point);
        return itemPanel == null ? -1 : this.fItemPanels.indexOf(itemPanel);
    }

    @Override
    public void dispose() {
        for (ItemPanel itemPanel : this.fItemPanels) {
            itemPanel.dispose();
        }
        this.fItemPanels.clear();
    }

    private class DragLayer
    extends JComponent {
        private DragLayer() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.33f));
            graphics2D.setColor(Color.lightGray);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setComposite(composite);
            if (CategoryListPanel.this.fDragger.iDropIndex != -1) {
                boolean bl;
                int n = CategoryListPanel.this.fDragger.iDropIndex;
                boolean bl2 = bl = CategoryListPanel.this.fDragger.iDropIndex == CategoryListPanel.this.fItemPanels.size();
                if (bl) {
                    --n;
                }
                ItemPanel itemPanel = (ItemPanel)CategoryListPanel.this.fItemPanels.get(n);
                int n2 = Math.max(2, itemPanel.getComponent().getY());
                if (bl) {
                    n2 += itemPanel.getComponent().getHeight() - 2 - 1;
                }
                graphics2D.setColor(Color.darkGray);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.drawLine(0, n2, this.getWidth(), n2);
            }
            graphics2D.drawImage((Image)CategoryListPanel.this.fDragger.iDragImage, ((Dragger)((CategoryListPanel)CategoryListPanel.this).fDragger).iDragImageRect.x, ((Dragger)((CategoryListPanel)CategoryListPanel.this).fDragger).iDragImageRect.y, null);
        }
    }

    private class Dragger
    extends MouseInputAdapter {
        private int iPressedY = -1;
        private ItemPanel iPressedPanel;
        private boolean iIsDragging;
        private int iInitialCenterY = -1;
        private int iInitialIndex;
        private int iDropIndex;
        private JComponent iDragLayer;
        private Rectangle iDragImageRect;
        private BufferedImage iDragImage;

        private Dragger() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)((Object)CategoryListPanel.this));
                this.iPressedPanel = CategoryListPanel.this.getItemPanelAt(point);
                if (this.iPressedPanel != null) {
                    this.iPressedY = point.y;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.iPressedY != -1) {
                int n = SwingUtilities.convertPoint((Component)mouseEvent.getComponent(), (Point)mouseEvent.getPoint(), (Component)((Object)CategoryListPanel.this)).y;
                int n2 = n - this.iPressedY;
                if (!this.iIsDragging) {
                    if (Math.abs(n2) >= 6) {
                        this.startDrag(n2);
                    }
                } else {
                    this.iDragImageRect = this.computeDragRect(n2);
                    int n3 = this.computeDropIndex(n2);
                    if (n3 != this.iDropIndex) {
                        this.iDropIndex = n3;
                    }
                    CategoryListPanel.this.repaint();
                    mouseEvent.consume();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.iIsDragging) {
                    this.endDrag();
                }
                this.iPressedY = -1;
                this.iPressedPanel = null;
            }
        }

        private void startDrag(int n) {
            JComponent jComponent = this.iPressedPanel.getComponent();
            this.iIsDragging = true;
            this.iDropIndex = this.iInitialIndex = CategoryListPanel.this.fItemPanels.indexOf(this.iPressedPanel);
            this.iInitialCenterY = jComponent.getY() + jComponent.getHeight() / 2;
            this.iDragImage = new BufferedImage(jComponent.getWidth(), jComponent.getHeight(), 2);
            Graphics2D graphics2D = this.iDragImage.createGraphics();
            jComponent.setOpaque(false);
            jComponent.paint(graphics2D);
            jComponent.setOpaque(true);
            graphics2D.dispose();
            this.iDragImageRect = this.computeDragRect(n);
            this.iDragLayer = new DragLayer();
            this.iDragLayer.addMouseListener(this);
            CategoryListPanel.this.add(this.iDragLayer, 0);
            CategoryListPanel.this.revalidate();
            CategoryListPanel.this.repaint();
        }

        private void endDrag() {
            CategoryListPanel.this.remove(this.iDragLayer);
            this.iDragLayer.removeMouseListener(this);
            this.iDragLayer = null;
            if (this.iDropIndex > this.iInitialIndex) {
                --this.iDropIndex;
            }
            if (this.iDropIndex != this.iInitialIndex && this.iDropIndex != -1) {
                CategoryListPanel.this.fModel.moveItem(CategoryListPanel.this.fCategory, this.iPressedPanel.getItem(), this.iDropIndex);
            } else {
                CategoryListPanel.this.repaint();
            }
            this.iInitialCenterY = -1;
            this.iIsDragging = false;
            this.iDragImageRect = null;
            this.iDragImage = null;
        }

        private Rectangle computeDragRect(int n) {
            Rectangle rectangle = this.iPressedPanel.getComponent().getBounds();
            rectangle.y += n;
            if (rectangle.y < 0) {
                rectangle.y = 0;
            } else if (rectangle.y + rectangle.height > CategoryListPanel.this.getHeight()) {
                rectangle.y = CategoryListPanel.this.getHeight() - rectangle.height;
            }
            return rectangle;
        }

        private int computeDropIndex(int n) {
            return CategoryListPanel.this.getIndexAt(new Point(0, this.iInitialCenterY + n));
        }
    }
}

